/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.LexerCore;
import gov.nist.core.ParserCore;
import java.text.ParseException;

public class HostNameParser
extends ParserCore {
    private boolean stripAddressScopeZones = false;
    private static final char[] VALID_DOMAIN_LABEL_CHAR = new char[]{'\ufffd', '-', '.'};

    public HostNameParser(String hname) {
        this.lexer = new LexerCore("charLexer", hname);
        this.stripAddressScopeZones = Boolean.getBoolean("gov.nist.core.STRIP_ADDR_SCOPES");
    }

    public HostNameParser(LexerCore lexer) {
        this.lexer = lexer;
        lexer.selectLexer("charLexer");
        this.stripAddressScopeZones = Boolean.getBoolean("gov.nist.core.STRIP_ADDR_SCOPES");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void consumeDomainLabel() throws ParseException {
        if (debug) {
            this.dbg_enter("domainLabel");
        }
        try {
            this.lexer.consumeValidChars(VALID_DOMAIN_LABEL_CHAR);
            Object var2_1 = null;
            if (!debug) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!debug) throw throwable;
            this.dbg_leave("domainLabel");
            throw throwable;
        }
        this.dbg_leave("domainLabel");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String ipv6Reference() throws ParseException {
        String string;
        block15: {
            String string2;
            block13: {
                String string3;
                block12: {
                    StringBuffer retval = new StringBuffer();
                    if (debug) {
                        this.dbg_enter("ipv6Reference");
                    }
                    try {
                        char la;
                        block14: {
                            if (this.stripAddressScopeZones) {
                                char la2;
                                block11: {
                                    while (this.lexer.hasMoreChars()) {
                                        la2 = this.lexer.lookAhead(0);
                                        if (LexerCore.isHexDigit(la2) || la2 == '.' || la2 == ':' || la2 == '[') {
                                            this.lexer.consume(1);
                                            retval.append(la2);
                                            continue;
                                        }
                                        break block11;
                                    }
                                    throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
                                }
                                if (la2 == ']') {
                                    this.lexer.consume(1);
                                    retval.append(la2);
                                    string3 = retval.toString();
                                    Object var7_7 = null;
                                    if (!debug) return string3;
                                    break block12;
                                }
                                if (la2 != '%') throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
                                this.lexer.consume(1);
                                String rest = this.lexer.getRest();
                                if (rest == null) throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
                                if (rest.length() == 0) {
                                    throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
                                }
                                int stripLen = rest.indexOf(93);
                                if (stripLen == -1) {
                                    throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
                                }
                                this.lexer.consume(stripLen + 1);
                                retval.append("]");
                                string2 = retval.toString();
                                break block13;
                            }
                            while (this.lexer.hasMoreChars()) {
                                la = this.lexer.lookAhead(0);
                                if (LexerCore.isHexDigit(la) || la == '.' || la == ':' || la == '[') {
                                    this.lexer.consume(1);
                                    retval.append(la);
                                    continue;
                                }
                                break block14;
                            }
                            throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
                        }
                        if (la != ']') throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
                        this.lexer.consume(1);
                        retval.append(la);
                        string = retval.toString();
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        if (!debug) throw throwable;
                        this.dbg_leave("ipv6Reference");
                        throw throwable;
                    }
                }
                this.dbg_leave("ipv6Reference");
                return string3;
            }
            Object var7_8 = null;
            if (!debug) return string2;
            this.dbg_leave("ipv6Reference");
            return string2;
        }
        Object var7_9 = null;
        if (!debug) return string;
        this.dbg_leave("ipv6Reference");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host host() throws ParseException {
        Host host;
        block8: {
            if (debug) {
                this.dbg_enter("host");
            }
            try {
                int startPtr;
                String hostname;
                if (this.lexer.lookAhead(0) == '[') {
                    hostname = this.ipv6Reference();
                } else if (this.isIPv6Address(this.lexer.getRest())) {
                    startPtr = this.lexer.getPtr();
                    this.lexer.consumeValidChars(new char[]{'\ufffd', ':'});
                    hostname = new StringBuffer("[").append(this.lexer.getBuffer().substring(startPtr, this.lexer.getPtr())).append("]").toString();
                } else {
                    startPtr = this.lexer.getPtr();
                    this.consumeDomainLabel();
                    hostname = this.lexer.getBuffer().substring(startPtr, this.lexer.getPtr());
                }
                if (hostname.length() == 0) {
                    throw new ParseException(this.lexer.getBuffer() + ": Missing host name", this.lexer.getPtr());
                }
                host = new Host(hostname);
                Object var4_4 = null;
                if (!debug) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var4_5 = null;
                    if (!debug) break block9;
                    this.dbg_leave("host");
                }
                throw throwable;
            }
            this.dbg_leave("host");
        }
        return host;
    }

    private boolean isIPv6Address(String uriHeader) {
        String host;
        int firstColonIndex;
        int hostEnd = uriHeader.indexOf(63);
        int semiColonIndex = uriHeader.indexOf(59);
        if (hostEnd == -1 || semiColonIndex != -1 && hostEnd > semiColonIndex) {
            hostEnd = semiColonIndex;
        }
        if (hostEnd == -1) {
            hostEnd = uriHeader.length();
        }
        if ((firstColonIndex = (host = uriHeader.substring(0, hostEnd)).indexOf(58)) == -1) {
            return false;
        }
        int secondColonIndex = host.indexOf(58, firstColonIndex + 1);
        return secondColonIndex != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostPort hostPort(boolean allowWS) throws ParseException {
        HostPort hostPort;
        block13: {
            if (debug) {
                this.dbg_enter("hostPort");
            }
            try {
                Host host = this.host();
                HostPort hp = new HostPort();
                hp.setHost(host);
                if (allowWS) {
                    this.lexer.SPorHT();
                }
                if (this.lexer.hasMoreChars()) {
                    char la = this.lexer.lookAhead(0);
                    switch (la) {
                        case ':': {
                            this.lexer.consume(1);
                            if (allowWS) {
                                this.lexer.SPorHT();
                            }
                            try {
                                String port = this.lexer.number();
                                hp.setPort(Integer.parseInt(port));
                                break;
                            }
                            catch (NumberFormatException nfe) {
                                throw new ParseException(this.lexer.getBuffer() + " :Error parsing port ", this.lexer.getPtr());
                            }
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': 
                        case ',': 
                        case '/': 
                        case ';': 
                        case '>': 
                        case '?': {
                            break;
                        }
                        case '%': {
                            if (this.stripAddressScopeZones) break;
                        }
                        default: {
                            if (allowWS) break;
                            throw new ParseException(this.lexer.getBuffer() + " Illegal character in hostname:" + this.lexer.lookAhead(0), this.lexer.getPtr());
                        }
                    }
                }
                hostPort = hp;
                Object var7_8 = null;
                if (!debug) break block13;
            }
            catch (Throwable throwable) {
                block14: {
                    Object var7_9 = null;
                    if (!debug) break block14;
                    this.dbg_leave("hostPort");
                }
                throw throwable;
            }
            this.dbg_leave("hostPort");
        }
        return hostPort;
    }

    public static void main(String[] args) throws ParseException {
        String[] hostNames = new String[]{"foo.bar.com:1234", "proxima.chaplin.bt.co.uk", "129.6.55.181:2345", ":1234", "foo.bar.com:         1234", "foo.bar.com     :      1234   ", "MIK_S:1234"};
        for (int i = 0; i < hostNames.length; ++i) {
            try {
                HostNameParser hnp = new HostNameParser(hostNames[i]);
                HostPort hp = hnp.hostPort(true);
                System.out.println("[" + hp.encode() + "]");
                continue;
            }
            catch (ParseException ex) {
                System.out.println("exception text = " + ex.getMessage());
            }
        }
    }
}

