/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.Debug;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.MessageParser;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class PipelinedMsgParser
implements Runnable {
    protected SIPMessageListener sipMessageListener;
    private Thread mythread;
    private Pipeline rawInputStream;
    private int maxMessageSize;
    private int sizeCounter;
    private SIPTransactionStack sipStack;
    private static int uid = 0;
    private static Executor postParseExecutor = null;

    protected PipelinedMsgParser() {
    }

    private static synchronized int getNewUid() {
        return uid++;
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener sipMessageListener, Pipeline in, boolean debug, int maxMessageSize) {
        this();
        this.sipStack = sipStack;
        this.sipMessageListener = sipMessageListener;
        this.rawInputStream = in;
        this.maxMessageSize = maxMessageSize;
        this.mythread = new Thread(this);
        this.mythread.setName("PipelineThread-" + PipelinedMsgParser.getNewUid());
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener mhandler, Pipeline in, int maxMsgSize) {
        this(sipStack, mhandler, in, false, maxMsgSize);
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, Pipeline in) {
        this(sipStack, null, in, false, 0);
    }

    public void processInput() {
        this.mythread.start();
    }

    protected Object clone() {
        PipelinedMsgParser p = new PipelinedMsgParser();
        p.rawInputStream = this.rawInputStream;
        p.sipMessageListener = this.sipMessageListener;
        Thread mythread = new Thread(p);
        mythread.setName("PipelineThread");
        return p;
    }

    public void setMessageListener(SIPMessageListener mlistener) {
        this.sipMessageListener = mlistener;
    }

    private String readLine(InputStream inputStream) throws IOException {
        int increment;
        int counter = 0;
        int bufferSize = increment = 1024;
        byte[] lineBuffer = new byte[bufferSize];
        while (true) {
            int i;
            if ((i = inputStream.read()) == -1) {
                throw new IOException("End of stream");
            }
            char ch = (char)(i & 0xFF);
            if (this.maxMessageSize > 0) {
                --this.sizeCounter;
                if (this.sizeCounter <= 0) {
                    throw new IOException("Max size exceeded!");
                }
            }
            if (ch != '\r') {
                lineBuffer[counter++] = (byte)(i & 0xFF);
            }
            if (ch == '\n') break;
            if (counter != bufferSize) continue;
            byte[] tempBuffer = new byte[bufferSize + increment];
            System.arraycopy(lineBuffer, 0, tempBuffer, 0, bufferSize);
            bufferSize += increment;
            lineBuffer = tempBuffer;
        }
        return new String(lineBuffer, 0, counter, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Pipeline inputStream = this.rawInputStream;
        while (true) {
            try {
                SIPMessage sipMessage;
                while (true) {
                    block37: {
                        String line1;
                        this.sizeCounter = this.maxMessageSize;
                        StringBuffer inputBuffer = new StringBuffer();
                        if (Debug.parserDebug) {
                            Debug.println("Starting parse!");
                        }
                        String line2 = null;
                        try {
                            while ((line1 = this.readLine(inputStream)).equals("\n")) {
                                if (!Debug.parserDebug) continue;
                                Debug.println("Discarding blank line. ");
                            }
                        }
                        catch (IOException ex) {
                            Debug.printStackTrace(ex);
                            this.rawInputStream.stopTimer();
                            Object var15_19 = null;
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                InternalErrorHandler.handleException(e);
                            }
                            return;
                        }
                        inputBuffer.append(line1);
                        this.rawInputStream.startTimer();
                        Debug.println("Reading Input Stream");
                        try {
                            do {
                                line2 = this.readLine(inputStream);
                                inputBuffer.append(line2);
                            } while (!line2.trim().equals(""));
                        }
                        catch (IOException ex) {
                            this.rawInputStream.stopTimer();
                            Debug.printStackTrace(ex);
                            Object var15_20 = null;
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                InternalErrorHandler.handleException(e);
                            }
                            return;
                        }
                        this.rawInputStream.stopTimer();
                        inputBuffer.append(line2);
                        MessageParser smp = this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack);
                        smp.setParseExceptionListener(this.sipMessageListener);
                        smp.setReadBody(false);
                        sipMessage = null;
                        try {
                            if (Debug.debug) {
                                Debug.println("About to parse : " + inputBuffer.toString());
                            }
                            if ((sipMessage = smp.parseSIPMessage(inputBuffer.toString().getBytes())) == null) {
                                this.rawInputStream.stopTimer();
                            }
                            break block37;
                        }
                        catch (ParseException ex) {
                            Debug.logError("Detected a parse error", ex);
                        }
                        continue;
                    }
                    if (Debug.debug) {
                        Debug.println("Completed parsing message");
                    }
                    ContentLength cl = (ContentLength)sipMessage.getContentLength();
                    int contentLength = 0;
                    contentLength = cl != null ? cl.getContentLength() : 0;
                    if (Debug.debug) {
                        Debug.println("contentLength " + contentLength);
                    }
                    if (contentLength == 0) {
                        sipMessage.removeContent();
                    } else if (this.maxMessageSize == 0 || contentLength < this.sizeCounter) {
                        int readlength;
                        byte[] message_body = new byte[contentLength];
                        for (int nread = 0; nread < contentLength; nread += readlength) {
                            Object var13_18;
                            this.rawInputStream.startTimer();
                            try {
                                try {
                                    readlength = inputStream.read(message_body, nread, contentLength - nread);
                                    if (readlength > 0) {
                                    } else {
                                        var13_18 = null;
                                        this.rawInputStream.stopTimer();
                                        break;
                                    }
                                    var13_18 = null;
                                    this.rawInputStream.stopTimer();
                                    continue;
                                }
                                catch (IOException ex) {
                                    Debug.logError("Exception Reading Content", ex);
                                    var13_18 = null;
                                    this.rawInputStream.stopTimer();
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                var13_18 = null;
                                this.rawInputStream.stopTimer();
                                throw throwable;
                            }
                        }
                        sipMessage.setMessageContent(message_body);
                    }
                    if (this.sipMessageListener != null) break;
                }
                try {
                    if (postParseExecutor == null) {
                        this.sipMessageListener.processMessage(sipMessage);
                        continue;
                    }
                    final SIPMessage message = sipMessage;
                    Thread messageDispatchTask = new Thread(){

                        public void run() {
                            try {
                                PipelinedMsgParser.this.sipMessageListener.processMessage(message);
                            }
                            catch (Exception e) {
                                Debug.logError("Error occured processing message", e);
                            }
                        }
                    };
                    postParseExecutor.execute(messageDispatchTask);
                }
                catch (Exception ex) {
                    Object var15_21 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        InternalErrorHandler.handleException(e);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var15_22 = null;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    InternalErrorHandler.handleException(e);
                }
                throw throwable;
            }
        }
    }

    public static void setPostParseExcutorSize(int threads) {
        if (postParseExecutor == null) {
            postParseExecutor = threads <= 0 ? null : Executors.newFixedThreadPool(threads);
        }
    }

    public void close() {
        try {
            this.rawInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

