/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.QueuedMessageDispatchBase;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;

public class BlockingQueueDispatchAuditor
extends TimerTask {
    private Timer timer = new Timer();
    private StackLogger logger;
    private long totalReject = 0L;
    private boolean started = false;
    private Queue queue;
    private int timeout = 8000;

    public BlockingQueueDispatchAuditor(Queue queue) {
        this.queue = queue;
    }

    public void setLogger(StackLogger logger) {
        this.logger = logger;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void start(int interval) {
        if (this.started) {
            this.stop();
        }
        this.started = true;
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)this, interval, (long)interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            try {
                try {
                    if (this.timer != null) {
                        this.timer.cancel();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.timer = null;
                this.queue = null;
            }
            catch (Exception exception) {
                Object var3_4 = null;
                this.started = false;
            }
            Object var3_3 = null;
            this.started = false;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.started = false;
            throw throwable;
        }
    }

    public void run() {
        block6: {
            try {
                QueuedMessageDispatchBase runnable = (QueuedMessageDispatchBase)this.queue.peek();
                int removed = 0;
                while (runnable != null) {
                    QueuedMessageDispatchBase d = runnable;
                    if (System.currentTimeMillis() - d.getReceptionTime() > (long)this.timeout) {
                        this.queue.poll();
                        runnable = (QueuedMessageDispatchBase)this.queue.peek();
                        ++removed;
                        continue;
                    }
                    runnable = null;
                }
                if (removed > 0) {
                    this.totalReject += (long)removed;
                    if (this.logger != null && this.logger.isLoggingEnabled(8)) {
                        this.logger.logWarning("Removed stuck messages=" + removed + " total rejected=" + this.totalReject + " stil in queue=" + this.queue.size());
                    }
                }
            }
            catch (Exception e) {
                if (this.logger == null || !this.logger.isLoggingEnabled(8)) break block6;
                this.logger.logWarning("Problem reaping old requests. This is not a fatal error." + e);
            }
        }
    }
}

