/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.ResponseEventExt;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.message.MessageFactoryImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import java.io.IOException;
import java.util.EventObject;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.ObjectInUseException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.header.Header;
import javax.sip.header.ReferToHeader;
import javax.sip.header.ServerHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

class DialogFilter
implements ServerRequestInterface,
ServerResponseInterface {
    protected SIPTransaction transactionChannel;
    protected ListeningPointImpl listeningPoint;
    private SIPTransactionStack sipStack;

    public DialogFilter(SIPTransactionStack sipStack) {
        this.sipStack = sipStack;
    }

    private void sendRequestPendingResponse(SIPRequest sipRequest, SIPServerTransaction transaction) {
        SIPResponse sipResponse = sipRequest.createResponse(491);
        ServerHeader serverHeader = MessageFactoryImpl.getDefaultServerHeader();
        if (serverHeader != null) {
            sipResponse.setHeader((Header)serverHeader);
        }
        try {
            RetryAfter retryAfter = new RetryAfter();
            retryAfter.setRetryAfter(1);
            sipResponse.setHeader(retryAfter);
            if (sipRequest.getMethod().equals("INVITE")) {
                this.sipStack.addTransactionPendingAck(transaction);
            }
            transaction.sendResponse((Response)sipResponse);
            transaction.releaseSem();
        }
        catch (Exception ex) {
            this.sipStack.getStackLogger().logError("Problem sending error response", ex);
            transaction.releaseSem();
            this.sipStack.removeTransaction(transaction);
        }
    }

    private void sendBadRequestResponse(SIPRequest sipRequest, SIPServerTransaction transaction, String reasonPhrase) {
        ServerHeader serverHeader;
        SIPResponse sipResponse = sipRequest.createResponse(400);
        if (reasonPhrase != null) {
            sipResponse.setReasonPhrase(reasonPhrase);
        }
        if ((serverHeader = MessageFactoryImpl.getDefaultServerHeader()) != null) {
            sipResponse.setHeader((Header)serverHeader);
        }
        try {
            if (sipRequest.getMethod().equals("INVITE")) {
                this.sipStack.addTransactionPendingAck(transaction);
            }
            transaction.sendResponse((Response)sipResponse);
            transaction.releaseSem();
        }
        catch (Exception ex) {
            this.sipStack.getStackLogger().logError("Problem sending error response", ex);
            transaction.releaseSem();
            this.sipStack.removeTransaction(transaction);
        }
    }

    private void sendCallOrTransactionDoesNotExistResponse(SIPRequest sipRequest, SIPServerTransaction transaction) {
        SIPResponse sipResponse = sipRequest.createResponse(481);
        ServerHeader serverHeader = MessageFactoryImpl.getDefaultServerHeader();
        if (serverHeader != null) {
            sipResponse.setHeader((Header)serverHeader);
        }
        try {
            if (sipRequest.getMethod().equals("INVITE")) {
                this.sipStack.addTransactionPendingAck(transaction);
            }
            transaction.sendResponse((Response)sipResponse);
            transaction.releaseSem();
        }
        catch (Exception ex) {
            this.sipStack.getStackLogger().logError("Problem sending error response", ex);
            transaction.releaseSem();
            this.sipStack.removeTransaction(transaction);
        }
    }

    private void sendLoopDetectedResponse(SIPRequest sipRequest, SIPServerTransaction transaction) {
        SIPResponse sipResponse = sipRequest.createResponse(482);
        ServerHeader serverHeader = MessageFactoryImpl.getDefaultServerHeader();
        if (serverHeader != null) {
            sipResponse.setHeader((Header)serverHeader);
        }
        try {
            this.sipStack.addTransactionPendingAck(transaction);
            transaction.sendResponse((Response)sipResponse);
            transaction.releaseSem();
        }
        catch (Exception ex) {
            this.sipStack.getStackLogger().logError("Problem sending error response", ex);
            transaction.releaseSem();
            this.sipStack.removeTransaction(transaction);
        }
    }

    private void sendServerInternalErrorResponse(SIPRequest sipRequest, SIPServerTransaction transaction) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Sending 500 response for out of sequence message");
        }
        SIPResponse sipResponse = sipRequest.createResponse(500);
        sipResponse.setReasonPhrase("Request out of order");
        if (MessageFactoryImpl.getDefaultServerHeader() != null) {
            ServerHeader serverHeader = MessageFactoryImpl.getDefaultServerHeader();
            sipResponse.setHeader((Header)serverHeader);
        }
        try {
            RetryAfter retryAfter = new RetryAfter();
            retryAfter.setRetryAfter(10);
            sipResponse.setHeader(retryAfter);
            this.sipStack.addTransactionPendingAck(transaction);
            transaction.sendResponse((Response)sipResponse);
            transaction.releaseSem();
        }
        catch (Exception ex) {
            this.sipStack.getStackLogger().logError("Problem sending response", ex);
            transaction.releaseSem();
            this.sipStack.removeTransaction(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(SIPRequest sipRequest, MessageChannel incomingMessageChannel) {
        block162: {
            block161: {
                block160: {
                    block158: {
                        block157: {
                            block156: {
                                block155: {
                                    block154: {
                                        block153: {
                                            block152: {
                                                block151: {
                                                    block150: {
                                                        block149: {
                                                            block147: {
                                                                block145: {
                                                                    block144: {
                                                                        block143: {
                                                                            block142: {
                                                                                block141: {
                                                                                    block140: {
                                                                                        block139: {
                                                                                            try {
                                                                                                RequestEvent sipEvent;
                                                                                                SIPServerTransaction transaction;
                                                                                                SipProviderImpl sipProvider;
                                                                                                block175: {
                                                                                                    SIPDialog dialog;
                                                                                                    block171: {
                                                                                                        SIPTransactionStack sipStack;
                                                                                                        block172: {
                                                                                                            SIPDialog subscriptionDialog;
                                                                                                            block174: {
                                                                                                                SIPClientTransaction pendingSubscribeClientTx;
                                                                                                                String dialogId;
                                                                                                                block173: {
                                                                                                                    Event event;
                                                                                                                    String sipRequestMethod;
                                                                                                                    block159: {
                                                                                                                        block148: {
                                                                                                                            SIPServerTransaction st;
                                                                                                                            block169: {
                                                                                                                                block170: {
                                                                                                                                    block165: {
                                                                                                                                        block168: {
                                                                                                                                            block167: {
                                                                                                                                                SIPServerTransaction ackTransaction;
                                                                                                                                                block166: {
                                                                                                                                                    block164: {
                                                                                                                                                        block163: {
                                                                                                                                                            Contact contact;
                                                                                                                                                            if (this.sipStack.isLoggingEnabled(32) && this.listeningPoint != null) {
                                                                                                                                                                this.sipStack.getStackLogger().logDebug("PROCESSING INCOMING REQUEST " + sipRequest + " transactionChannel = " + this.transactionChannel + " listening point = " + this.listeningPoint.getIPAddress() + ":" + this.listeningPoint.getPort());
                                                                                                                                                            }
                                                                                                                                                            if (this.listeningPoint == null) {
                                                                                                                                                                if (this.sipStack.isLoggingEnabled(32)) {
                                                                                                                                                                    this.sipStack.getStackLogger().logDebug("Dropping message: No listening point registered!");
                                                                                                                                                                }
                                                                                                                                                                Object var15_3 = null;
                                                                                                                                                                this.listeningPoint = null;
                                                                                                                                                                return;
                                                                                                                                                            }
                                                                                                                                                            sipStack = this.transactionChannel.getSIPStack();
                                                                                                                                                            sipProvider = this.listeningPoint.getProvider();
                                                                                                                                                            if (sipProvider == null) {
                                                                                                                                                                if (sipStack.isLoggingEnabled()) {
                                                                                                                                                                    sipStack.getStackLogger().logDebug("No provider - dropping !!");
                                                                                                                                                                }
                                                                                                                                                                break block139;
                                                                                                                                                            }
                                                                                                                                                            if (sipStack == null) {
                                                                                                                                                                InternalErrorHandler.handleException("Egads! no sip stack!");
                                                                                                                                                            }
                                                                                                                                                            if ((transaction = (SIPServerTransaction)this.transactionChannel) != null && sipStack.isLoggingEnabled()) {
                                                                                                                                                                sipStack.getStackLogger().logDebug("transaction state = " + transaction.getState());
                                                                                                                                                            }
                                                                                                                                                            if ((dialog = sipStack.getDialog(dialogId = sipRequest.getDialogId(true))) != null && sipProvider != dialog.getSipProvider() && (contact = dialog.getMyContactHeader()) != null) {
                                                                                                                                                                SipUri contactUri = (SipUri)contact.getAddress().getURI();
                                                                                                                                                                String ipAddress = contactUri.getHost();
                                                                                                                                                                int contactPort = contactUri.getPort();
                                                                                                                                                                String contactTransport = contactUri.getTransportParam();
                                                                                                                                                                if (contactTransport == null) {
                                                                                                                                                                    contactTransport = "udp";
                                                                                                                                                                }
                                                                                                                                                                if (contactPort == -1) {
                                                                                                                                                                    contactPort = contactTransport.equals("udp") || contactTransport.equals("tcp") ? 5060 : 5061;
                                                                                                                                                                }
                                                                                                                                                                if (!(ipAddress == null || ipAddress.equals(this.listeningPoint.getIPAddress()) && contactPort == this.listeningPoint.getPort())) {
                                                                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                                                                        sipStack.getStackLogger().logDebug("nulling dialog -- listening point mismatch!  " + contactPort + "  lp port = " + this.listeningPoint.getPort());
                                                                                                                                                                    }
                                                                                                                                                                    dialog = null;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            if (sipProvider.isDialogErrorsAutomaticallyHandled() && sipRequest.getToTag() == null && sipStack.findMergedTransaction(sipRequest)) {
                                                                                                                                                                this.sendLoopDetectedResponse(sipRequest, transaction);
                                                                                                                                                                break block140;
                                                                                                                                                            }
                                                                                                                                                            if (sipStack.isLoggingEnabled()) {
                                                                                                                                                                sipStack.getStackLogger().logDebug("dialogId = " + dialogId);
                                                                                                                                                                sipStack.getStackLogger().logDebug("dialog = " + dialog);
                                                                                                                                                            }
                                                                                                                                                            if (sipRequest.getHeader("Route") != null && transaction.getDialog() != null) {
                                                                                                                                                                RouteList routes = sipRequest.getRouteHeaders();
                                                                                                                                                                Route route = (Route)routes.getFirst();
                                                                                                                                                                SipUri uri = (SipUri)route.getAddress().getURI();
                                                                                                                                                                HostPort hostPort = uri.getHostPort();
                                                                                                                                                                int port = hostPort.hasPort() ? hostPort.getPort() : (this.listeningPoint.getTransport().equalsIgnoreCase("TLS") ? 5061 : 5060);
                                                                                                                                                                String host = hostPort.getHost().encode();
                                                                                                                                                                if ((host.equals(this.listeningPoint.getIPAddress()) || host.equalsIgnoreCase(this.listeningPoint.getSentBy())) && port == this.listeningPoint.getPort()) {
                                                                                                                                                                    if (routes.size() == 1) {
                                                                                                                                                                        sipRequest.removeHeader("Route");
                                                                                                                                                                    } else {
                                                                                                                                                                        routes.removeFirst();
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            if (!(sipRequestMethod = sipRequest.getMethod()).equals("REFER") || dialog == null || !sipProvider.isDialogErrorsAutomaticallyHandled()) break block163;
                                                                                                                                                            ReferToHeader sipHeader = (ReferToHeader)sipRequest.getHeader("Refer-To");
                                                                                                                                                            if (sipHeader == null) {
                                                                                                                                                                this.sendBadRequestResponse(sipRequest, transaction, "Refer-To header is missing");
                                                                                                                                                                break block141;
                                                                                                                                                            }
                                                                                                                                                            SIPTransaction lastTransaction = dialog.getLastTransaction();
                                                                                                                                                            if (lastTransaction == null || !sipProvider.isDialogErrorsAutomaticallyHandled()) break block148;
                                                                                                                                                            SIPRequest lastRequest = (SIPRequest)lastTransaction.getRequest();
                                                                                                                                                            String lastRequestMethod = lastRequest.getMethod();
                                                                                                                                                            if (lastTransaction instanceof SIPServerTransaction) {
                                                                                                                                                                if (lastTransaction.getInternalState() == 2 && lastRequestMethod.equals("INVITE")) {
                                                                                                                                                                    this.sendRequestPendingResponse(sipRequest, transaction);
                                                                                                                                                                    break block142;
                                                                                                                                                                }
                                                                                                                                                                break block148;
                                                                                                                                                            } else if (lastTransaction != null && lastTransaction instanceof SIPClientTransaction && lastRequestMethod.equals("INVITE") && lastTransaction.getInternalState() != 5 && lastTransaction.getInternalState() != 3) {
                                                                                                                                                                this.sendRequestPendingResponse(sipRequest, transaction);
                                                                                                                                                                break block143;
                                                                                                                                                            }
                                                                                                                                                            break block148;
                                                                                                                                                        }
                                                                                                                                                        if (!sipRequestMethod.equals("UPDATE")) break block164;
                                                                                                                                                        if (sipProvider.isAutomaticDialogSupportEnabled() && dialog == null) {
                                                                                                                                                            this.sendCallOrTransactionDoesNotExistResponse(sipRequest, transaction);
                                                                                                                                                            break block144;
                                                                                                                                                        }
                                                                                                                                                        break block148;
                                                                                                                                                    }
                                                                                                                                                    if (!sipRequestMethod.equals("ACK")) break block165;
                                                                                                                                                    if (transaction == null || !transaction.isInviteTransaction()) break block166;
                                                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                                                        sipStack.getStackLogger().logDebug("Processing ACK for INVITE Tx ");
                                                                                                                                                    }
                                                                                                                                                    break block148;
                                                                                                                                                }
                                                                                                                                                if (sipStack.isLoggingEnabled()) {
                                                                                                                                                    sipStack.getStackLogger().logDebug("Processing ACK for dialog " + dialog);
                                                                                                                                                }
                                                                                                                                                if (dialog != null) break block167;
                                                                                                                                                if (sipStack.isLoggingEnabled()) {
                                                                                                                                                    sipStack.getStackLogger().logDebug("Dialog does not exist " + sipRequest.getFirstLine() + " isServerTransaction = " + true);
                                                                                                                                                }
                                                                                                                                                if ((st = sipStack.getRetransmissionAlertTransaction(dialogId)) != null && st.isRetransmissionAlertEnabled()) {
                                                                                                                                                    st.disableRetransmissionAlerts();
                                                                                                                                                }
                                                                                                                                                if ((ackTransaction = sipStack.findTransactionPendingAck(sipRequest)) != null) {
                                                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                                                        sipStack.getStackLogger().logDebug("Found Tx pending ACK");
                                                                                                                                                    }
                                                                                                                                                    try {
                                                                                                                                                        ackTransaction.setAckSeen();
                                                                                                                                                        sipStack.removeTransaction(ackTransaction);
                                                                                                                                                        sipStack.removeTransactionPendingAck(ackTransaction);
                                                                                                                                                    }
                                                                                                                                                    catch (Exception ex) {
                                                                                                                                                        if (sipStack.isLoggingEnabled()) {
                                                                                                                                                            sipStack.getStackLogger().logError("Problem terminating transaction", ex);
                                                                                                                                                        }
                                                                                                                                                        break block145;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                break block148;
                                                                                                                                            }
                                                                                                                                            if (dialog.handleAck(transaction)) break block168;
                                                                                                                                            if (!dialog.isSequnceNumberValidation()) {
                                                                                                                                                if (sipStack.isLoggingEnabled()) {
                                                                                                                                                    sipStack.getStackLogger().logDebug("Dialog exists with loose dialog validation " + sipRequest.getFirstLine() + " isServerTransaction = " + true + " dialog = " + dialog.getDialogId());
                                                                                                                                                }
                                                                                                                                                if ((st = sipStack.getRetransmissionAlertTransaction(dialogId)) != null && st.isRetransmissionAlertEnabled()) {
                                                                                                                                                    st.disableRetransmissionAlerts();
                                                                                                                                                }
                                                                                                                                                break block148;
                                                                                                                                            } else {
                                                                                                                                                SIPServerTransaction ackTransaction;
                                                                                                                                                block146: {
                                                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                                                        sipStack.getStackLogger().logDebug("Dropping ACK - cannot find a transaction or dialog");
                                                                                                                                                    }
                                                                                                                                                    if ((ackTransaction = sipStack.findTransactionPendingAck(sipRequest)) != null) {
                                                                                                                                                        if (sipStack.isLoggingEnabled()) {
                                                                                                                                                            sipStack.getStackLogger().logDebug("Found Tx pending ACK");
                                                                                                                                                        }
                                                                                                                                                        try {
                                                                                                                                                            ackTransaction.setAckSeen();
                                                                                                                                                            sipStack.removeTransaction(ackTransaction);
                                                                                                                                                            sipStack.removeTransactionPendingAck(ackTransaction);
                                                                                                                                                        }
                                                                                                                                                        catch (Exception ex) {
                                                                                                                                                            if (!sipStack.isLoggingEnabled()) break block146;
                                                                                                                                                            sipStack.getStackLogger().logError("Problem terminating transaction", ex);
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                if (!sipStack.isDeliverRetransmittedAckToListener()) break block147;
                                                                                                                                                if (ackTransaction != null && !sipStack.isNon2XXAckPassedToListener()) {
                                                                                                                                                    break block147;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            break block148;
                                                                                                                                        }
                                                                                                                                        dialog.addTransaction(transaction);
                                                                                                                                        transaction.passToListener();
                                                                                                                                        dialog.addRoute(sipRequest);
                                                                                                                                        transaction.setDialog(dialog, dialogId);
                                                                                                                                        if (sipRequest.getMethod().equals("INVITE") && sipProvider.isDialogErrorsAutomaticallyHandled()) {
                                                                                                                                            sipStack.putInMergeTable(transaction, sipRequest);
                                                                                                                                        }
                                                                                                                                        if (sipStack.isDeliverTerminatedEventForAck()) {
                                                                                                                                            try {
                                                                                                                                                sipStack.addTransaction(transaction);
                                                                                                                                                transaction.scheduleAckRemoval();
                                                                                                                                            }
                                                                                                                                            catch (IOException ex) {}
                                                                                                                                            break block148;
                                                                                                                                        } else {
                                                                                                                                            transaction.setMapped(true);
                                                                                                                                        }
                                                                                                                                        break block148;
                                                                                                                                    }
                                                                                                                                    if (!sipRequestMethod.equals("PRACK")) break block169;
                                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                                        sipStack.getStackLogger().logDebug("Processing PRACK for dialog " + dialog);
                                                                                                                                    }
                                                                                                                                    if (dialog == null && sipProvider.isAutomaticDialogSupportEnabled()) {
                                                                                                                                        if (sipStack.isLoggingEnabled()) {
                                                                                                                                            sipStack.getStackLogger().logDebug("Dialog does not exist " + sipRequest.getFirstLine() + " isServerTransaction = " + true);
                                                                                                                                        }
                                                                                                                                        if (sipStack.isLoggingEnabled()) {
                                                                                                                                            sipStack.getStackLogger().logDebug("Sending 481 for PRACK - automatic dialog support is enabled -- cant find dialog!");
                                                                                                                                        }
                                                                                                                                        SIPResponse notExist = sipRequest.createResponse(481);
                                                                                                                                        try {
                                                                                                                                            sipProvider.sendResponse(notExist);
                                                                                                                                        }
                                                                                                                                        catch (SipException e) {
                                                                                                                                            sipStack.getStackLogger().logError("error sending response", (Exception)((Object)e));
                                                                                                                                        }
                                                                                                                                        if (transaction != null) {
                                                                                                                                            sipStack.removeTransaction(transaction);
                                                                                                                                            transaction.releaseSem();
                                                                                                                                        }
                                                                                                                                        break block149;
                                                                                                                                    }
                                                                                                                                    if (dialog == null) break block170;
                                                                                                                                    if (!dialog.handlePrack(sipRequest)) {
                                                                                                                                        if (sipStack.isLoggingEnabled()) {
                                                                                                                                            sipStack.getStackLogger().logDebug("Dropping out of sequence PRACK ");
                                                                                                                                        }
                                                                                                                                        if (transaction != null) {
                                                                                                                                            sipStack.removeTransaction(transaction);
                                                                                                                                            transaction.releaseSem();
                                                                                                                                        }
                                                                                                                                        break block150;
                                                                                                                                    }
                                                                                                                                    try {
                                                                                                                                        sipStack.addTransaction(transaction);
                                                                                                                                        dialog.addTransaction(transaction);
                                                                                                                                        dialog.addRoute(sipRequest);
                                                                                                                                        transaction.setDialog(dialog, dialogId);
                                                                                                                                    }
                                                                                                                                    catch (Exception ex) {
                                                                                                                                        InternalErrorHandler.handleException(ex);
                                                                                                                                    }
                                                                                                                                    break block148;
                                                                                                                                }
                                                                                                                                if (!sipStack.isLoggingEnabled()) break block148;
                                                                                                                                sipStack.getStackLogger().logDebug("Processing PRACK without a DIALOG -- this must be a proxy element");
                                                                                                                                break block148;
                                                                                                                            }
                                                                                                                            if (sipRequestMethod.equals("BYE")) {
                                                                                                                                if (dialog != null && !dialog.isRequestConsumable(sipRequest)) {
                                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                                        sipStack.getStackLogger().logDebug("Dropping out of sequence BYE " + dialog.getRemoteSeqNumber() + " " + sipRequest.getCSeq().getSeqNumber());
                                                                                                                                    }
                                                                                                                                    if (dialog.getRemoteSeqNumber() >= sipRequest.getCSeq().getSeqNumber() && transaction.getInternalState() == 1) {
                                                                                                                                        this.sendServerInternalErrorResponse(sipRequest, transaction);
                                                                                                                                    }
                                                                                                                                    if (transaction != null) {
                                                                                                                                        sipStack.removeTransaction(transaction);
                                                                                                                                    }
                                                                                                                                    break block151;
                                                                                                                                }
                                                                                                                                if (dialog == null && sipProvider.isAutomaticDialogSupportEnabled()) {
                                                                                                                                    SIPResponse response = sipRequest.createResponse(481);
                                                                                                                                    response.setReasonPhrase("Dialog Not Found");
                                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                                        sipStack.getStackLogger().logDebug("dropping request -- automatic dialog support enabled and dialog does not exist!");
                                                                                                                                    }
                                                                                                                                    try {
                                                                                                                                        transaction.sendResponse((Response)response);
                                                                                                                                    }
                                                                                                                                    catch (SipException ex) {
                                                                                                                                        sipStack.getStackLogger().logError("Error in sending response", (Exception)((Object)ex));
                                                                                                                                    }
                                                                                                                                    if (transaction != null) {
                                                                                                                                        sipStack.removeTransaction(transaction);
                                                                                                                                        transaction.releaseSem();
                                                                                                                                        transaction = null;
                                                                                                                                    }
                                                                                                                                    break block152;
                                                                                                                                }
                                                                                                                                if (transaction != null && dialog != null) {
                                                                                                                                    try {
                                                                                                                                        if (sipProvider == dialog.getSipProvider()) {
                                                                                                                                            sipStack.addTransaction(transaction);
                                                                                                                                            dialog.addTransaction(transaction);
                                                                                                                                            transaction.setDialog(dialog, dialogId);
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    catch (IOException ex) {
                                                                                                                                        InternalErrorHandler.handleException(ex);
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                if (sipStack.isLoggingEnabled()) {
                                                                                                                                    sipStack.getStackLogger().logDebug("BYE Tx = " + transaction + " isMapped =" + transaction.isTransactionMapped());
                                                                                                                                }
                                                                                                                            } else if (sipRequestMethod.equals("CANCEL")) {
                                                                                                                                st = (SIPServerTransaction)sipStack.findCancelTransaction(sipRequest, true);
                                                                                                                                if (sipStack.isLoggingEnabled()) {
                                                                                                                                    sipStack.getStackLogger().logDebug("Got a CANCEL, InviteServerTx = " + st + " cancel Server Tx ID = " + transaction + " isMapped = " + transaction.isTransactionMapped());
                                                                                                                                }
                                                                                                                                if (sipRequest.getMethod().equals("CANCEL")) {
                                                                                                                                    if (st != null && st.getInternalState() == 5) {
                                                                                                                                        if (sipStack.isLoggingEnabled()) {
                                                                                                                                            sipStack.getStackLogger().logDebug("Too late to cancel Transaction");
                                                                                                                                        }
                                                                                                                                        try {
                                                                                                                                            transaction.sendResponse((Response)sipRequest.createResponse(200));
                                                                                                                                        }
                                                                                                                                        catch (Exception ex) {
                                                                                                                                            if (ex.getCause() != null && ex.getCause() instanceof IOException) {
                                                                                                                                                st.raiseIOExceptionEvent();
                                                                                                                                            }
                                                                                                                                            break block153;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                                        sipStack.getStackLogger().logDebug("Cancel transaction = " + st);
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                if (transaction != null && st != null && st.getDialog() != null) {
                                                                                                                                    transaction.setDialog((SIPDialog)st.getDialog(), dialogId);
                                                                                                                                    dialog = (SIPDialog)st.getDialog();
                                                                                                                                } else if (st == null && sipProvider.isAutomaticDialogSupportEnabled() && transaction != null) {
                                                                                                                                    SIPResponse response = sipRequest.createResponse(481);
                                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                                        sipStack.getStackLogger().logDebug("dropping request -- automatic dialog support enabled and INVITE ST does not exist!");
                                                                                                                                    }
                                                                                                                                    try {
                                                                                                                                        sipProvider.sendResponse(response);
                                                                                                                                    }
                                                                                                                                    catch (SipException ex) {
                                                                                                                                        InternalErrorHandler.handleException((Exception)((Object)ex));
                                                                                                                                    }
                                                                                                                                    if (transaction != null) {
                                                                                                                                        sipStack.removeTransaction(transaction);
                                                                                                                                        transaction.releaseSem();
                                                                                                                                    }
                                                                                                                                    break block154;
                                                                                                                                }
                                                                                                                                if (st != null) {
                                                                                                                                    try {
                                                                                                                                        if (transaction != null) {
                                                                                                                                            sipStack.addTransaction(transaction);
                                                                                                                                            transaction.setPassToListener();
                                                                                                                                            transaction.setInviteTransaction(st);
                                                                                                                                            st.acquireSem();
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    catch (Exception ex) {
                                                                                                                                        InternalErrorHandler.handleException(ex);
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            } else if (sipRequestMethod.equals("INVITE")) {
                                                                                                                                SIPTransaction lastTransaction;
                                                                                                                                SIPTransaction sIPTransaction = lastTransaction = dialog == null ? null : dialog.getInviteTransaction();
                                                                                                                                if (dialog != null && transaction != null && lastTransaction != null && sipRequest.getCSeq().getSeqNumber() > dialog.getRemoteSeqNumber() && lastTransaction instanceof SIPServerTransaction && sipProvider.isDialogErrorsAutomaticallyHandled() && dialog.isSequnceNumberValidation() && lastTransaction.isInviteTransaction() && lastTransaction.getInternalState() != 3 && lastTransaction.getInternalState() != 5 && lastTransaction.getInternalState() != 4) {
                                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                                        sipStack.getStackLogger().logDebug("Sending 500 response for out of sequence message");
                                                                                                                                    }
                                                                                                                                    this.sendServerInternalErrorResponse(sipRequest, transaction);
                                                                                                                                    break block155;
                                                                                                                                }
                                                                                                                                SIPTransaction sIPTransaction2 = lastTransaction = dialog == null ? null : dialog.getLastTransaction();
                                                                                                                                if (dialog != null && sipProvider.isDialogErrorsAutomaticallyHandled() && lastTransaction != null && lastTransaction.isInviteTransaction() && lastTransaction instanceof ClientTransaction && lastTransaction.getLastResponse() != null && lastTransaction.getLastResponse().getStatusCode() == 200 && !dialog.isAckSent(lastTransaction.getLastResponse().getCSeq().getSeqNumber())) {
                                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                                        sipStack.getStackLogger().logDebug("Sending 491 response for client Dialog ACK not sent.");
                                                                                                                                    }
                                                                                                                                    this.sendRequestPendingResponse(sipRequest, transaction);
                                                                                                                                    break block156;
                                                                                                                                }
                                                                                                                                if (dialog != null && lastTransaction != null && sipProvider.isDialogErrorsAutomaticallyHandled() && lastTransaction.isInviteTransaction() && lastTransaction instanceof ServerTransaction && lastTransaction.getInternalState() == 2) {
                                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                                        sipStack.getStackLogger().logDebug("Sending 491 response for server Dialog ACK not seen.");
                                                                                                                                        sipStack.getStackLogger().logDebug("last Transaction state = " + lastTransaction + " state " + lastTransaction.getState());
                                                                                                                                    }
                                                                                                                                    this.sendRequestPendingResponse(sipRequest, transaction);
                                                                                                                                    break block157;
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (sipStack.isLoggingEnabled()) {
                                                                                                                            sipStack.getStackLogger().logDebug("CHECK FOR OUT OF SEQ MESSAGE " + dialog + " transaction " + transaction);
                                                                                                                        }
                                                                                                                        if (dialog == null || transaction == null || sipRequestMethod.equals("BYE") || sipRequestMethod.equals("CANCEL") || sipRequestMethod.equals("ACK") || sipRequestMethod.equals("PRACK")) break block159;
                                                                                                                        if (!dialog.isRequestConsumable(sipRequest)) {
                                                                                                                            if (sipStack.isLoggingEnabled()) {
                                                                                                                                sipStack.getStackLogger().logDebug("Dropping out of sequence message " + dialog.getRemoteSeqNumber() + " " + sipRequest.getCSeq());
                                                                                                                            }
                                                                                                                            if (dialog.getRemoteSeqNumber() > sipRequest.getCSeq().getSeqNumber() && sipProvider.isDialogErrorsAutomaticallyHandled()) {
                                                                                                                                this.sendServerInternalErrorResponse(sipRequest, transaction);
                                                                                                                                break block158;
                                                                                                                            }
                                                                                                                            try {
                                                                                                                                transaction.terminate();
                                                                                                                            }
                                                                                                                            catch (ObjectInUseException e) {
                                                                                                                                if (sipStack.isLoggingEnabled()) {
                                                                                                                                    sipStack.getStackLogger().logError("Unexpected exception", (Exception)((Object)e));
                                                                                                                                }
                                                                                                                                break block158;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        try {
                                                                                                                            if (sipProvider != dialog.getSipProvider()) break block159;
                                                                                                                            sipStack.addTransaction(transaction);
                                                                                                                            if (!dialog.addTransaction(transaction)) {
                                                                                                                                break block160;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        catch (IOException ex) {
                                                                                                                            transaction.raiseIOExceptionEvent();
                                                                                                                            sipStack.removeTransaction(transaction);
                                                                                                                            Object var15_23 = null;
                                                                                                                            this.listeningPoint = null;
                                                                                                                            return;
                                                                                                                        }
                                                                                                                        {
                                                                                                                            dialog.addRoute(sipRequest);
                                                                                                                            transaction.setDialog(dialog, dialogId);
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                        sipStack.getStackLogger().logDebug(sipRequest.getMethod() + " transaction.isMapped = " + transaction.isTransactionMapped());
                                                                                                                    }
                                                                                                                    if (dialog != null || !sipRequestMethod.equals("NOTIFY")) break block171;
                                                                                                                    pendingSubscribeClientTx = sipStack.findSubscribeTransaction(sipRequest, this.listeningPoint);
                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                        sipStack.getStackLogger().logDebug("PROCESSING NOTIFY  DIALOG == null " + pendingSubscribeClientTx);
                                                                                                                    }
                                                                                                                    if (sipProvider.isAutomaticDialogSupportEnabled() && pendingSubscribeClientTx == null && !sipStack.isDeliverUnsolicitedNotify()) {
                                                                                                                        try {
                                                                                                                            if (sipStack.isLoggingEnabled()) {
                                                                                                                                sipStack.getStackLogger().logDebug("Could not find Subscription for Notify Tx.");
                                                                                                                            }
                                                                                                                            SIPResponse errorResponse = sipRequest.createResponse(481);
                                                                                                                            errorResponse.setReasonPhrase("Subscription does not exist");
                                                                                                                            sipProvider.sendResponse(errorResponse);
                                                                                                                            break block161;
                                                                                                                        }
                                                                                                                        catch (Exception ex) {
                                                                                                                            sipStack.getStackLogger().logError("Exception while sending error response statelessly", ex);
                                                                                                                            Object var15_25 = null;
                                                                                                                            this.listeningPoint = null;
                                                                                                                            return;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (pendingSubscribeClientTx == null) break block172;
                                                                                                                    transaction.setPendingSubscribe(pendingSubscribeClientTx);
                                                                                                                    subscriptionDialog = pendingSubscribeClientTx.getDefaultDialog();
                                                                                                                    if (subscriptionDialog != null && subscriptionDialog.getDialogId() != null && subscriptionDialog.getDialogId().equals(dialogId)) break block173;
                                                                                                                    if (subscriptionDialog != null && subscriptionDialog.getDialogId() == null) {
                                                                                                                        subscriptionDialog.setDialogId(dialogId);
                                                                                                                    } else {
                                                                                                                        subscriptionDialog = pendingSubscribeClientTx.getDialog(dialogId);
                                                                                                                    }
                                                                                                                    if (sipStack.isLoggingEnabled()) {
                                                                                                                        sipStack.getStackLogger().logDebug("PROCESSING NOTIFY Subscribe DIALOG " + subscriptionDialog);
                                                                                                                    }
                                                                                                                    if (subscriptionDialog == null && (sipProvider.isAutomaticDialogSupportEnabled() || pendingSubscribeClientTx.getDefaultDialog() != null) && sipStack.isEventForked((event = (Event)sipRequest.getHeader("Event")).getEventType())) {
                                                                                                                        subscriptionDialog = SIPDialog.createFromNOTIFY(pendingSubscribeClientTx, transaction);
                                                                                                                    }
                                                                                                                    if (subscriptionDialog != null) {
                                                                                                                        transaction.setDialog(subscriptionDialog, dialogId);
                                                                                                                        if (subscriptionDialog.getState() != DialogState.CONFIRMED) {
                                                                                                                            subscriptionDialog.setPendingRouteUpdateOn202Response(sipRequest);
                                                                                                                        }
                                                                                                                        subscriptionDialog.setState(DialogState.CONFIRMED.getValue());
                                                                                                                        sipStack.putDialog(subscriptionDialog);
                                                                                                                        pendingSubscribeClientTx.setDialog(subscriptionDialog, dialogId);
                                                                                                                        if (!transaction.isTransactionMapped()) {
                                                                                                                            this.sipStack.mapTransaction(transaction);
                                                                                                                            transaction.setPassToListener();
                                                                                                                            try {
                                                                                                                                this.sipStack.addTransaction(transaction);
                                                                                                                            }
                                                                                                                            catch (Exception ex) {}
                                                                                                                        }
                                                                                                                    }
                                                                                                                    break block174;
                                                                                                                }
                                                                                                                transaction.setDialog(subscriptionDialog, dialogId);
                                                                                                                dialog = subscriptionDialog;
                                                                                                                if (!transaction.isTransactionMapped()) {
                                                                                                                    this.sipStack.mapTransaction(transaction);
                                                                                                                    transaction.setPassToListener();
                                                                                                                    try {
                                                                                                                        this.sipStack.addTransaction(transaction);
                                                                                                                    }
                                                                                                                    catch (Exception ex) {
                                                                                                                        // empty catch block
                                                                                                                    }
                                                                                                                }
                                                                                                                sipStack.putDialog(subscriptionDialog);
                                                                                                                if (pendingSubscribeClientTx != null) {
                                                                                                                    subscriptionDialog.addTransaction(pendingSubscribeClientTx);
                                                                                                                    pendingSubscribeClientTx.setDialog(subscriptionDialog, dialogId);
                                                                                                                }
                                                                                                            }
                                                                                                            sipEvent = transaction != null && transaction.isTransactionMapped() ? new RequestEvent((Object)sipProvider, (ServerTransaction)transaction, (Dialog)subscriptionDialog, (Request)sipRequest) : new RequestEvent((Object)sipProvider, null, (Dialog)subscriptionDialog, (Request)sipRequest);
                                                                                                            break block175;
                                                                                                        }
                                                                                                        if (sipStack.isLoggingEnabled()) {
                                                                                                            sipStack.getStackLogger().logDebug("could not find subscribe tx");
                                                                                                        }
                                                                                                        sipEvent = new RequestEvent((Object)sipProvider, null, null, (Request)sipRequest);
                                                                                                        break block175;
                                                                                                    }
                                                                                                    sipEvent = transaction != null && transaction.isTransactionMapped() ? new RequestEvent((Object)sipProvider, (ServerTransaction)transaction, (Dialog)dialog, (Request)sipRequest) : new RequestEvent((Object)sipProvider, null, (Dialog)dialog, (Request)sipRequest);
                                                                                                }
                                                                                                sipProvider.handleEvent((EventObject)sipEvent, transaction);
                                                                                                break block162;
                                                                                            }
                                                                                            catch (Throwable throwable) {
                                                                                                Object var15_27 = null;
                                                                                                this.listeningPoint = null;
                                                                                                throw throwable;
                                                                                            }
                                                                                        }
                                                                                        Object var15_4 = null;
                                                                                        this.listeningPoint = null;
                                                                                        return;
                                                                                    }
                                                                                    Object var15_5 = null;
                                                                                    this.listeningPoint = null;
                                                                                    return;
                                                                                }
                                                                                Object var15_6 = null;
                                                                                this.listeningPoint = null;
                                                                                return;
                                                                            }
                                                                            Object var15_7 = null;
                                                                            this.listeningPoint = null;
                                                                            return;
                                                                        }
                                                                        Object var15_8 = null;
                                                                        this.listeningPoint = null;
                                                                        return;
                                                                    }
                                                                    Object var15_9 = null;
                                                                    this.listeningPoint = null;
                                                                    return;
                                                                }
                                                                Object var15_10 = null;
                                                                this.listeningPoint = null;
                                                                return;
                                                            }
                                                            Object var15_11 = null;
                                                            this.listeningPoint = null;
                                                            return;
                                                        }
                                                        Object var15_12 = null;
                                                        this.listeningPoint = null;
                                                        return;
                                                    }
                                                    Object var15_13 = null;
                                                    this.listeningPoint = null;
                                                    return;
                                                }
                                                Object var15_14 = null;
                                                this.listeningPoint = null;
                                                return;
                                            }
                                            Object var15_15 = null;
                                            this.listeningPoint = null;
                                            return;
                                        }
                                        Object var15_16 = null;
                                        this.listeningPoint = null;
                                        return;
                                    }
                                    Object var15_17 = null;
                                    this.listeningPoint = null;
                                    return;
                                }
                                Object var15_18 = null;
                                this.listeningPoint = null;
                                return;
                            }
                            Object var15_19 = null;
                            this.listeningPoint = null;
                            return;
                        }
                        Object var15_20 = null;
                        this.listeningPoint = null;
                        return;
                    }
                    Object var15_21 = null;
                    this.listeningPoint = null;
                    return;
                }
                Object var15_22 = null;
                this.listeningPoint = null;
                return;
            }
            Object var15_24 = null;
            this.listeningPoint = null;
            return;
        }
        Object var15_26 = null;
        this.listeningPoint = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processResponse(SIPResponse response, MessageChannel incomingMessageChannel, SIPDialog dialog) {
        block36: {
            block35: {
                block33: {
                    block32: {
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        try {
                                            if (this.sipStack.isLoggingEnabled()) {
                                                this.sipStack.getStackLogger().logDebug("PROCESSING INCOMING RESPONSE" + response.encodeMessage(new StringBuilder()));
                                            }
                                            if (this.listeningPoint == null) {
                                                if (this.sipStack.isLoggingEnabled()) {
                                                    this.sipStack.getStackLogger().logError("Dropping message: No listening point registered!");
                                                }
                                                Object var10_4 = null;
                                                this.listeningPoint = null;
                                                return;
                                            }
                                            if (this.sipStack.checkBranchId() && !Utils.getInstance().responseBelongsToUs(response)) {
                                                if (this.sipStack.isLoggingEnabled()) {
                                                    this.sipStack.getStackLogger().logError("Dropping response - topmost VIA header does not originate from this stack");
                                                }
                                                break block28;
                                            }
                                            SipProviderImpl sipProvider = this.listeningPoint.getProvider();
                                            if (sipProvider == null) {
                                                if (this.sipStack.isLoggingEnabled()) {
                                                    this.sipStack.getStackLogger().logError("Dropping message:  no provider");
                                                }
                                                break block29;
                                            }
                                            if (sipProvider.getSipListener() == null) {
                                                if (this.sipStack.isLoggingEnabled()) {
                                                    this.sipStack.getStackLogger().logError("No listener -- dropping response!");
                                                }
                                                break block30;
                                            }
                                            SIPClientTransaction transaction = (SIPClientTransaction)this.transactionChannel;
                                            SipStackImpl sipStackImpl = sipProvider.sipStack;
                                            if (this.sipStack.isLoggingEnabled()) {
                                                sipStackImpl.getStackLogger().logDebug("Transaction = " + transaction);
                                            }
                                            if (transaction == null) {
                                                if (dialog != null) {
                                                    if (response.getStatusCode() / 100 != 2) {
                                                        if (this.sipStack.isLoggingEnabled()) {
                                                            this.sipStack.getStackLogger().logDebug("Response is not a final response and dialog is found for response -- dropping response!");
                                                        }
                                                        break block31;
                                                    }
                                                    if (dialog.getState() == DialogState.TERMINATED) {
                                                        if (this.sipStack.isLoggingEnabled()) {
                                                            this.sipStack.getStackLogger().logDebug("Dialog is terminated -- dropping response!");
                                                        }
                                                        break block32;
                                                    }
                                                    boolean ackAlreadySent = false;
                                                    if (dialog.isAckSeen() && dialog.getLastAckSent() != null && dialog.getLastAckSent().getCSeq().getSeqNumber() == response.getCSeq().getSeqNumber()) {
                                                        ackAlreadySent = true;
                                                    }
                                                    if (ackAlreadySent && response.getCSeq().getMethod().equals(dialog.getMethod())) {
                                                        try {
                                                            if (this.sipStack.isLoggingEnabled()) {
                                                                this.sipStack.getStackLogger().logDebug("Retransmission of OK detected: Resending last ACK");
                                                            }
                                                            dialog.resendAck();
                                                            break block33;
                                                        }
                                                        catch (SipException ex) {
                                                            this.sipStack.getStackLogger().logError("could not resend ack", (Exception)((Object)ex));
                                                        }
                                                    }
                                                }
                                                if (this.sipStack.isLoggingEnabled()) {
                                                    this.sipStack.getStackLogger().logDebug("could not find tx, handling statelessly Dialog =  " + dialog);
                                                }
                                                ResponseEventExt sipEvent = new ResponseEventExt(sipProvider, transaction, dialog, response);
                                                if (this.sipStack.getMaxForkTime() != 0 && response.getCSeqHeader().getMethod().equals("INVITE")) {
                                                    SIPClientTransaction forked = this.sipStack.getForkedTransaction(response.getForkId());
                                                    sipEvent.setOriginalTransaction(forked);
                                                }
                                                sipProvider.handleEvent((EventObject)((Object)sipEvent), transaction);
                                                break block35;
                                            }
                                            ResponseEventExt responseEvent = null;
                                            responseEvent = new ResponseEventExt(sipProvider, transaction, dialog, response);
                                            if (this.sipStack.getMaxForkTime() != 0 && response.getCSeqHeader().getMethod().equals("INVITE")) {
                                                SIPClientTransaction forked = this.sipStack.getForkedTransaction(response.getForkId());
                                                responseEvent.setOriginalTransaction(forked);
                                            }
                                            if (dialog != null && response.getStatusCode() != 100) {
                                                dialog.setLastResponse(transaction, response);
                                                transaction.setDialog(dialog, dialog.getDialogId());
                                            }
                                            sipProvider.handleEvent((EventObject)((Object)responseEvent), transaction);
                                            break block36;
                                        }
                                        catch (Throwable throwable) {
                                            Object var10_13 = null;
                                            this.listeningPoint = null;
                                            throw throwable;
                                        }
                                    }
                                    Object var10_5 = null;
                                    this.listeningPoint = null;
                                    return;
                                }
                                Object var10_6 = null;
                                this.listeningPoint = null;
                                return;
                            }
                            Object var10_7 = null;
                            this.listeningPoint = null;
                            return;
                        }
                        Object var10_8 = null;
                        this.listeningPoint = null;
                        return;
                    }
                    Object var10_9 = null;
                    this.listeningPoint = null;
                    return;
                }
                Object var10_10 = null;
                this.listeningPoint = null;
                return;
            }
            Object var10_11 = null;
            this.listeningPoint = null;
            return;
        }
        Object var10_12 = null;
        this.listeningPoint = null;
    }

    public String getProcessingInfo() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processResponse(SIPResponse sipResponse, MessageChannel incomingChannel) {
        block48: {
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        try {
                                            SIPClientTransaction transaction;
                                            SipProviderImpl sipProvider;
                                            SIPDialog sipDialog;
                                            block47: {
                                                block49: {
                                                    String dialogID = sipResponse.getDialogId(false);
                                                    sipDialog = this.sipStack.getDialog(dialogID);
                                                    String method = sipResponse.getCSeq().getMethod();
                                                    if (this.sipStack.isLoggingEnabled()) {
                                                        this.sipStack.getStackLogger().logDebug("PROCESSING INCOMING RESPONSE: " + sipResponse.encodeMessage(new StringBuilder()));
                                                    }
                                                    if (this.sipStack.checkBranchId() && !Utils.getInstance().responseBelongsToUs(sipResponse)) {
                                                        if (this.sipStack.isLoggingEnabled()) {
                                                            this.sipStack.getStackLogger().logError("Detected stray response -- dropping");
                                                        }
                                                        Object var11_6 = null;
                                                        this.listeningPoint = null;
                                                        return;
                                                    }
                                                    if (this.listeningPoint == null) {
                                                        if (this.sipStack.isLoggingEnabled()) {
                                                            this.sipStack.getStackLogger().logDebug("Dropping message: No listening point registered!");
                                                        }
                                                        break block40;
                                                    }
                                                    sipProvider = this.listeningPoint.getProvider();
                                                    if (sipProvider == null) {
                                                        if (this.sipStack.isLoggingEnabled()) {
                                                            this.sipStack.getStackLogger().logDebug("Dropping message:  no provider");
                                                        }
                                                        break block41;
                                                    }
                                                    if (sipProvider.getSipListener() == null) {
                                                        if (this.sipStack.isLoggingEnabled()) {
                                                            this.sipStack.getStackLogger().logDebug("Dropping message:  no sipListener registered!");
                                                        }
                                                        break block42;
                                                    }
                                                    transaction = (SIPClientTransaction)this.transactionChannel;
                                                    if (sipDialog == null && transaction != null && (sipDialog = transaction.getDialog(dialogID)) != null && sipDialog.getState() == DialogState.TERMINATED) {
                                                        sipDialog = null;
                                                    }
                                                    if (this.sipStack.isLoggingEnabled()) {
                                                        this.sipStack.getStackLogger().logDebug("Transaction = " + transaction + " sipDialog = " + sipDialog);
                                                    }
                                                    if (this.transactionChannel != null) {
                                                        String originalFrom = ((SIPRequest)this.transactionChannel.getRequest()).getFromTag();
                                                        if (originalFrom == null ^ sipResponse.getFrom().getTag() == null) {
                                                            if (this.sipStack.isLoggingEnabled()) {
                                                                this.sipStack.getStackLogger().logDebug("From tag mismatch -- dropping response");
                                                            }
                                                            break block43;
                                                        }
                                                        if (originalFrom != null && !originalFrom.equalsIgnoreCase(sipResponse.getFrom().getTag())) {
                                                            if (this.sipStack.isLoggingEnabled()) {
                                                                this.sipStack.getStackLogger().logDebug("From tag mismatch -- dropping response");
                                                            }
                                                            break block44;
                                                        }
                                                    }
                                                    if (!SIPTransactionStack.isDialogCreated(method) || sipResponse.getStatusCode() == 100 || sipResponse.getFrom().getTag() == null || sipResponse.getTo().getTag() == null || sipDialog != null) break block49;
                                                    if (sipProvider.isAutomaticDialogSupportEnabled()) {
                                                        if (this.transactionChannel != null) {
                                                            if (sipDialog == null) {
                                                                sipDialog = this.sipStack.createDialog((SIPClientTransaction)this.transactionChannel, sipResponse);
                                                                this.transactionChannel.setDialog(sipDialog, sipResponse.getDialogId(false));
                                                            }
                                                            break block47;
                                                        } else {
                                                            sipDialog = this.sipStack.createDialog(sipProvider, sipResponse);
                                                        }
                                                    }
                                                    break block47;
                                                }
                                                if (sipDialog != null && transaction == null && sipDialog.getState() != DialogState.TERMINATED) {
                                                    if (sipResponse.getStatusCode() / 100 != 2) {
                                                        if (this.sipStack.isLoggingEnabled()) {
                                                            this.sipStack.getStackLogger().logDebug("status code != 200 ; statusCode = " + sipResponse.getStatusCode());
                                                        }
                                                    } else {
                                                        if (sipDialog.getState() == DialogState.TERMINATED) {
                                                            if (this.sipStack.isLoggingEnabled()) {
                                                                this.sipStack.getStackLogger().logDebug("Dialog is terminated -- dropping response!");
                                                            }
                                                            if (sipResponse.getStatusCode() / 100 == 2 && sipResponse.getCSeq().getMethod().equals("INVITE")) {
                                                                try {
                                                                    Request ackRequest = sipDialog.createAck(sipResponse.getCSeq().getSeqNumber());
                                                                    sipDialog.sendAck(ackRequest);
                                                                }
                                                                catch (Exception ex) {
                                                                    this.sipStack.getStackLogger().logError("Error creating ack", ex);
                                                                }
                                                            }
                                                            break block45;
                                                        }
                                                        boolean ackAlreadySent = false;
                                                        if (sipDialog.isAckSeen() && sipDialog.getLastAckSent() != null && sipDialog.getLastAckSent().getCSeq().getSeqNumber() == sipResponse.getCSeq().getSeqNumber() && sipResponse.getDialogId(false).equals(sipDialog.getLastAckSent().getDialogId(false))) {
                                                            ackAlreadySent = true;
                                                        }
                                                        if (ackAlreadySent && sipResponse.getCSeq().getMethod().equals(sipDialog.getMethod())) {
                                                            try {
                                                                if (this.sipStack.isLoggingEnabled()) {
                                                                    this.sipStack.getStackLogger().logDebug("resending ACK");
                                                                }
                                                                sipDialog.resendAck();
                                                                break block46;
                                                            }
                                                            catch (SipException ex) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            if (this.sipStack.isLoggingEnabled()) {
                                                this.sipStack.getStackLogger().logDebug("sending response to TU for processing ");
                                            }
                                            if (sipDialog != null && sipResponse.getStatusCode() != 100 && sipResponse.getTo().getTag() != null) {
                                                sipDialog.setLastResponse(transaction, sipResponse);
                                            }
                                            ResponseEventExt responseEvent = new ResponseEventExt(sipProvider, transaction, sipDialog, sipResponse);
                                            if (this.sipStack.getMaxForkTime() != 0 && sipResponse.getCSeq().getMethod().equals("INVITE")) {
                                                SIPClientTransaction originalTx = this.sipStack.getForkedTransaction(sipResponse.getForkId());
                                                responseEvent.setOriginalTransaction(originalTx);
                                            }
                                            sipProvider.handleEvent((EventObject)((Object)responseEvent), transaction);
                                            break block48;
                                        }
                                        catch (Throwable throwable) {
                                            Object var11_15 = null;
                                            this.listeningPoint = null;
                                            throw throwable;
                                        }
                                    }
                                    Object var11_7 = null;
                                    this.listeningPoint = null;
                                    return;
                                }
                                Object var11_8 = null;
                                this.listeningPoint = null;
                                return;
                            }
                            Object var11_9 = null;
                            this.listeningPoint = null;
                            return;
                        }
                        Object var11_10 = null;
                        this.listeningPoint = null;
                        return;
                    }
                    Object var11_11 = null;
                    this.listeningPoint = null;
                    return;
                }
                Object var11_12 = null;
                this.listeningPoint = null;
                return;
            }
            Object var11_13 = null;
            this.listeningPoint = null;
            return;
        }
        Object var11_14 = null;
        this.listeningPoint = null;
    }
}

