/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.ClientTransactionExt;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import java.io.IOException;
import java.text.ParseException;
import java.util.EventObject;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.message.Request;

public class SIPClientTransaction
extends SIPTransaction
implements ServerResponseInterface,
ClientTransaction,
ClientTransactionExt {
    private Set<String> sipDialogs;
    private SIPRequest lastRequest;
    private int viaPort;
    private String viaHost;
    private transient ServerResponseInterface respondTo;
    private String defaultDialogId;
    private SIPDialog defaultDialog;
    private Hop nextHop;
    private boolean notifyOnRetransmit;
    private boolean timeoutIfStillInCallingState;
    private int callingStateTimeoutCount;
    private SIPStackTimerTask transactionTimer;
    private String originalRequestFromTag;
    private String originalRequestCallId;
    private Event originalRequestEventHeader;
    private Contact originalRequestContact;
    private String originalRequestScheme;
    private Object transactionTimerLock = new Object();
    private AtomicBoolean timerKStarted = new AtomicBoolean(false);
    private boolean transactionTimerCancelled = false;

    protected SIPClientTransaction(SIPTransactionStack newSIPStack, MessageChannel newChannelToUse) {
        super(newSIPStack, newChannelToUse);
        this.setBranch(Utils.getInstance().generateBranchId());
        this.messageProcessor = newChannelToUse.messageProcessor;
        this.setEncapsulatedChannel(newChannelToUse);
        this.notifyOnRetransmit = false;
        this.timeoutIfStillInCallingState = false;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Creating clientTransaction " + this);
            this.sipStack.getStackLogger().logStackTrace();
        }
        this.sipDialogs = new CopyOnWriteArraySet<String>();
    }

    public void setResponseInterface(ServerResponseInterface newRespondTo) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Setting response interface for " + this + " to " + newRespondTo);
            if (newRespondTo == null) {
                this.sipStack.getStackLogger().logStackTrace();
                this.sipStack.getStackLogger().logDebug("WARNING -- setting to null!");
            }
        }
        this.respondTo = newRespondTo;
    }

    public MessageChannel getRequestChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage messageToTest) {
        Via topMostViaHeader = messageToTest.getTopmostVia();
        String messageBranch = topMostViaHeader.getBranch();
        boolean rfc3261Compliant = this.getBranch() != null && messageBranch != null && this.getBranch().toLowerCase().startsWith("z9hg4bk") && messageBranch.toLowerCase().startsWith("z9hg4bk");
        boolean transactionMatches = false;
        if (3 == this.getInternalState()) {
            transactionMatches = rfc3261Compliant ? this.getBranch().equalsIgnoreCase(topMostViaHeader.getBranch()) && this.getMethod().equals(messageToTest.getCSeq().getMethod()) : this.getBranch().equals(messageToTest.getTransactionId());
        } else if (!this.isTerminated()) {
            if (rfc3261Compliant) {
                if (topMostViaHeader != null && this.getBranch().equalsIgnoreCase(topMostViaHeader.getBranch())) {
                    transactionMatches = this.getMethod().equals(messageToTest.getCSeq().getMethod());
                }
            } else {
                transactionMatches = this.getBranch() != null ? this.getBranch().equalsIgnoreCase(messageToTest.getTransactionId()) : this.getOriginalRequest().getTransactionId().equalsIgnoreCase(messageToTest.getTransactionId());
            }
        }
        return transactionMatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(SIPMessage messageToSend) throws IOException {
        try {
            SIPRequest transactionRequest = (SIPRequest)messageToSend;
            Via topVia = transactionRequest.getTopmostVia();
            try {
                topVia.setBranch(this.getBranch());
            }
            catch (ParseException ex) {
                // empty catch block
            }
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Sending Message " + messageToSend);
                this.sipStack.getStackLogger().logDebug("TransactionState " + this.getState());
            }
            if ((2 == this.getInternalState() || 0 == this.getInternalState()) && transactionRequest.getMethod().equals("ACK")) {
                if (this.isReliable()) {
                    this.setState(5);
                } else {
                    this.setState(3);
                }
                this.cleanUpOnTimer();
                super.sendMessage(transactionRequest);
                Object var6_6 = null;
                this.isMapped = true;
                this.startTransactionTimer();
                return;
            }
            try {
                this.lastRequest = transactionRequest;
                if (this.getInternalState() < 0) {
                    this.setOriginalRequest(transactionRequest);
                    if (transactionRequest.getMethod().equals("INVITE")) {
                        this.setState(0);
                    } else if (transactionRequest.getMethod().equals("ACK")) {
                        this.setState(5);
                        this.cleanUpOnTimer();
                    } else {
                        this.setState(1);
                    }
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    if (this.isInviteTransaction()) {
                        this.enableTimeoutTimer(64);
                    } else {
                        this.enableTimeoutTimer(64);
                    }
                }
                super.sendMessage(transactionRequest);
            }
            catch (IOException e) {
                this.setState(5);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.isMapped = true;
            this.startTransactionTimer();
            throw throwable;
        }
        Object var6_7 = null;
        this.isMapped = true;
        this.startTransactionTimer();
    }

    public synchronized void processResponse(SIPResponse transactionResponse, MessageChannel sourceChannel, SIPDialog dialog) {
        if (this.getInternalState() < 0) {
            return;
        }
        if ((3 == this.getInternalState() || 5 == this.getInternalState()) && transactionResponse.getStatusCode() / 100 == 1) {
            return;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("processing " + transactionResponse.getFirstLine() + "current state = " + this.getState());
            this.sipStack.getStackLogger().logDebug("dialog = " + dialog);
        }
        this.lastResponse = transactionResponse;
        try {
            if (this.isInviteTransaction()) {
                this.inviteClientTransaction(transactionResponse, sourceChannel, dialog);
            } else {
                this.nonInviteClientTransaction(transactionResponse, sourceChannel, dialog);
            }
        }
        catch (IOException ex) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logException(ex);
            }
            this.setState(5);
            this.raiseErrorEvent(2);
        }
    }

    private void nonInviteClientTransaction(SIPResponse transactionResponse, MessageChannel sourceChannel, SIPDialog sipDialog) throws IOException {
        int statusCode = transactionResponse.getStatusCode();
        if (1 == this.getInternalState()) {
            if (statusCode / 100 == 1) {
                this.setState(2);
                this.enableRetransmissionTimer(8);
                this.enableTimeoutTimer(64);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semRelease();
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semRelease();
                }
                if (!this.isReliable()) {
                    this.setState(3);
                    this.scheduleTimerK();
                } else {
                    this.setState(5);
                }
                this.cleanUpOnTimer();
            }
        } else if (2 == this.getInternalState()) {
            if (statusCode / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semRelease();
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semRelease();
                }
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                if (!this.isReliable()) {
                    this.setState(3);
                    this.scheduleTimerK();
                } else {
                    this.setState(5);
                }
                this.cleanUpOnTimer();
            }
        } else {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug(" Not sending response to TU! " + this.getState());
            }
            this.semRelease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTimerK() {
        if (this.transactionTimer != null && this.timerKStarted.compareAndSet(false, true)) {
            Object object = this.transactionTimerLock;
            synchronized (object) {
                if (!this.transactionTimerCancelled) {
                    this.sipStack.getTimer().cancel(this.transactionTimer);
                    this.transactionTimer = null;
                    this.sipStack.getTimer().schedule(new SIPStackTimerTask(){

                        public void runTask() {
                            SIPClientTransaction.this.fireTimeoutTimer();
                            SIPClientTransaction.this.cleanUpOnTerminated();
                        }
                    }, this.TIMER_K * this.BASE_TIMER_INTERVAL);
                    this.transactionTimerCancelled = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void inviteClientTransaction(SIPResponse transactionResponse, MessageChannel sourceChannel, SIPDialog dialog) throws IOException {
        int statusCode = transactionResponse.getStatusCode();
        if (5 == this.getInternalState()) {
            boolean ackAlreadySent = false;
            if (dialog != null && dialog.isAckSent(transactionResponse.getCSeq().getSeqNumber()) && dialog.getLastAckSent().getCSeq().getSeqNumber() == transactionResponse.getCSeq().getSeqNumber() && transactionResponse.getFromTag().equals(dialog.getLastAckSent().getFromTag())) {
                ackAlreadySent = true;
            }
            if (dialog != null && ackAlreadySent && transactionResponse.getCSeq().getMethod().equals(dialog.getMethod())) {
                try {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getStackLogger().logDebug("resending ACK");
                    }
                    dialog.resendAck();
                }
                catch (SipException ex) {
                    // empty catch block
                }
            }
            this.semRelease();
            return;
        }
        if (0 == this.getInternalState()) {
            if (statusCode / 100 == 2) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(5);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                    return;
                }
                this.semRelease();
                return;
            }
            if (statusCode / 100 == 1) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(2);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                    return;
                }
                this.semRelease();
                return;
            }
            if (300 > statusCode) return;
            if (statusCode > 699) return;
            try {
                this.sendMessage((SIPRequest)this.createErrorAck());
            }
            catch (Exception ex) {
                this.sipStack.getStackLogger().logError("Unexpected Exception sending ACK -- sending error AcK ", ex);
            }
            if (this.respondTo != null) {
                this.respondTo.processResponse(transactionResponse, this, dialog);
            } else {
                this.semRelease();
            }
            if (this.getDialog() != null && ((SIPDialog)this.getDialog()).isBackToBackUserAgent()) {
                ((SIPDialog)this.getDialog()).releaseAckSem();
            }
            if (!this.isReliable()) {
                this.setState(3);
                this.enableTimeoutTimer(this.TIMER_D);
            } else {
                this.setState(5);
            }
            this.cleanUpOnTimer();
            return;
        }
        if (2 == this.getInternalState()) {
            if (statusCode / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                    return;
                }
                this.semRelease();
                return;
            }
            if (statusCode / 100 == 2) {
                this.setState(5);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                    return;
                }
                this.semRelease();
                return;
            }
            if (300 > statusCode) return;
            if (statusCode > 699) return;
            try {
                this.sendMessage((SIPRequest)this.createErrorAck());
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
            }
            if (this.getDialog() != null) {
                ((SIPDialog)this.getDialog()).releaseAckSem();
            }
            if (!this.isReliable()) {
                this.setState(3);
                this.enableTimeoutTimer(this.TIMER_D);
            } else {
                this.setState(5);
            }
            this.cleanUpOnTimer();
            if (this.respondTo != null) {
                this.respondTo.processResponse(transactionResponse, this, dialog);
                return;
            }
            this.semRelease();
            return;
        }
        if (3 != this.getInternalState()) return;
        if (300 > statusCode) return;
        if (statusCode > 699) return;
        try {
            try {
                this.sendMessage((SIPRequest)this.createErrorAck());
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
                Object var8_11 = null;
                this.semRelease();
                return;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.semRelease();
            throw throwable;
        }
        this.semRelease();
    }

    public void sendRequest() throws SipException {
        SIPRequest sipRequest = this.getOriginalRequest();
        if (this.getInternalState() >= 0) {
            throw new SipException("Request already sent");
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("sendRequest() " + sipRequest);
        }
        try {
            sipRequest.checkHeaders();
        }
        catch (ParseException ex) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("missing required header");
            }
            throw new SipException(ex.getMessage());
        }
        if (this.getMethod().equals("SUBSCRIBE") && sipRequest.getHeader("Expires") == null && this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logWarning("Expires header missing in outgoing subscribe -- Notifier will assume implied value on event package");
        }
        try {
            SIPDialog dialog;
            if (this.getMethod().equals("CANCEL") && this.sipStack.isCancelClientTransactionChecked()) {
                SIPClientTransaction ct = (SIPClientTransaction)this.sipStack.findCancelTransaction(this.getOriginalRequest(), false);
                if (ct == null) {
                    throw new SipException("Could not find original tx to cancel. RFC 3261 9.1");
                }
                if (ct.getInternalState() < 0) {
                    throw new SipException("State is null no provisional response yet -- cannot cancel RFC 3261 9.1");
                }
                if (!ct.getMethod().equals("INVITE")) {
                    throw new SipException("Cannot cancel non-invite requests RFC 3261 9.1");
                }
            } else if (this.getMethod().equals("BYE") || this.getMethod().equals("NOTIFY")) {
                dialog = this.sipStack.getDialog(this.getOriginalRequest().getDialogId(false));
                if (this.getSipProvider().isAutomaticDialogSupportEnabled() && dialog != null) {
                    throw new SipException("Dialog is present and AutomaticDialogSupport is enabled for  the provider -- Send the Request using the Dialog.sendRequest(transaction)");
                }
            }
            if (this.getMethod().equals("INVITE") && (dialog = this.getDefaultDialog()) != null && dialog.isBackToBackUserAgent() && !dialog.takeAckSem()) {
                throw new SipException("Failed to take ACK semaphore");
            }
            this.isMapped = true;
            this.sendMessage(sipRequest);
        }
        catch (IOException ex) {
            this.setState(5);
            throw new SipException(ex.getMessage() == null ? "IO Error sending request" : ex.getMessage(), (Throwable)ex);
        }
    }

    protected void fireRetransmissionTimer() {
        block9: {
            try {
                if (this.getInternalState() < 0 || !this.isMapped) {
                    return;
                }
                boolean inv = this.isInviteTransaction();
                int s = this.getInternalState();
                if ((!inv || 0 != s) && (inv || 1 != s && 2 != s) || this.lastRequest == null) break block9;
                if (this.sipStack.generateTimeStampHeader && this.lastRequest.getHeader("Timestamp") != null) {
                    long milisec = System.currentTimeMillis();
                    TimeStamp timeStamp = new TimeStamp();
                    try {
                        timeStamp.setTimeStamp(milisec);
                    }
                    catch (InvalidArgumentException ex) {
                        InternalErrorHandler.handleException((Exception)((Object)ex));
                    }
                    this.lastRequest.setHeader(timeStamp);
                }
                super.sendMessage(this.lastRequest);
                if (this.notifyOnRetransmit) {
                    TimeoutEvent txTimeout = new TimeoutEvent((Object)this.getSipProvider(), (ClientTransaction)this, Timeout.RETRANSMIT);
                    this.getSipProvider().handleEvent((EventObject)txTimeout, this);
                }
                if (this.timeoutIfStillInCallingState && this.getInternalState() == 0) {
                    --this.callingStateTimeoutCount;
                    if (this.callingStateTimeoutCount == 0) {
                        TimeoutEvent timeoutEvent = new TimeoutEvent((Object)this.getSipProvider(), (ClientTransaction)this, Timeout.RETRANSMIT);
                        this.getSipProvider().handleEvent((EventObject)timeoutEvent, this);
                        this.timeoutIfStillInCallingState = false;
                    }
                }
            }
            catch (IOException e) {
                this.raiseIOExceptionEvent();
                this.raiseErrorEvent(2);
            }
        }
    }

    protected void fireTimeoutTimer() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("fireTimeoutTimer " + this);
        }
        SIPDialog dialog = (SIPDialog)this.getDialog();
        if (0 == this.getInternalState() || 1 == this.getInternalState() || 2 == this.getInternalState()) {
            if (dialog != null && (dialog.getState() == null || dialog.getState() == DialogState.EARLY)) {
                this.getSIPStack();
                if (SIPTransactionStack.isDialogCreated(this.getMethod())) {
                    dialog.delete();
                }
            } else if (dialog != null && this.getMethod().equalsIgnoreCase("BYE") && dialog.isTerminatedOnBye()) {
                dialog.delete();
            }
        }
        if (3 != this.getInternalState() && 5 != this.getInternalState()) {
            SIPClientTransaction inviteTx;
            this.raiseErrorEvent(1);
            if (this.getMethod().equalsIgnoreCase("CANCEL") && (inviteTx = (SIPClientTransaction)this.getOriginalRequest().getInviteTransaction()) != null && (inviteTx.getInternalState() == 0 || inviteTx.getInternalState() == 2) && inviteTx.getDialog() != null) {
                inviteTx.setState(5);
            }
        } else {
            this.setState(5);
        }
    }

    public Request createCancel() throws SipException {
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("Bad state " + this.getState());
        }
        if (!originalRequest.getMethod().equals("INVITE")) {
            throw new SipException("Only INIVTE may be cancelled");
        }
        if (originalRequest.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot Cancel ACK!");
        }
        SIPRequest cancelRequest = originalRequest.createCancelRequest();
        cancelRequest.setInviteTransaction(this);
        return cancelRequest;
    }

    public Request createAck() throws SipException {
        Route route;
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("bad state " + this.getState());
        }
        if (this.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot ACK an ACK!");
        }
        if (this.lastResponse == null) {
            throw new SipException("bad Transaction state");
        }
        if (this.lastResponse.getStatusCode() < 200) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("lastResponse = " + this.lastResponse);
            }
            throw new SipException("Cannot ACK a provisional response!");
        }
        SIPRequest ackRequest = originalRequest.createAckRequest((To)this.lastResponse.getTo());
        RecordRouteList recordRouteList = this.lastResponse.getRecordRouteHeaders();
        if (recordRouteList == null) {
            if (this.lastResponse.getContactHeaders() != null && this.lastResponse.getStatusCode() / 100 != 3) {
                Contact contact = (Contact)this.lastResponse.getContactHeaders().getFirst();
                URI uri = (URI)contact.getAddress().getURI().clone();
                ackRequest.setRequestURI(uri);
            }
            return ackRequest;
        }
        ackRequest.removeHeader("Route");
        RouteList routeList = new RouteList();
        ListIterator li = recordRouteList.listIterator(recordRouteList.size());
        while (li.hasPrevious()) {
            RecordRoute rr = (RecordRoute)li.previous();
            route = new Route();
            route.setAddress((AddressImpl)((AddressImpl)rr.getAddress()).clone());
            route.setParameters((NameValueList)rr.getParameters().clone());
            routeList.add(route);
        }
        Contact contact = null;
        if (this.lastResponse.getContactHeaders() != null) {
            contact = (Contact)this.lastResponse.getContactHeaders().getFirst();
        }
        if (!((SipURI)((Route)routeList.getFirst()).getAddress().getURI()).hasLrParam()) {
            route = null;
            if (contact != null) {
                route = new Route();
                route.setAddress((AddressImpl)((AddressImpl)contact.getAddress()).clone());
            }
            Route firstRoute = (Route)routeList.getFirst();
            routeList.removeFirst();
            URI uri = firstRoute.getAddress().getURI();
            ackRequest.setRequestURI(uri);
            if (route != null) {
                routeList.add(route);
            }
            ackRequest.addHeader(routeList);
        } else if (contact != null) {
            URI uri = (URI)contact.getAddress().getURI().clone();
            ackRequest.setRequestURI(uri);
            ackRequest.addHeader(routeList);
        }
        return ackRequest;
    }

    private final Request createErrorAck() throws SipException, ParseException {
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("bad state " + this.getState());
        }
        if (!this.getMethod().equals("INVITE")) {
            throw new SipException("Can only ACK an INVITE!");
        }
        if (this.lastResponse == null) {
            throw new SipException("bad Transaction state");
        }
        if (this.lastResponse.getStatusCode() < 200) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("lastResponse = " + this.lastResponse);
            }
            throw new SipException("Cannot ACK a provisional response!");
        }
        return originalRequest.createErrorAck((To)this.lastResponse.getTo());
    }

    protected void setViaPort(int port) {
        this.viaPort = port;
    }

    protected void setViaHost(String host) {
        this.viaHost = host;
    }

    public int getViaPort() {
        return this.viaPort;
    }

    public String getViaHost() {
        return this.viaHost;
    }

    public Via getOutgoingViaHeader() {
        return this.getMessageProcessor().getViaHeader();
    }

    public void clearState() {
    }

    public void setState(int newState) {
        if (newState == 5 && this.isReliable() && !this.getSIPStack().cacheClientConnections) {
            this.collectionTime = 64;
        }
        if (super.getInternalState() != 3 && (newState == 3 || newState == 5)) {
            this.sipStack.decrementActiveClientTransactionCount();
        }
        super.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTransactionTimer() {
        if (this.transactionTimerStarted.compareAndSet(false, true) && this.sipStack.getTimer() != null) {
            Object object = this.transactionTimerLock;
            synchronized (object) {
                if (!this.transactionTimerCancelled) {
                    this.transactionTimer = new TransactionTimer();
                    this.sipStack.getTimer().scheduleWithFixedDelay(this.transactionTimer, this.BASE_TIMER_INTERVAL, this.BASE_TIMER_INTERVAL);
                }
            }
        }
    }

    public void terminate() throws ObjectInUseException {
        this.setState(5);
    }

    public boolean checkFromTag(SIPResponse sipResponse) {
        String originalFromTag = this.getOriginalRequestFromTag();
        if (this.defaultDialog != null) {
            if (originalFromTag == null ^ sipResponse.getFrom().getTag() == null) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("From tag mismatch -- dropping response");
                }
                return false;
            }
            if (originalFromTag != null && !originalFromTag.equalsIgnoreCase(sipResponse.getFrom().getTag())) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("From tag mismatch -- dropping response");
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processResponse(SIPResponse sipResponse, MessageChannel incomingChannel) {
        block16: {
            block14: {
                block15: {
                    dialog = null;
                    method = sipResponse.getCSeq().getMethod();
                    dialogId = sipResponse.getDialogId(false);
                    if (method.equals("CANCEL") && this.lastRequest != null) {
                        ict = (SIPClientTransaction)this.lastRequest.getInviteTransaction();
                        if (ict != null) {
                            dialog = ict.defaultDialog;
                        }
                    } else {
                        dialog = this.getDialog(dialogId);
                    }
                    if (dialog != null) break block14;
                    code = sipResponse.getStatusCode();
                    if (code <= 100 || code >= 300 || sipResponse.getToTag() == null && !this.sipStack.isRfc2543Supported()) break block15;
                    if (!SIPTransactionStack.isDialogCreated(method)) break block15;
                    var7_8 = this;
                    synchronized (var7_8) {
                        if (this.defaultDialog == null) ** GOTO lbl34
                        if (sipResponse.getFromTag() != null) {
                            defaultDialogId = this.defaultDialog.getDialogId();
                            if (this.defaultDialog.getLastResponseMethod() == null || method.equals("SUBSCRIBE") && this.defaultDialog.getLastResponseMethod().equals("NOTIFY") && defaultDialogId.equals(dialogId)) {
                                this.defaultDialog.setLastResponse(this, sipResponse);
                                dialog = this.defaultDialog;
                            } else {
                                dialog = this.sipStack.getDialog(dialogId);
                                if (dialog == null && this.defaultDialog.isAssigned()) {
                                    dialog = this.sipStack.createDialog(this, sipResponse);
                                }
                            }
                            if (dialog != null) {
                                this.setDialog(dialog, dialog.getDialogId());
                            } else {
                                this.sipStack.getStackLogger().logError("dialog is unexpectedly null", new NullPointerException());
                            }
                        } else {
                            throw new RuntimeException("Response without from-tag");
lbl34:
                            // 1 sources

                            if (this.sipStack.isAutomaticDialogSupportEnabled) {
                                dialog = this.sipStack.createDialog(this, sipResponse);
                                this.setDialog(dialog, dialog.getDialogId());
                            }
                        }
                    }
                }
                dialog = this.defaultDialog;
                break block16;
            }
            dialog.setLastResponse(this, sipResponse);
        }
        this.processResponse(sipResponse, incomingChannel, dialog);
    }

    public Dialog getDialog() {
        SIPDialog retval = null;
        SIPResponse localLastResponse = this.lastResponse;
        if (localLastResponse != null && localLastResponse.getFromTag() != null && localLastResponse.getToTag() != null && localLastResponse.getStatusCode() != 100) {
            String dialogId = localLastResponse.getDialogId(false);
            retval = this.getDialog(dialogId);
        }
        if (retval == null) {
            retval = this.getDefaultDialog();
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug(" sipDialogs =  " + this.sipDialogs + " default dialog " + this.getDefaultDialog() + " retval " + retval);
        }
        return retval;
    }

    public SIPDialog getDialog(String dialogId) {
        SIPDialog retval = null;
        if (this.sipDialogs != null && this.sipDialogs.contains(dialogId) && (retval = this.sipStack.getDialog(dialogId)) == null) {
            retval = this.sipStack.getEarlyDialog(dialogId);
        }
        return retval;
    }

    public void setDialog(SIPDialog sipDialog, String dialogId) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("setDialog: " + dialogId + " sipDialog = " + sipDialog);
        }
        if (sipDialog == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("NULL DIALOG!!");
            }
            throw new NullPointerException("bad dialog null");
        }
        if (this.defaultDialog == null) {
            this.defaultDialog = sipDialog;
            if (this.getMethod().equals("INVITE") && this.getSIPStack().getMaxForkTime() != 0) {
                this.getSIPStack().addForkedClientTransaction(this);
            }
        }
        if (dialogId != null && sipDialog.getDialogId() != null && this.sipDialogs != null) {
            this.sipDialogs.add(dialogId);
        }
    }

    public SIPDialog getDefaultDialog() {
        SIPDialog dialog = this.defaultDialog;
        if (dialog == null && this.defaultDialogId != null) {
            dialog = this.sipStack.getDialog(this.defaultDialogId);
        }
        return dialog;
    }

    public void setNextHop(Hop hop) {
        this.nextHop = hop;
    }

    public Hop getNextHop() {
        return this.nextHop;
    }

    public void setNotifyOnRetransmit(boolean notifyOnRetransmit) {
        this.notifyOnRetransmit = notifyOnRetransmit;
    }

    public boolean isNotifyOnRetransmit() {
        return this.notifyOnRetransmit;
    }

    public void alertIfStillInCallingStateBy(int count) {
        this.timeoutIfStillInCallingState = true;
        this.callingStateTimeoutCount = count;
    }

    protected void cleanUpOnTimer() {
        if (this.sipStack.isAggressiveCleanup()) {
            String dialogId;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("cleanupOnTimer: " + this.getTransactionId());
            }
            if (this.defaultDialog != null && (dialogId = this.defaultDialog.getDialogId()) != null && this.sipStack.getDialog(dialogId) != null) {
                this.defaultDialogId = dialogId;
                this.defaultDialog = null;
            }
            if (this.originalRequest != null) {
                this.originalRequest.setTransaction(null);
                this.originalRequest.setInviteTransaction(null);
                this.originalRequest.cleanUp();
                if (!this.getMethod().equalsIgnoreCase("INVITE") && !this.getMethod().equalsIgnoreCase("CANCEL")) {
                    this.originalRequestBytes = this.originalRequest.encodeAsBytes(this.getTransport());
                    this.originalRequestFromTag = this.originalRequest.getFromTag();
                    this.originalRequestCallId = this.originalRequest.getCallId().getCallId();
                    this.originalRequestEventHeader = (Event)this.originalRequest.getHeader("Event");
                    this.originalRequestContact = this.originalRequest.getContactHeader();
                    this.originalRequestScheme = this.originalRequest.getRequestURI().getScheme();
                    this.originalRequest = null;
                }
            }
            if (!this.getMethod().equalsIgnoreCase("SUBSCRIBE")) {
                this.lastResponse = null;
            }
            this.lastRequest = null;
        }
    }

    public void cleanUp() {
        if (this.sipStack.isAggressiveCleanup()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("cleanup : " + this.getTransactionId());
            }
            if (this.defaultDialog != null) {
                this.defaultDialogId = this.defaultDialog.getDialogId();
                this.defaultDialog = null;
            }
            this.originalRequest = null;
            this.cleanUpOnTimer();
            this.originalRequestBytes = null;
            this.originalRequestBranch = null;
            this.originalRequestCallId = null;
            this.originalRequestEventHeader = null;
            this.originalRequestFromTag = null;
            this.originalRequestContact = null;
            this.originalRequestScheme = null;
            if (this.sipDialogs != null) {
                this.sipDialogs.clear();
            }
            this.respondTo = null;
            this.transactionTimer = null;
            this.lastResponse = null;
            this.transactionTimerLock = null;
            this.transactionTimerStarted = null;
            this.timerKStarted = null;
        }
    }

    protected void cleanUpOnTerminated() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("removing  = " + this + " isReliable " + this.isReliable());
        }
        if (this.sipStack.isAggressiveCleanup() && this.originalRequest == null && this.originalRequestBytes != null) {
            try {
                this.originalRequest = (SIPRequest)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.originalRequestBytes, true, false, null);
                this.originalRequestBytes = null;
            }
            catch (ParseException e) {
                this.sipStack.getStackLogger().logError("message " + this.originalRequestBytes + "could not be reparsed !");
            }
        }
        this.sipStack.removeTransaction(this);
        if (!this.sipStack.cacheClientConnections && this.isReliable()) {
            int newUseCount;
            if ((newUseCount = --this.getMessageChannel().useCount) <= 0) {
                SIPTransaction.LingerTimer myTimer = new SIPTransaction.LingerTimer();
                this.sipStack.getTimer().schedule(myTimer, 8000L);
            }
        } else {
            if (this.sipStack.isLoggingEnabled() && this.isReliable()) {
                int useCount = this.getMessageChannel().useCount;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("Client Use Count = " + useCount);
                }
            }
            if (((SipStackImpl)this.getSIPStack()).isReEntrantListener() && this.sipStack.isAggressiveCleanup()) {
                this.cleanUp();
            } else {
                SIPTransaction.LingerTimer myTimer = new SIPTransaction.LingerTimer();
                this.sipStack.getTimer().schedule(myTimer, 8000L);
            }
        }
    }

    public String getOriginalRequestFromTag() {
        if (this.originalRequest == null) {
            return this.originalRequestFromTag;
        }
        return this.originalRequest.getFromTag();
    }

    public String getOriginalRequestCallId() {
        if (this.originalRequest == null) {
            return this.originalRequestCallId;
        }
        return this.originalRequest.getCallId().getCallId();
    }

    public Event getOriginalRequestEvent() {
        if (this.originalRequest == null) {
            return this.originalRequestEventHeader;
        }
        return (Event)this.originalRequest.getHeader("Event");
    }

    public Contact getOriginalRequestContact() {
        if (this.originalRequest == null) {
            return this.originalRequestContact;
        }
        return this.originalRequest.getContactHeader();
    }

    public String getOriginalRequestScheme() {
        if (this.originalRequest == null) {
            return this.originalRequestScheme;
        }
        return this.originalRequest.getRequestURI().getScheme();
    }

    public class TransactionTimer
    extends SIPStackTimerTask {
        public void runTask() {
            SIPClientTransaction clientTransaction = SIPClientTransaction.this;
            SIPTransactionStack sipStack = clientTransaction.sipStack;
            if (clientTransaction.isTerminated()) {
                block4: {
                    try {
                        sipStack.getTimer().cancel(this);
                    }
                    catch (IllegalStateException ex) {
                        if (sipStack.isAlive()) break block4;
                        return;
                    }
                }
                SIPClientTransaction.this.cleanUpOnTerminated();
            } else {
                clientTransaction.fireTimer();
            }
        }
    }
}

