/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.ServerLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.LogRecord;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import javax.sip.SipStack;
import javax.sip.header.TimeStampHeader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ServerLog
implements ServerLogger {
    private boolean logContent;
    protected StackLogger stackLogger;
    private String logFileName;
    private PrintWriter printWriter;
    private String auxInfo;
    private String description;
    private String stackIpAddress;
    private SIPTransactionStack sipStack;
    private Properties configurationProperties;
    protected int traceLevel = 16;

    private void setProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
        this.description = configurationProperties.getProperty("javax.sip.STACK_NAME");
        this.stackIpAddress = configurationProperties.getProperty("javax.sip.IP_ADDRESS");
        this.logFileName = configurationProperties.getProperty("gov.nist.javax.sip.SERVER_LOG");
        String logLevel = configurationProperties.getProperty("gov.nist.javax.sip.TRACE_LEVEL");
        String logContent = configurationProperties.getProperty("gov.nist.javax.sip.LOG_MESSAGE_CONTENT");
        boolean bl = this.logContent = logContent != null && logContent.equals("true");
        if (logLevel != null) {
            if (logLevel.equals("LOG4J")) {
                Logger logger = Logger.getLogger((String)configurationProperties.getProperty("gov.nist.javax.sip.LOG4J_LOGGER_NAME", this.description));
                Level level = logger.getEffectiveLevel();
                if (level == Level.OFF) {
                    this.setTraceLevel(0);
                } else if (level.isGreaterOrEqual((Priority)Level.DEBUG)) {
                    this.setTraceLevel(32);
                } else if (level.isGreaterOrEqual((Priority)Level.INFO)) {
                    this.setTraceLevel(16);
                } else if (level.isGreaterOrEqual((Priority)Level.WARN)) {
                    this.setTraceLevel(4);
                }
            } else {
                try {
                    int ll = logLevel.equals("DEBUG") ? 32 : (logLevel.equals("INFO") ? 16 : (logLevel.equals("ERROR") ? 4 : (logLevel.equals("NONE") || logLevel.equals("OFF") ? 0 : Integer.parseInt(logLevel))));
                    this.setTraceLevel(ll);
                }
                catch (NumberFormatException ex) {
                    System.out.println("ServerLog: WARNING Bad integer " + logLevel);
                    System.out.println("logging dislabled ");
                    this.setTraceLevel(0);
                }
            }
        }
        this.checkLogFile();
    }

    public void setStackIpAddress(String ipAddress) {
        this.stackIpAddress = ipAddress;
    }

    public synchronized void closeLogFile() {
        if (this.printWriter != null) {
            this.printWriter.close();
            this.printWriter = null;
        }
    }

    public void checkLogFile() {
        if (this.logFileName == null || this.traceLevel < 16) {
            return;
        }
        try {
            File logFile = new File(this.logFileName);
            if (!logFile.exists()) {
                logFile.createNewFile();
                this.printWriter = null;
            }
            if (this.printWriter == null) {
                boolean overwrite = Boolean.valueOf(this.configurationProperties.getProperty("gov.nist.javax.sip.SERVER_LOG_OVERWRITE"));
                FileWriter fw = new FileWriter(this.logFileName, !overwrite);
                this.printWriter = new PrintWriter((Writer)fw, true);
                this.printWriter.println("<!-- Use the  Trace Viewer in src/tools/tracesviewer to view this  trace  \nHere are the stack configuration properties \njavax.sip.IP_ADDRESS= " + this.configurationProperties.getProperty("javax.sip.IP_ADDRESS") + "\n" + "javax.sip.STACK_NAME= " + this.configurationProperties.getProperty("javax.sip.STACK_NAME") + "\n" + "javax.sip.ROUTER_PATH= " + this.configurationProperties.getProperty("javax.sip.ROUTER_PATH") + "\n" + "javax.sip.OUTBOUND_PROXY= " + this.configurationProperties.getProperty("javax.sip.OUTBOUND_PROXY") + "\n" + "-->");
                this.printWriter.println("<description\n logDescription=\"" + this.description + "\"\n name=\"" + this.configurationProperties.getProperty("javax.sip.STACK_NAME") + "\"\n auxInfo=\"" + this.auxInfo + "\"/>\n ");
                if (this.auxInfo != null) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.stackLogger.logDebug("Here are the stack configuration properties \njavax.sip.IP_ADDRESS= " + this.configurationProperties.getProperty("javax.sip.IP_ADDRESS") + "\n" + "javax.sip.ROUTER_PATH= " + this.configurationProperties.getProperty("javax.sip.ROUTER_PATH") + "\n" + "javax.sip.OUTBOUND_PROXY= " + this.configurationProperties.getProperty("javax.sip.OUTBOUND_PROXY") + "\n" + "gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS= " + this.configurationProperties.getProperty("gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS") + "\n" + "gov.nist.javax.sip.CACHE_SERVER_CONNECTIONS= " + this.configurationProperties.getProperty("gov.nist.javax.sip.CACHE_SERVER_CONNECTIONS") + "\n" + "gov.nist.javax.sip.REENTRANT_LISTENER= " + this.configurationProperties.getProperty("gov.nist.javax.sip.REENTRANT_LISTENER") + "gov.nist.javax.sip.THREAD_POOL_SIZE= " + this.configurationProperties.getProperty("gov.nist.javax.sip.THREAD_POOL_SIZE") + "\n");
                        this.stackLogger.logDebug(" ]]> ");
                        this.stackLogger.logDebug("</debug>");
                        this.stackLogger.logDebug("<description\n logDescription=\"" + this.description + "\"\n name=\"" + this.stackIpAddress + "\"\n auxInfo=\"" + this.auxInfo + "\"/>\n ");
                        this.stackLogger.logDebug("<debug>");
                        this.stackLogger.logDebug("<![CDATA[ ");
                    }
                } else if (this.sipStack.isLoggingEnabled()) {
                    this.stackLogger.logDebug("Here are the stack configuration properties \n" + this.configurationProperties + "\n");
                    this.stackLogger.logDebug(" ]]>");
                    this.stackLogger.logDebug("</debug>");
                    this.stackLogger.logDebug("<description\n logDescription=\"" + this.description + "\"\n name=\"" + this.stackIpAddress + "\" />\n");
                    this.stackLogger.logDebug("<debug>");
                    this.stackLogger.logDebug("<![CDATA[ ");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean needsLogging() {
        return this.logFileName != null;
    }

    public void setLogFileName(String name) {
        this.logFileName = name;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    private void logMessage(String message) {
        this.checkLogFile();
        String logInfo = message;
        if (this.printWriter != null) {
            this.printWriter.println(logInfo);
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.stackLogger.logInfo(logInfo);
        }
    }

    private void logMessage(String message, String from, String to, boolean sender, String callId, String firstLine, String status, String tid, long time, long timestampVal) {
        LogRecord log = this.sipStack.logRecordFactory.createLogRecord(message, from, to, time, sender, firstLine, tid, callId, timestampVal);
        if (log != null) {
            this.logMessage(((Object)log).toString());
        }
    }

    public void logMessage(SIPMessage message, String from, String to, boolean sender, long time) {
        this.checkLogFile();
        if (message.getFirstLine() == null) {
            return;
        }
        CallID cid = (CallID)message.getCallId();
        String callId = null;
        if (cid != null) {
            callId = cid.getCallId();
        }
        String firstLine = message.getFirstLine().trim();
        String inputText = this.logContent ? message.encode() : message.encodeMessage(new StringBuilder()).toString();
        String tid = message.getTransactionId();
        TimeStampHeader tsHdr = (TimeStampHeader)message.getHeader("Timestamp");
        long tsval = tsHdr == null ? 0L : tsHdr.getTime();
        this.logMessage(inputText, from, to, sender, callId, firstLine, null, tid, time, tsval);
    }

    public void logMessage(SIPMessage message, String from, String to, String status, boolean sender, long time) {
        this.checkLogFile();
        CallID cid = (CallID)message.getCallId();
        String callId = null;
        if (cid != null) {
            callId = cid.getCallId();
        }
        String firstLine = message.getFirstLine().trim();
        String encoded = this.logContent ? message.encode() : message.encodeMessage(new StringBuilder()).toString();
        String tid = message.getTransactionId();
        TimeStampHeader tshdr = (TimeStampHeader)message.getHeader("Timestamp");
        long tsval = tshdr == null ? 0L : tshdr.getTime();
        this.logMessage(encoded, from, to, sender, callId, firstLine, status, tid, time, tsval);
    }

    public void logMessage(SIPMessage message, String from, String to, String status, boolean sender) {
        this.logMessage(message, from, to, status, sender, System.currentTimeMillis());
    }

    public void logException(Exception ex) {
        if (this.traceLevel >= 4) {
            this.checkLogFile();
            ex.printStackTrace();
            if (this.printWriter != null) {
                ex.printStackTrace(this.printWriter);
            }
        }
    }

    public void setTraceLevel(int level) {
        this.traceLevel = level;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public void setAuxInfo(String auxInfo) {
        this.auxInfo = auxInfo;
    }

    public void setSipStack(SipStack sipStack) {
        if (!(sipStack instanceof SIPTransactionStack)) {
            throw new IllegalArgumentException("sipStack must be a SIPTransactionStack");
        }
        this.sipStack = (SIPTransactionStack)sipStack;
        this.stackLogger = this.sipStack.getStackLogger();
    }

    public void setStackProperties(Properties stackProperties) {
        this.setProperties(stackProperties);
    }

    public void setLevel(int jsipLoggingLevel) {
    }
}

