/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.CommonLogger;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.MessageParser;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.BlockingQueueDispatchAuditor;
import gov.nist.javax.sip.stack.QueuedMessageDispatchBase;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class PipelinedMsgParser
implements Runnable {
    private static StackLogger logger = CommonLogger.getLogger(PipelinedMsgParser.class);
    private static final String CRLF = "\r\n";
    protected SIPMessageListener sipMessageListener;
    private Thread mythread;
    private Pipeline rawInputStream;
    private int maxMessageSize;
    private int sizeCounter;
    private SIPTransactionStack sipStack;
    private MessageParser smp = null;
    private ConcurrentHashMap<String, CallIDOrderingStructure> messagesOrderingMap = new ConcurrentHashMap();
    boolean isRunning = false;
    private static int uid = 0;
    private static ExecutorService postParseExecutor = null;
    public static BlockingQueue<Runnable> staticQueue;
    public static BlockingQueueDispatchAuditor staticQueueAuditor;

    protected PipelinedMsgParser() {
    }

    private static synchronized int getNewUid() {
        return uid++;
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener sipMessageListener, Pipeline in, boolean debug, int maxMessageSize) {
        this();
        this.sipStack = sipStack;
        this.smp = sipStack.getMessageParserFactory().createMessageParser(sipStack);
        this.sipMessageListener = sipMessageListener;
        this.rawInputStream = in;
        this.maxMessageSize = maxMessageSize;
        this.mythread = new Thread(this);
        this.mythread.setName("PipelineThread-" + PipelinedMsgParser.getNewUid());
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener mhandler, Pipeline in, int maxMsgSize) {
        this(sipStack, mhandler, in, false, maxMsgSize);
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, Pipeline in) {
        this(sipStack, null, in, false, 0);
    }

    public void processInput() {
        this.mythread.start();
    }

    protected Object clone() {
        PipelinedMsgParser p = new PipelinedMsgParser();
        p.rawInputStream = this.rawInputStream;
        p.sipMessageListener = this.sipMessageListener;
        Thread mythread = new Thread(p);
        mythread.setName("PipelineThread");
        return p;
    }

    public void setMessageListener(SIPMessageListener mlistener) {
        this.sipMessageListener = mlistener;
    }

    private String readLine(InputStream inputStream) throws IOException {
        int increment;
        int counter = 0;
        int bufferSize = increment = 1024;
        byte[] lineBuffer = new byte[bufferSize];
        byte[] crlfBuffer = new byte[2];
        int crlfCounter = 0;
        while (true) {
            int i;
            if ((i = inputStream.read()) == -1) {
                throw new IOException("End of stream");
            }
            char ch = (char)(i & 0xFF);
            if (this.maxMessageSize > 0) {
                --this.sizeCounter;
                if (this.sizeCounter <= 0) {
                    throw new IOException("Max size exceeded!");
                }
            }
            if (ch != '\r') {
                lineBuffer[counter++] = (byte)(i & 0xFF);
            } else if (counter == 0) {
                crlfBuffer[crlfCounter++] = 13;
            }
            if (ch == '\n') {
                if (counter != 1 || crlfCounter <= 0) break;
                crlfBuffer[crlfCounter++] = 10;
                break;
            }
            if (counter != bufferSize) continue;
            byte[] tempBuffer = new byte[bufferSize + increment];
            System.arraycopy(lineBuffer, 0, tempBuffer, 0, bufferSize);
            bufferSize += increment;
            lineBuffer = tempBuffer;
        }
        if (counter == 1 && crlfCounter > 0) {
            return new String(crlfBuffer, 0, crlfCounter, "UTF-8");
        }
        return new String(lineBuffer, 0, counter, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        Pipeline inputStream = this.rawInputStream;
        StackLogger stackLogger = logger;
        try {
            this.isRunning = true;
            while (this.isRunning) {
                SIPMessage sipMessage;
                block71: {
                    ConcurrentHashMap<String, CallIDOrderingStructure> concurrentHashMap;
                    String line1;
                    String line2;
                    StringBuilder inputBuffer;
                    block68: {
                        this.sizeCounter = this.maxMessageSize;
                        inputBuffer = new StringBuilder();
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Starting to parse.");
                        }
                        line2 = null;
                        boolean isPreviousLineCRLF = false;
                        block32: while (true) {
                            while (true) {
                                if ((line1 = this.readLine(inputStream)).equals("\n")) {
                                    if (!logger.isLoggingEnabled(32)) continue;
                                    logger.logDebug("Discarding blank line");
                                    continue;
                                }
                                if (!CRLF.equals(line1)) break block68;
                                if (isPreviousLineCRLF) {
                                    if (logger.isLoggingEnabled(32)) {
                                        logger.logDebug("KeepAlive Double CRLF received, sending single CRLF as defined per RFC 5626 Section 4.4.1");
                                    }
                                    try {
                                        this.sipMessageListener.sendSingleCLRF();
                                        continue block32;
                                    }
                                    catch (Exception e) {
                                        logger.logError("A problem occured while trying to send a single CLRF in response to a double CLRF", e);
                                        continue;
                                    }
                                }
                                isPreviousLineCRLF = true;
                                if (!logger.isLoggingEnabled(32)) continue;
                                logger.logDebug("Received CRLF");
                            }
                            break;
                        }
                        catch (IOException ex) {
                            if (postParseExecutor != null && this.isRunning) {
                                if (logger.isLoggingEnabled(32)) {
                                    logger.logDebug("waiting for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                                }
                                concurrentHashMap = this.messagesOrderingMap;
                                synchronized (concurrentHashMap) {
                                    try {
                                        this.messagesOrderingMap.wait();
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                    }
                                }
                                if (logger.isLoggingEnabled(32)) {
                                    logger.logDebug("got notified for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                                }
                            }
                            this.rawInputStream.stopTimer();
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("thread ending for threadname " + this.mythread.getName());
                            }
                            if (logger.isLoggingEnabled(32)) {
                                logger.logStackTrace(32);
                            }
                            Object var16_27 = null;
                            try {
                                this.cleanMessageOrderingMap();
                                if (!inputStream.isClosed()) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException e) {
                                InternalErrorHandler.handleException(e);
                            }
                            return;
                        }
                    }
                    inputBuffer.append(line1);
                    this.rawInputStream.startTimer();
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Reading Input stream.");
                    }
                    try {
                        do {
                            line2 = this.readLine(inputStream);
                            inputBuffer.append(line2);
                        } while (!line2.trim().equals(""));
                    }
                    catch (IOException ex) {
                        if (postParseExecutor != null && this.isRunning) {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("waiting for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                            concurrentHashMap = this.messagesOrderingMap;
                            synchronized (concurrentHashMap) {
                                try {
                                    this.messagesOrderingMap.wait();
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("got notified for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                        }
                        this.rawInputStream.stopTimer();
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("thread ending for threadname " + this.mythread.getName());
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logStackTrace(32);
                        }
                        Object var16_28 = null;
                        try {
                            this.cleanMessageOrderingMap();
                            if (!inputStream.isClosed()) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e) {
                            InternalErrorHandler.handleException(e);
                        }
                        return;
                    }
                    this.rawInputStream.stopTimer();
                    inputBuffer.append(line2);
                    sipMessage = null;
                    try {
                        if (stackLogger.isLoggingEnabled(32)) {
                            stackLogger.logDebug("About to parse : " + inputBuffer.toString());
                        }
                        if ((sipMessage = this.smp.parseSIPMessage(inputBuffer.toString().getBytes(), false, false, this.sipMessageListener)) == null) {
                            this.rawInputStream.stopTimer();
                        }
                        break block71;
                    }
                    catch (ParseException ex) {
                        stackLogger.logError("Detected a parse error", ex);
                    }
                    continue;
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Completed parsing message");
                }
                ContentLength cl = (ContentLength)sipMessage.getContentLength();
                int contentLength = 0;
                contentLength = cl != null ? cl.getContentLength() : 0;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Content length = " + contentLength);
                }
                if (contentLength == 0) {
                    sipMessage.removeContent();
                } else if (this.maxMessageSize == 0 || contentLength < this.sizeCounter) {
                    int readlength;
                    byte[] message_body = new byte[contentLength];
                    for (int nread = 0; nread < contentLength; nread += readlength) {
                        Object var14_26;
                        this.rawInputStream.startTimer();
                        try {
                            try {
                                readlength = inputStream.read(message_body, nread, contentLength - nread);
                                if (readlength > 0) {
                                } else {
                                    var14_26 = null;
                                    this.rawInputStream.stopTimer();
                                    break;
                                }
                                var14_26 = null;
                                this.rawInputStream.stopTimer();
                                continue;
                            }
                            catch (IOException ex) {
                                stackLogger.logError("Exception Reading Content", ex);
                                var14_26 = null;
                                this.rawInputStream.stopTimer();
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            var14_26 = null;
                            this.rawInputStream.stopTimer();
                            throw throwable;
                        }
                    }
                    sipMessage.setMessageContent(message_body);
                }
                if (this.sipMessageListener == null) continue;
                try {
                    CallIDOrderingStructure newCallIDOrderingStructure;
                    if (postParseExecutor == null) {
                        if (this.sipStack.sipEventInterceptor != null) {
                            this.sipStack.sipEventInterceptor.beforeMessage(sipMessage);
                        }
                        this.sipMessageListener.processMessage(sipMessage);
                        if (this.sipStack.sipEventInterceptor == null) continue;
                        this.sipStack.sipEventInterceptor.afterMessage(sipMessage);
                        continue;
                    }
                    String callId = sipMessage.getCallId().getCallId();
                    CallIDOrderingStructure orderingStructure = this.messagesOrderingMap.get(callId);
                    if (orderingStructure == null && (orderingStructure = this.messagesOrderingMap.putIfAbsent(callId, newCallIDOrderingStructure = new CallIDOrderingStructure())) == null) {
                        orderingStructure = newCallIDOrderingStructure;
                        if (stackLogger.isLoggingEnabled(32)) {
                            stackLogger.logDebug("new CallIDOrderingStructure added for message " + sipMessage);
                        }
                    }
                    CallIDOrderingStructure callIDOrderingStructure = orderingStructure;
                    callIDOrderingStructure.getMessagesForCallID().offer(sipMessage);
                    postParseExecutor.execute(new Dispatch(callIDOrderingStructure, callId));
                }
                catch (Exception ex) {
                    break;
                }
            }
            Object var16_29 = null;
        }
        catch (Throwable throwable) {
            Object var16_30 = null;
            try {
                this.cleanMessageOrderingMap();
                if (!inputStream.isClosed()) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                InternalErrorHandler.handleException(e);
            }
            throw throwable;
        }
        try {
            this.cleanMessageOrderingMap();
            if (!inputStream.isClosed()) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            InternalErrorHandler.handleException(e);
        }
    }

    public static void setPostParseExcutorSize(int threads, int queueTimeout) {
        if (postParseExecutor != null) {
            postParseExecutor.shutdownNow();
        }
        if (staticQueueAuditor != null) {
            try {
                staticQueueAuditor.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (threads <= 0) {
            postParseExecutor = null;
        } else {
            staticQueue = new LinkedBlockingQueue<Runnable>();
            postParseExecutor = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.SECONDS, staticQueue, new NamedThreadFactory());
            staticQueueAuditor = new BlockingQueueDispatchAuditor(staticQueue);
            staticQueueAuditor.setTimeout(queueTimeout);
            staticQueueAuditor.start(2000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block7: {
            this.isRunning = false;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing pipelinedmsgparser " + this + " threadname " + this.mythread.getName());
            }
            try {
                this.rawInputStream.close();
            }
            catch (IOException ex) {
                if (!logger.isLoggingEnabled(32)) break block7;
                logger.logDebug("Couldn't close the rawInputStream " + this + " threadname " + this.mythread.getName() + " already closed ? " + this.rawInputStream.isClosed());
            }
        }
        if (postParseExecutor != null) {
            this.cleanMessageOrderingMap();
            Thread thread = this.mythread;
            synchronized (thread) {
                this.mythread.notifyAll();
                this.mythread.interrupt();
            }
        }
    }

    public static void shutdownTcpThreadpool() {
        if (postParseExecutor != null) {
            postParseExecutor.shutdown();
            postParseExecutor = null;
        }
        if (staticQueueAuditor != null) {
            try {
                staticQueueAuditor.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanMessageOrderingMap() {
        for (CallIDOrderingStructure callIDOrderingStructure : this.messagesOrderingMap.values()) {
            callIDOrderingStructure.getSemaphore().release();
            callIDOrderingStructure.getMessagesForCallID().clear();
        }
        this.messagesOrderingMap.clear();
        ConcurrentHashMap<String, CallIDOrderingStructure> concurrentHashMap = this.messagesOrderingMap;
        synchronized (concurrentHashMap) {
            this.messagesOrderingMap.notifyAll();
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("cleaned the messagesOrderingMap " + this + " threadname " + this.mythread.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CallIDOrderingStructure {
        private Semaphore semaphore = new Semaphore(1, true);
        private Queue<SIPMessage> messagesForCallID = new ConcurrentLinkedQueue<SIPMessage>();

        public Semaphore getSemaphore() {
            return this.semaphore;
        }

        public Queue<SIPMessage> getMessagesForCallID() {
            return this.messagesForCallID;
        }
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        static long threadNumber = 0L;

        public Thread newThread(Runnable arg0) {
            Thread thread = new Thread(arg0);
            thread.setName("SIP-TCP-Core-PipelineThreadpool-" + threadNumber++ % 999999999L);
            return thread;
        }
    }

    public class Dispatch
    implements Runnable,
    QueuedMessageDispatchBase {
        CallIDOrderingStructure callIDOrderingStructure;
        String callId;
        long time;

        public Dispatch(CallIDOrderingStructure callIDOrderingStructure, String callId) {
            this.callIDOrderingStructure = callIDOrderingStructure;
            this.callId = callId;
            this.time = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            SIPMessage message;
            block28: {
                Semaphore semaphore = this.callIDOrderingStructure.getSemaphore();
                Queue<SIPMessage> messagesForCallID = this.callIDOrderingStructure.getMessagesForCallID();
                if (((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor != null) {
                    ((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor.beforeMessage(messagesForCallID.peek());
                }
                try {
                    semaphore.acquire();
                }
                catch (InterruptedException e) {
                    logger.logError("Semaphore acquisition for callId " + this.callId + " interrupted", e);
                }
                message = messagesForCallID.poll();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("semaphore acquired for message " + message);
                }
                try {
                    try {
                        PipelinedMsgParser.this.sipMessageListener.processMessage(message);
                    }
                    catch (Exception e) {
                        logger.logError("Error occured processing message", e);
                        Object var6_6 = null;
                        if (this.callIDOrderingStructure.getMessagesForCallID().size() <= 0) {
                            PipelinedMsgParser.this.messagesOrderingMap.remove(this.callId);
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("CallIDOrderingStructure removed for message " + this.callId);
                            }
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("releasing semaphore for message " + message);
                        }
                        semaphore.release();
                        if (PipelinedMsgParser.this.messagesOrderingMap.isEmpty()) {
                            ConcurrentHashMap concurrentHashMap = PipelinedMsgParser.this.messagesOrderingMap;
                            synchronized (concurrentHashMap) {
                                PipelinedMsgParser.this.messagesOrderingMap.notify();
                            }
                        }
                        if (((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor != null) {
                            ((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor.afterMessage(message);
                        }
                        break block28;
                    }
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (this.callIDOrderingStructure.getMessagesForCallID().size() <= 0) {
                        PipelinedMsgParser.this.messagesOrderingMap.remove(this.callId);
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("CallIDOrderingStructure removed for message " + this.callId);
                        }
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("releasing semaphore for message " + message);
                    }
                    semaphore.release();
                    if (PipelinedMsgParser.this.messagesOrderingMap.isEmpty()) {
                        ConcurrentHashMap concurrentHashMap = PipelinedMsgParser.this.messagesOrderingMap;
                        synchronized (concurrentHashMap) {
                            PipelinedMsgParser.this.messagesOrderingMap.notify();
                        }
                    }
                    if (((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor != null) {
                        ((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor.afterMessage(message);
                    }
                    throw throwable;
                }
                if (this.callIDOrderingStructure.getMessagesForCallID().size() <= 0) {
                    PipelinedMsgParser.this.messagesOrderingMap.remove(this.callId);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("CallIDOrderingStructure removed for message " + this.callId);
                    }
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("releasing semaphore for message " + message);
                }
                semaphore.release();
                if (PipelinedMsgParser.this.messagesOrderingMap.isEmpty()) {
                    ConcurrentHashMap concurrentHashMap = PipelinedMsgParser.this.messagesOrderingMap;
                    synchronized (concurrentHashMap) {
                        PipelinedMsgParser.this.messagesOrderingMap.notify();
                    }
                }
                if (((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor != null) {
                    ((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor.afterMessage(message);
                }
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("dispatch task done on " + message + " threadname " + PipelinedMsgParser.this.mythread.getName());
            }
        }

        public long getReceptionTime() {
            return this.time;
        }
    }
}

