/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.NameValueList;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.ClientTransactionExt;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.Expires;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import java.io.IOException;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.message.Request;

public class SIPClientTransaction
extends SIPTransaction
implements ServerResponseInterface,
ClientTransaction,
ClientTransactionExt {
    private static StackLogger logger = CommonLogger.getLogger(SIPClientTransaction.class);
    private Set<String> sipDialogs;
    private SIPRequest lastRequest;
    private int viaPort;
    private String viaHost;
    private transient ServerResponseInterface respondTo;
    private String defaultDialogId;
    private SIPDialog defaultDialog;
    private Hop nextHop;
    private boolean notifyOnRetransmit;
    private boolean timeoutIfStillInCallingState;
    private int callingStateTimeoutCount;
    private SIPStackTimerTask transactionTimer;
    private String originalRequestFromTag;
    private String originalRequestCallId;
    private Event originalRequestEventHeader;
    private Contact originalRequestContact;
    private String originalRequestScheme;
    private Object transactionTimerLock = new Object();
    private AtomicBoolean timerKStarted = new AtomicBoolean(false);
    private boolean transactionTimerCancelled = false;
    private Set<Integer> responsesReceived = new HashSet<Integer>(2);

    protected SIPClientTransaction(SIPTransactionStack newSIPStack, MessageChannel newChannelToUse) {
        super(newSIPStack, newChannelToUse);
        this.setBranch(Utils.getInstance().generateBranchId());
        this.messageProcessor = newChannelToUse.messageProcessor;
        this.setEncapsulatedChannel(newChannelToUse);
        this.notifyOnRetransmit = false;
        this.timeoutIfStillInCallingState = false;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Creating clientTransaction " + this);
            logger.logStackTrace();
        }
        this.sipDialogs = new CopyOnWriteArraySet<String>();
    }

    public void setResponseInterface(ServerResponseInterface newRespondTo) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Setting response interface for " + this + " to " + newRespondTo);
            if (newRespondTo == null) {
                logger.logStackTrace();
                logger.logDebug("WARNING -- setting to null!");
            }
        }
        this.respondTo = newRespondTo;
    }

    public MessageChannel getRequestChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage messageToTest) {
        Via topMostViaHeader = messageToTest.getTopmostVia();
        String messageBranch = topMostViaHeader.getBranch();
        boolean rfc3261Compliant = this.getBranch() != null && messageBranch != null && this.getBranch().toLowerCase().startsWith("z9hg4bk") && messageBranch.toLowerCase().startsWith("z9hg4bk");
        boolean transactionMatches = false;
        if (3 == this.getInternalState()) {
            transactionMatches = rfc3261Compliant ? this.getBranch().equalsIgnoreCase(topMostViaHeader.getBranch()) && this.getMethod().equals(messageToTest.getCSeq().getMethod()) : this.getBranch().equals(messageToTest.getTransactionId());
        } else if (!this.isTerminated()) {
            if (rfc3261Compliant) {
                if (topMostViaHeader != null && this.getBranch().equalsIgnoreCase(topMostViaHeader.getBranch())) {
                    transactionMatches = this.getMethod().equals(messageToTest.getCSeq().getMethod());
                }
            } else {
                transactionMatches = this.getBranch() != null ? this.getBranch().equalsIgnoreCase(messageToTest.getTransactionId()) : ((SIPRequest)this.getRequest()).getTransactionId().equalsIgnoreCase(messageToTest.getTransactionId());
            }
        }
        return transactionMatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(SIPMessage messageToSend) throws IOException {
        try {
            SIPRequest transactionRequest = (SIPRequest)messageToSend;
            Via topVia = transactionRequest.getTopmostVia();
            try {
                topVia.setBranch(this.getBranch());
            }
            catch (ParseException ex) {
                // empty catch block
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Sending Message " + messageToSend);
                logger.logDebug("TransactionState " + this.getState());
            }
            if ((2 == this.getInternalState() || 0 == this.getInternalState()) && transactionRequest.getMethod().equals("ACK")) {
                if (this.isReliable()) {
                    this.setState(5);
                } else {
                    this.setState(3);
                }
                this.cleanUpOnTimer();
                super.sendMessage(transactionRequest);
                Object var6_6 = null;
                this.isMapped = true;
                this.startTransactionTimer();
                return;
            }
            try {
                this.lastRequest = transactionRequest;
                if (this.getInternalState() < 0) {
                    this.setOriginalRequest(transactionRequest);
                    if (transactionRequest.getMethod().equals("INVITE")) {
                        this.setState(0);
                    } else if (transactionRequest.getMethod().equals("ACK")) {
                        this.setState(5);
                        this.cleanUpOnTimer();
                    } else {
                        this.setState(1);
                    }
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    if (this.isInviteTransaction()) {
                        this.enableTimeoutTimer(64);
                    } else {
                        this.enableTimeoutTimer(64);
                    }
                }
                super.sendMessage(transactionRequest);
            }
            catch (IOException e) {
                this.setState(5);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.isMapped = true;
            this.startTransactionTimer();
            throw throwable;
        }
        Object var6_7 = null;
        this.isMapped = true;
        this.startTransactionTimer();
    }

    public synchronized void processResponse(SIPResponse transactionResponse, MessageChannel sourceChannel, SIPDialog dialog) {
        if (this.getInternalState() < 0) {
            return;
        }
        if ((3 == this.getInternalState() || 5 == this.getInternalState()) && transactionResponse.getStatusCode() / 100 == 1) {
            return;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("processing " + transactionResponse.getFirstLine() + "current state = " + this.getState());
            logger.logDebug("dialog = " + dialog);
        }
        this.lastResponse = transactionResponse;
        try {
            if (this.isInviteTransaction()) {
                this.inviteClientTransaction(transactionResponse, sourceChannel, dialog);
            } else {
                this.nonInviteClientTransaction(transactionResponse, sourceChannel, dialog);
            }
        }
        catch (IOException ex) {
            if (logger.isLoggingEnabled()) {
                logger.logException(ex);
            }
            this.setState(5);
            this.raiseErrorEvent(2);
        }
    }

    private void nonInviteClientTransaction(SIPResponse transactionResponse, MessageChannel sourceChannel, SIPDialog sipDialog) throws IOException {
        int statusCode = transactionResponse.getStatusCode();
        if (1 == this.getInternalState()) {
            if (statusCode / 100 == 1) {
                this.setState(2);
                this.enableRetransmissionTimer(8);
                this.enableTimeoutTimer(64);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semRelease();
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                if (!this.isReliable()) {
                    this.setState(3);
                    this.scheduleTimerK(this.TIMER_K);
                } else {
                    this.setState(5);
                }
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semRelease();
                }
                if (this.isReliable() && 5 == this.getInternalState()) {
                    this.cleanUpOnTerminated();
                }
                this.cleanUpOnTimer();
            }
        } else if (2 == this.getInternalState()) {
            if (statusCode / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semRelease();
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                if (!this.isReliable()) {
                    this.setState(3);
                    this.scheduleTimerK(this.TIMER_K);
                } else {
                    this.setState(5);
                }
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semRelease();
                }
                if (this.isReliable() && 5 == this.getInternalState()) {
                    this.cleanUpOnTerminated();
                }
                this.cleanUpOnTimer();
            }
        } else {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(" Not sending response to TU! " + this.getState());
            }
            this.semRelease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTimerK(long time) {
        if (this.transactionTimer != null && this.timerKStarted.compareAndSet(false, true)) {
            Object object = this.transactionTimerLock;
            synchronized (object) {
                if (!this.transactionTimerCancelled) {
                    this.sipStack.getTimer().cancel(this.transactionTimer);
                    this.transactionTimer = null;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("starting TransactionTimerK() : " + this.getTransactionId() + " time " + time);
                    }
                    SIPStackTimerTask task = new SIPStackTimerTask(){

                        public void runTask() {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("executing TransactionTimerJ() : " + SIPClientTransaction.this.getTransactionId());
                            }
                            SIPClientTransaction.this.fireTimeoutTimer();
                            SIPClientTransaction.this.cleanUpOnTerminated();
                        }
                    };
                    if (time > 0L) {
                        this.sipStack.getTimer().schedule(task, time * (long)this.BASE_TIMER_INTERVAL);
                    } else {
                        task.runTask();
                    }
                    this.transactionTimerCancelled = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void inviteClientTransaction(SIPResponse transactionResponse, MessageChannel sourceChannel, SIPDialog dialog) throws IOException {
        int statusCode = transactionResponse.getStatusCode();
        if (5 == this.getInternalState()) {
            boolean ackAlreadySent = false;
            if (dialog != null && dialog.isAckSent(transactionResponse.getCSeq().getSeqNumber()) && dialog.getLastAckSent().getCSeq().getSeqNumber() == transactionResponse.getCSeq().getSeqNumber() && transactionResponse.getFromTag().equals(dialog.getLastAckSent().getFromTag())) {
                ackAlreadySent = true;
            }
            if (dialog != null && ackAlreadySent && transactionResponse.getCSeq().getMethod().equals(dialog.getMethod())) {
                try {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("resending ACK");
                    }
                    dialog.resendAck();
                }
                catch (SipException ex) {
                    // empty catch block
                }
            }
            this.semRelease();
            return;
        }
        if (0 == this.getInternalState()) {
            if (statusCode / 100 == 2) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(5);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                    return;
                }
                this.semRelease();
                return;
            }
            if (statusCode / 100 == 1) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(2);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                    return;
                }
                this.semRelease();
                return;
            }
            if (300 > statusCode) return;
            if (statusCode > 699) return;
            try {
                this.sendMessage((SIPRequest)this.createErrorAck());
            }
            catch (Exception ex) {
                logger.logError("Unexpected Exception sending ACK -- sending error AcK ", ex);
            }
            if (this.getDialog() != null && ((SIPDialog)this.getDialog()).isBackToBackUserAgent()) {
                ((SIPDialog)this.getDialog()).releaseAckSem();
            }
            if (!this.isReliable()) {
                this.setState(3);
                this.enableTimeoutTimer(this.TIMER_D);
            } else {
                this.setState(5);
            }
            if (this.respondTo != null) {
                this.respondTo.processResponse(transactionResponse, this, dialog);
            } else {
                this.semRelease();
            }
            this.cleanUpOnTimer();
            return;
        }
        if (2 == this.getInternalState()) {
            if (statusCode / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                    return;
                }
                this.semRelease();
                return;
            }
            if (statusCode / 100 == 2) {
                this.setState(5);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                    return;
                }
                this.semRelease();
                return;
            }
            if (300 > statusCode) return;
            if (statusCode > 699) return;
            try {
                this.sendMessage((SIPRequest)this.createErrorAck());
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
            }
            if (this.getDialog() != null) {
                ((SIPDialog)this.getDialog()).releaseAckSem();
            }
            if (!this.isReliable()) {
                this.setState(3);
                this.enableTimeoutTimer(this.TIMER_D);
            } else {
                this.setState(5);
            }
            this.cleanUpOnTimer();
            if (this.respondTo != null) {
                this.respondTo.processResponse(transactionResponse, this, dialog);
                return;
            }
            this.semRelease();
            return;
        }
        if (3 != this.getInternalState()) return;
        if (300 > statusCode) return;
        if (statusCode > 699) return;
        try {
            try {
                this.sendMessage((SIPRequest)this.createErrorAck());
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
                Object var8_11 = null;
                this.semRelease();
                return;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.semRelease();
            throw throwable;
        }
        this.semRelease();
    }

    public void sendRequest() throws SipException {
        SIPRequest sipRequest = this.getOriginalRequest();
        if (this.getInternalState() >= 0) {
            throw new SipException("Request already sent");
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendRequest() " + sipRequest);
        }
        try {
            sipRequest.checkHeaders();
        }
        catch (ParseException ex) {
            if (logger.isLoggingEnabled()) {
                logger.logError("missing required header");
            }
            throw new SipException(ex.getMessage());
        }
        if (this.getMethod().equals("SUBSCRIBE") && sipRequest.getHeader("Expires") == null && logger.isLoggingEnabled()) {
            logger.logWarning("Expires header missing in outgoing subscribe -- Notifier will assume implied value on event package");
        }
        try {
            SIPDialog dialog;
            if (this.getMethod().equals("CANCEL") && this.sipStack.isCancelClientTransactionChecked()) {
                SIPClientTransaction ct = (SIPClientTransaction)this.sipStack.findCancelTransaction(this.getOriginalRequest(), false);
                if (ct == null) {
                    throw new SipException("Could not find original tx to cancel. RFC 3261 9.1");
                }
                if (ct.getInternalState() < 0) {
                    throw new SipException("State is null no provisional response yet -- cannot cancel RFC 3261 9.1");
                }
                if (!ct.isInviteTransaction()) {
                    throw new SipException("Cannot cancel non-invite requests RFC 3261 9.1");
                }
            } else if (this.getMethod().equals("BYE") || this.getMethod().equals("NOTIFY")) {
                dialog = this.sipStack.getDialog(this.getOriginalRequest().getDialogId(false));
                if (this.getSipProvider().isAutomaticDialogSupportEnabled() && dialog != null) {
                    throw new SipException("Dialog is present and AutomaticDialogSupport is enabled for  the provider -- Send the Request using the Dialog.sendRequest(transaction)");
                }
            }
            if (this.isInviteTransaction() && (dialog = this.getDefaultDialog()) != null && dialog.isBackToBackUserAgent() && !dialog.takeAckSem()) {
                throw new SipException("Failed to take ACK semaphore");
            }
            this.isMapped = true;
            int expiresTime = -1;
            if (sipRequest.getHeader("Expires") != null) {
                Expires expires = (Expires)sipRequest.getHeader("Expires");
                expiresTime = expires.getExpires();
            }
            if (this.getDefaultDialog() != null && this.isInviteTransaction() && expiresTime != -1 && this.expiresTimerTask == null) {
                this.expiresTimerTask = new ExpiresTimerTask();
                this.sipStack.getTimer().schedule(this.expiresTimerTask, expiresTime * 1000);
            }
            this.sendMessage(sipRequest);
        }
        catch (IOException ex) {
            this.setState(5);
            if (this.expiresTimerTask != null) {
                this.sipStack.getTimer().cancel(this.expiresTimerTask);
            }
            throw new SipException(ex.getMessage() == null ? "IO Error sending request" : ex.getMessage(), (Throwable)ex);
        }
    }

    protected void fireRetransmissionTimer() {
        block9: {
            try {
                if (this.getInternalState() < 0 || !this.isMapped) {
                    return;
                }
                boolean inv = this.isInviteTransaction();
                int s = this.getInternalState();
                if ((!inv || 0 != s) && (inv || 1 != s && 2 != s) || this.lastRequest == null) break block9;
                if (this.sipStack.generateTimeStampHeader && this.lastRequest.getHeader("Timestamp") != null) {
                    long milisec = System.currentTimeMillis();
                    TimeStamp timeStamp = new TimeStamp();
                    try {
                        timeStamp.setTimeStamp(milisec);
                    }
                    catch (InvalidArgumentException ex) {
                        InternalErrorHandler.handleException((Exception)((Object)ex));
                    }
                    this.lastRequest.setHeader(timeStamp);
                }
                super.sendMessage(this.lastRequest);
                if (this.notifyOnRetransmit) {
                    TimeoutEvent txTimeout = new TimeoutEvent((Object)this.getSipProvider(), (ClientTransaction)this, Timeout.RETRANSMIT);
                    this.getSipProvider().handleEvent((EventObject)txTimeout, this);
                }
                if (this.timeoutIfStillInCallingState && this.getInternalState() == 0) {
                    --this.callingStateTimeoutCount;
                    if (this.callingStateTimeoutCount == 0) {
                        TimeoutEvent timeoutEvent = new TimeoutEvent((Object)this.getSipProvider(), (ClientTransaction)this, Timeout.RETRANSMIT);
                        this.getSipProvider().handleEvent((EventObject)timeoutEvent, this);
                        this.timeoutIfStillInCallingState = false;
                    }
                }
            }
            catch (IOException e) {
                this.raiseIOExceptionEvent();
                this.raiseErrorEvent(2);
            }
        }
    }

    protected void fireTimeoutTimer() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("fireTimeoutTimer " + this);
        }
        SIPDialog dialog = (SIPDialog)this.getDialog();
        if (0 == this.getInternalState() || 1 == this.getInternalState() || 2 == this.getInternalState()) {
            if (dialog != null && (dialog.getState() == null || dialog.getState() == DialogState.EARLY)) {
                if (SIPTransactionStack.isDialogCreated(this.getMethod())) {
                    dialog.delete();
                }
            } else if (dialog != null && this.getMethod().equalsIgnoreCase("BYE") && dialog.isTerminatedOnBye()) {
                dialog.delete();
            }
        }
        if (3 != this.getInternalState() && 5 != this.getInternalState()) {
            SIPClientTransaction inviteTx;
            this.raiseErrorEvent(1);
            if (this.getMethod().equalsIgnoreCase("CANCEL") && (inviteTx = (SIPClientTransaction)this.getOriginalRequest().getInviteTransaction()) != null && (inviteTx.getInternalState() == 0 || inviteTx.getInternalState() == 2) && inviteTx.getDialog() != null) {
                inviteTx.setState(5);
            }
        } else {
            this.setState(5);
        }
    }

    public Request createCancel() throws SipException {
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("Bad state " + this.getState());
        }
        if (!originalRequest.getMethod().equals("INVITE")) {
            throw new SipException("Only INIVTE may be cancelled");
        }
        if (originalRequest.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot Cancel ACK!");
        }
        SIPRequest cancelRequest = originalRequest.createCancelRequest();
        cancelRequest.setInviteTransaction(this);
        return cancelRequest;
    }

    public Request createAck() throws SipException {
        Route route;
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("bad state " + this.getState());
        }
        if (this.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot ACK an ACK!");
        }
        if (this.lastResponse == null) {
            throw new SipException("bad Transaction state");
        }
        if (this.lastResponse.getStatusCode() < 200) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("lastResponse = " + this.lastResponse);
            }
            throw new SipException("Cannot ACK a provisional response!");
        }
        SIPRequest ackRequest = originalRequest.createAckRequest((To)this.lastResponse.getTo());
        RecordRouteList recordRouteList = this.lastResponse.getRecordRouteHeaders();
        if (recordRouteList == null) {
            if (this.lastResponse.getContactHeaders() != null && this.lastResponse.getStatusCode() / 100 != 3) {
                Contact contact = (Contact)this.lastResponse.getContactHeaders().getFirst();
                URI uri = (URI)contact.getAddress().getURI().clone();
                ackRequest.setRequestURI(uri);
            }
            return ackRequest;
        }
        ackRequest.removeHeader("Route");
        RouteList routeList = new RouteList();
        ListIterator li = recordRouteList.listIterator(recordRouteList.size());
        while (li.hasPrevious()) {
            RecordRoute rr = (RecordRoute)li.previous();
            route = new Route();
            route.setAddress((AddressImpl)((AddressImpl)rr.getAddress()).clone());
            route.setParameters((NameValueList)rr.getParameters().clone());
            routeList.add(route);
        }
        Contact contact = null;
        if (this.lastResponse.getContactHeaders() != null) {
            contact = (Contact)this.lastResponse.getContactHeaders().getFirst();
        }
        if (!((SipURI)((Route)routeList.getFirst()).getAddress().getURI()).hasLrParam()) {
            route = null;
            if (contact != null) {
                route = new Route();
                route.setAddress((AddressImpl)((AddressImpl)contact.getAddress()).clone());
            }
            Route firstRoute = (Route)routeList.getFirst();
            routeList.removeFirst();
            URI uri = firstRoute.getAddress().getURI();
            ackRequest.setRequestURI(uri);
            if (route != null) {
                routeList.add(route);
            }
            ackRequest.addHeader(routeList);
        } else if (contact != null) {
            URI uri = (URI)contact.getAddress().getURI().clone();
            ackRequest.setRequestURI(uri);
            ackRequest.addHeader(routeList);
        }
        return ackRequest;
    }

    private final Request createErrorAck() throws SipException, ParseException {
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("bad state " + this.getState());
        }
        if (!this.isInviteTransaction()) {
            throw new SipException("Can only ACK an INVITE!");
        }
        if (this.lastResponse == null) {
            throw new SipException("bad Transaction state");
        }
        if (this.lastResponse.getStatusCode() < 200) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("lastResponse = " + this.lastResponse);
            }
            throw new SipException("Cannot ACK a provisional response!");
        }
        return originalRequest.createErrorAck((To)this.lastResponse.getTo());
    }

    public void setViaPort(int port) {
        this.viaPort = port;
    }

    public void setViaHost(String host) {
        this.viaHost = host;
    }

    public int getViaPort() {
        return this.viaPort;
    }

    public String getViaHost() {
        return this.viaHost;
    }

    public Via getOutgoingViaHeader() {
        return this.getMessageProcessor().getViaHeader();
    }

    public void clearState() {
    }

    public void setState(int newState) {
        if (newState == 5 && this.isReliable() && !this.getSIPStack().cacheClientConnections) {
            this.collectionTime = 64;
        }
        if (super.getInternalState() != 3 && (newState == 3 || newState == 5)) {
            this.sipStack.decrementActiveClientTransactionCount();
        }
        super.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTransactionTimer() {
        if (this.transactionTimerStarted.compareAndSet(false, true) && this.sipStack.getTimer() != null) {
            Object object = this.transactionTimerLock;
            synchronized (object) {
                if (!this.transactionTimerCancelled) {
                    this.transactionTimer = new TransactionTimer();
                    this.sipStack.getTimer().scheduleWithFixedDelay(this.transactionTimer, this.BASE_TIMER_INTERVAL, this.BASE_TIMER_INTERVAL);
                }
            }
        }
    }

    public void terminate() throws ObjectInUseException {
        this.setState(5);
    }

    public void stopExpiresTimer() {
        if (this.expiresTimerTask != null) {
            this.sipStack.getTimer().cancel(this.expiresTimerTask);
            this.expiresTimerTask = null;
        }
    }

    public boolean checkFromTag(SIPResponse sipResponse) {
        String originalFromTag = this.getOriginalRequestFromTag();
        if (this.defaultDialog != null) {
            if (originalFromTag == null ^ sipResponse.getFrom().getTag() == null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("From tag mismatch -- dropping response");
                }
                return false;
            }
            if (originalFromTag != null && !originalFromTag.equalsIgnoreCase(sipResponse.getFrom().getTag())) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("From tag mismatch -- dropping response");
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processResponse(SIPResponse sipResponse, MessageChannel incomingChannel) {
        boolean isRetransmission;
        int code = sipResponse.getStatusCode();
        boolean bl = isRetransmission = !this.responsesReceived.add(code);
        if (code == 183 && isRetransmission && this.lastResponse != null && !sipResponse.toString().equals(this.lastResponse.toString())) {
            isRetransmission = false;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("marking response as retransmission " + isRetransmission + " for ctx " + this);
        }
        sipResponse.setRetransmission(isRetransmission);
        SIPDialog dialog = null;
        String method = sipResponse.getCSeq().getMethod();
        String dialogId = sipResponse.getDialogId(false);
        if (method.equals("CANCEL") && this.lastRequest != null) {
            SIPClientTransaction ict = (SIPClientTransaction)this.lastRequest.getInviteTransaction();
            if (ict != null) {
                dialog = ict.defaultDialog;
            }
        } else {
            dialog = this.getDialog(dialogId);
        }
        if (dialog == null) {
            if (code > 100 && code < 300 && (sipResponse.getToTag() != null || this.sipStack.isRfc2543Supported()) && SIPTransactionStack.isDialogCreated(method)) {
                SIPClientTransaction sIPClientTransaction = this;
                synchronized (sIPClientTransaction) {
                    if (this.defaultDialog != null) {
                        if (sipResponse.getFromTag() == null) throw new RuntimeException("Response without from-tag");
                        String defaultDialogId = this.defaultDialog.getDialogId();
                        if (this.defaultDialog.getLastResponseMethod() == null || method.equals("SUBSCRIBE") && this.defaultDialog.getLastResponseMethod().equals("NOTIFY") && defaultDialogId.equals(dialogId)) {
                            this.defaultDialog.setLastResponse(this, sipResponse);
                            dialog = this.defaultDialog;
                        } else {
                            dialog = this.sipStack.getDialog(dialogId);
                            if (dialog == null && this.defaultDialog.isAssigned()) {
                                dialog = this.sipStack.createDialog(this, sipResponse);
                            }
                        }
                        if (dialog != null) {
                            this.setDialog(dialog, dialog.getDialogId());
                        } else {
                            logger.logError("dialog is unexpectedly null", new NullPointerException());
                        }
                    } else if (this.sipStack.isAutomaticDialogSupportEnabled) {
                        dialog = this.sipStack.createDialog(this, sipResponse);
                        this.setDialog(dialog, dialog.getDialogId());
                    }
                }
            } else {
                dialog = this.defaultDialog;
            }
        } else if (5 != this.getInternalState()) {
            dialog.setLastResponse(this, sipResponse);
        }
        this.processResponse(sipResponse, incomingChannel, dialog);
    }

    public Dialog getDialog() {
        SIPDialog retval = null;
        SIPResponse localLastResponse = this.lastResponse;
        if (localLastResponse != null && localLastResponse.getFromTag() != null && localLastResponse.getToTag() != null && localLastResponse.getStatusCode() != 100) {
            String dialogId = localLastResponse.getDialogId(false);
            retval = this.getDialog(dialogId);
        }
        if (retval == null) {
            retval = this.getDefaultDialog();
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(" sipDialogs =  " + this.sipDialogs + " default dialog " + this.getDefaultDialog() + " retval " + retval);
        }
        return retval;
    }

    public SIPDialog getDialog(String dialogId) {
        SIPDialog retval = null;
        if (this.sipDialogs != null && this.sipDialogs.contains(dialogId) && (retval = this.sipStack.getDialog(dialogId)) == null) {
            retval = this.sipStack.getEarlyDialog(dialogId);
        }
        return retval;
    }

    public void setDialog(SIPDialog sipDialog, String dialogId) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setDialog: " + dialogId + " sipDialog = " + sipDialog);
        }
        if (sipDialog == null) {
            if (logger.isLoggingEnabled(4)) {
                logger.logError("NULL DIALOG!!");
            }
            throw new NullPointerException("bad dialog null");
        }
        if (this.defaultDialog == null && this.defaultDialogId == null) {
            this.defaultDialog = sipDialog;
            if (this.isInviteTransaction() && this.getSIPStack().getMaxForkTime() != 0) {
                this.getSIPStack().addForkedClientTransaction(this);
            }
        }
        if (dialogId != null && sipDialog.getDialogId() != null && this.sipDialogs != null) {
            this.sipDialogs.add(dialogId);
        }
    }

    public SIPDialog getDefaultDialog() {
        SIPDialog dialog = this.defaultDialog;
        if (dialog == null && this.defaultDialogId != null) {
            dialog = this.sipStack.getDialog(this.defaultDialogId);
        }
        return dialog;
    }

    public void setNextHop(Hop hop) {
        this.nextHop = hop;
    }

    public Hop getNextHop() {
        return this.nextHop;
    }

    public void setNotifyOnRetransmit(boolean notifyOnRetransmit) {
        this.notifyOnRetransmit = notifyOnRetransmit;
    }

    public boolean isNotifyOnRetransmit() {
        return this.notifyOnRetransmit;
    }

    public void alertIfStillInCallingStateBy(int count) {
        this.timeoutIfStillInCallingState = true;
        this.callingStateTimeoutCount = count;
    }

    protected void cleanUpOnTimer() {
        if (this.isReleaseReferences()) {
            String dialogId;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("cleanupOnTimer: " + this.getTransactionId());
            }
            if (this.defaultDialog != null && (dialogId = this.defaultDialog.getDialogId()) != null && this.sipStack.getDialog(dialogId) != null) {
                this.defaultDialogId = dialogId;
                this.defaultDialog = null;
            }
            if (this.originalRequest != null) {
                this.originalRequest.setTransaction(null);
                this.originalRequest.setInviteTransaction(null);
                this.originalRequest.cleanUp();
                if (this.originalRequestBytes == null) {
                    this.originalRequestBytes = this.originalRequest.encodeAsBytes(this.getTransport());
                }
                if (!this.getMethod().equalsIgnoreCase("INVITE") && !this.getMethod().equalsIgnoreCase("CANCEL")) {
                    this.originalRequestFromTag = this.originalRequest.getFromTag();
                    this.originalRequestCallId = this.originalRequest.getCallId().getCallId();
                    this.originalRequestEventHeader = (Event)this.originalRequest.getHeader("Event");
                    this.originalRequestContact = this.originalRequest.getContactHeader();
                    this.originalRequestScheme = this.originalRequest.getRequestURI().getScheme();
                    this.originalRequest = null;
                }
            }
            if (!this.getMethod().equalsIgnoreCase("SUBSCRIBE")) {
                this.lastResponse = null;
            }
            this.lastRequest = null;
        }
    }

    public void cleanUp() {
        if (this.isReleaseReferences()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("cleanup : " + this.getTransactionId());
            }
            if (this.defaultDialog != null) {
                this.defaultDialogId = this.defaultDialog.getDialogId();
                this.defaultDialog = null;
            }
            if (this.originalRequest != null && this.originalRequestBytes == null) {
                this.originalRequestBytes = this.originalRequest.encodeAsBytes(this.getTransport());
            }
            this.originalRequest = null;
            this.cleanUpOnTimer();
            this.originalRequestCallId = null;
            this.originalRequestEventHeader = null;
            this.originalRequestFromTag = null;
            this.originalRequestContact = null;
            this.originalRequestScheme = null;
            if (this.sipDialogs != null) {
                this.sipDialogs.clear();
            }
            this.responsesReceived.clear();
            this.respondTo = null;
            this.transactionTimer = null;
            this.lastResponse = null;
            this.transactionTimerLock = null;
            this.timerKStarted = null;
        }
    }

    protected void cleanUpOnTerminated() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("removing  = " + this + " isReliable " + this.isReliable());
        }
        if (this.isReleaseReferences() && this.originalRequest == null && this.originalRequestBytes != null) {
            try {
                this.originalRequest = (SIPRequest)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.originalRequestBytes, true, false, null);
            }
            catch (ParseException e) {
                logger.logError("message " + this.originalRequestBytes + " could not be reparsed !");
            }
        }
        this.sipStack.removeTransaction(this);
        if (!this.sipStack.cacheClientConnections && this.isReliable()) {
            int newUseCount;
            if ((newUseCount = --this.getMessageChannel().useCount) <= 0) {
                SIPTransaction.LingerTimer myTimer = new SIPTransaction.LingerTimer();
                this.sipStack.getTimer().schedule(myTimer, 8000L);
            }
        } else {
            if (logger.isLoggingEnabled() && this.isReliable()) {
                int useCount = this.getMessageChannel().useCount;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Client Use Count = " + useCount);
                }
            }
            if (((SipStackImpl)this.getSIPStack()).isReEntrantListener() && this.isReleaseReferences()) {
                this.cleanUp();
            }
        }
    }

    public String getOriginalRequestFromTag() {
        if (this.originalRequest == null) {
            return this.originalRequestFromTag;
        }
        return this.originalRequest.getFromTag();
    }

    public String getOriginalRequestCallId() {
        if (this.originalRequest == null) {
            return this.originalRequestCallId;
        }
        return this.originalRequest.getCallId().getCallId();
    }

    public Event getOriginalRequestEvent() {
        if (this.originalRequest == null) {
            return this.originalRequestEventHeader;
        }
        return (Event)this.originalRequest.getHeader("Event");
    }

    public Contact getOriginalRequestContact() {
        if (this.originalRequest == null) {
            return this.originalRequestContact;
        }
        return this.originalRequest.getContactHeader();
    }

    public String getOriginalRequestScheme() {
        if (this.originalRequest == null) {
            return this.originalRequestScheme;
        }
        return this.originalRequest.getRequestURI().getScheme();
    }

    class ExpiresTimerTask
    extends SIPStackTimerTask {
        public void runTask() {
            SIPClientTransaction ct = SIPClientTransaction.this;
            SipProviderImpl provider = ct.getSipProvider();
            if (ct.getState() != TransactionState.TERMINATED) {
                TimeoutEvent tte = new TimeoutEvent((Object)SIPClientTransaction.this.getSipProvider(), (ClientTransaction)SIPClientTransaction.this, Timeout.TRANSACTION);
                provider.handleEvent((EventObject)tte, ct);
            } else {
                ExpiresTimerTask expiresTimerTask = this;
                if (logger.isLoggingEnabled(32)) {
                    ExpiresTimerTask expiresTimerTask2 = this;
                    logger.logDebug("state = " + ct.getState());
                }
            }
        }
    }

    public class TransactionTimer
    extends SIPStackTimerTask {
        public void runTask() {
            SIPClientTransaction clientTransaction = SIPClientTransaction.this;
            SIPTransactionStack sipStack = clientTransaction.sipStack;
            if (clientTransaction.isTerminated()) {
                block4: {
                    try {
                        sipStack.getTimer().cancel(this);
                    }
                    catch (IllegalStateException ex) {
                        if (sipStack.isAlive()) break block4;
                        return;
                    }
                }
                SIPClientTransaction.this.cleanUpOnTerminated();
            } else {
                clientTransaction.fireTimer();
            }
        }
    }
}

