/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import gov.nist.core.Debug;
import gov.nist.core.GenericObject;
import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.address.Authority;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipURIExt;
import gov.nist.javax.sip.address.TelephoneNumber;
import gov.nist.javax.sip.address.UriDecoder;
import gov.nist.javax.sip.address.UserInfo;
import java.text.ParseException;
import java.util.Iterator;
import javax.sip.PeerUnavailableException;
import javax.sip.SipFactory;
import javax.sip.address.SipURI;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipUri
extends GenericURI
implements SipURI,
SipURIExt {
    private static final long serialVersionUID = 7749781076218987044L;
    protected Authority authority;
    protected NameValueList uriParms;
    protected NameValueList qheaders;
    protected TelephoneNumber telephoneSubscriber;

    public SipUri() {
        this.scheme = "sip";
        this.uriParms = new NameValueList();
        this.qheaders = new NameValueList();
        this.qheaders.setSeparator("&");
    }

    public void setScheme(String scheme) {
        if (scheme.compareToIgnoreCase("sip") != 0 && scheme.compareToIgnoreCase("sips") != 0) {
            throw new IllegalArgumentException("bad scheme " + scheme);
        }
        this.scheme = scheme.toLowerCase();
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    public void clearUriParms() {
        this.uriParms = new NameValueList();
    }

    public void clearPassword() {
        UserInfo userInfo;
        if (this.authority != null && (userInfo = this.authority.getUserInfo()) != null) {
            userInfo.clearPassword();
        }
    }

    public Authority getAuthority() {
        return this.authority;
    }

    public void clearQheaders() {
        this.qheaders = new NameValueList();
    }

    @Override
    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that instanceof SipURI) {
            SipUri a = this;
            SipURI b = (SipURI)that;
            if (a.isSecure() ^ b.isSecure()) {
                return false;
            }
            if (a.getUser() == null ^ b.getUser() == null) {
                return false;
            }
            if (a.getUserPassword() == null ^ b.getUserPassword() == null) {
                return false;
            }
            if (a.getUser() != null && !UriDecoder.decode(a.getUser()).equals(UriDecoder.decode(b.getUser()))) {
                return false;
            }
            if (a.getUserPassword() != null && !UriDecoder.decode(a.getUserPassword()).equals(UriDecoder.decode(b.getUserPassword()))) {
                return false;
            }
            if (a.getHost() == null ^ b.getHost() == null) {
                return false;
            }
            if (a.getHost() != null && !a.getHost().equalsIgnoreCase(b.getHost())) {
                return false;
            }
            if (a.getPort() != b.getPort()) {
                return false;
            }
            Iterator i = a.getParameterNames();
            while (i.hasNext()) {
                String pname = (String)i.next();
                String p1 = a.getParameter(pname);
                String p2 = b.getParameter(pname);
                if (p1 == null || p2 == null || UriDecoder.decode(p1).equalsIgnoreCase(UriDecoder.decode(p2))) continue;
                return false;
            }
            if (a.getTransportParam() == null ^ b.getTransportParam() == null) {
                return false;
            }
            if (a.getUserParam() == null ^ b.getUserParam() == null) {
                return false;
            }
            if (a.getTTLParam() == -1 ^ b.getTTLParam() == -1) {
                return false;
            }
            if (a.getMethodParam() == null ^ b.getMethodParam() == null) {
                return false;
            }
            if (a.getMAddrParam() == null ^ b.getMAddrParam() == null) {
                return false;
            }
            if (a.getHeaderNames().hasNext() && !b.getHeaderNames().hasNext()) {
                return false;
            }
            if (!a.getHeaderNames().hasNext() && b.getHeaderNames().hasNext()) {
                return false;
            }
            if (a.getHeaderNames().hasNext() && b.getHeaderNames().hasNext()) {
                HeaderFactory headerFactory = null;
                try {
                    headerFactory = SipFactory.getInstance().createHeaderFactory();
                }
                catch (PeerUnavailableException e) {
                    Debug.logError("Cannot get the header factory to parse the header of the sip uris to compare", (Exception)((Object)e));
                    return false;
                }
                Iterator i2 = a.getHeaderNames();
                while (i2.hasNext()) {
                    String hname = (String)i2.next();
                    String h1 = a.getHeader(hname);
                    String h2 = b.getHeader(hname);
                    if (h1 == null && h2 != null) {
                        return false;
                    }
                    if (h2 == null && h1 != null) {
                        return false;
                    }
                    if (h1 == null && h2 == null) continue;
                    try {
                        Header header2;
                        Header header1 = headerFactory.createHeader(hname, UriDecoder.decode(h1));
                        if (header1.equals(header2 = headerFactory.createHeader(hname, UriDecoder.decode(h2)))) continue;
                        return false;
                    }
                    catch (ParseException e) {
                        Debug.logError("Cannot parse one of the header of the sip uris to compare " + a + " " + b, e);
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String encode() {
        return this.encode(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder encode(StringBuilder buffer) {
        buffer.append(this.scheme).append(":");
        if (this.authority != null) {
            this.authority.encode(buffer);
        }
        if (!this.uriParms.isEmpty()) {
            buffer.append(";");
            this.uriParms.encode(buffer);
        }
        if (!this.qheaders.isEmpty()) {
            buffer.append("?");
            this.qheaders.encode(buffer);
        }
        return buffer;
    }

    @Override
    public String toString() {
        return this.encode();
    }

    public String getUserAtHost() {
        String user = "";
        if (this.authority.getUserInfo() != null) {
            user = this.authority.getUserInfo().getUser();
        }
        String host = this.authority.getHost().encode();
        StringBuilder s = null;
        s = user.equals("") ? new StringBuilder() : new StringBuilder(user).append("@");
        return s.append(host).toString();
    }

    public String getUserAtHostPort() {
        String user = "";
        if (this.authority.getUserInfo() != null) {
            user = this.authority.getUserInfo().getUser();
        }
        String host = this.authority.getHost().encode();
        int port = this.authority.getPort();
        StringBuilder s = null;
        s = user.equals("") ? new StringBuilder() : new StringBuilder(user).append("@");
        if (port != -1) {
            return s.append(host).append(":").append(port).toString();
        }
        return s.append(host).toString();
    }

    public Object getParm(String parmname) {
        Object obj = this.uriParms.getValue(parmname);
        return obj;
    }

    public String getMethod() {
        return (String)this.getParm("method");
    }

    public NameValueList getParameters() {
        return this.uriParms;
    }

    public void removeParameters() {
        this.uriParms = new NameValueList();
    }

    public NameValueList getQheaders() {
        return this.qheaders;
    }

    public String getUserType() {
        return (String)this.uriParms.getValue("user");
    }

    public String getUserPassword() {
        if (this.authority == null) {
            return null;
        }
        return this.authority.getPassword();
    }

    public void setUserPassword(String password) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setPassword(password);
    }

    public TelephoneNumber getTelephoneSubscriber() {
        if (this.telephoneSubscriber == null) {
            this.telephoneSubscriber = new TelephoneNumber();
        }
        return this.telephoneSubscriber;
    }

    public HostPort getHostPort() {
        if (this.authority == null || this.authority.getHost() == null) {
            return null;
        }
        return this.authority.getHostPort();
    }

    public int getPort() {
        HostPort hp = this.getHostPort();
        if (hp == null) {
            return -1;
        }
        return hp.getPort();
    }

    public String getHost() {
        if (this.authority == null) {
            return null;
        }
        if (this.authority.getHost() == null) {
            return null;
        }
        return this.authority.getHost().encode();
    }

    public boolean isUserTelephoneSubscriber() {
        String usrtype = (String)this.uriParms.getValue("user");
        if (usrtype == null) {
            return false;
        }
        return usrtype.equalsIgnoreCase("phone");
    }

    public void removeTTL() {
        if (this.uriParms != null) {
            this.uriParms.delete("ttl");
        }
    }

    public void removeMAddr() {
        if (this.uriParms != null) {
            this.uriParms.delete("maddr");
        }
    }

    public void removeTransport() {
        if (this.uriParms != null) {
            this.uriParms.delete("transport");
        }
    }

    @Override
    public void removeHeader(String name) {
        if (this.qheaders != null) {
            this.qheaders.delete(name);
        }
    }

    @Override
    public void removeHeaders() {
        this.qheaders = new NameValueList();
    }

    public void removeUserType() {
        if (this.uriParms != null) {
            this.uriParms.delete("user");
        }
    }

    public void removePort() {
        this.authority.removePort();
    }

    public void removeMethod() {
        if (this.uriParms != null) {
            this.uriParms.delete("method");
        }
    }

    public void setUser(String uname) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setUser(uname);
    }

    public void removeUser() {
        this.authority.removeUserInfo();
    }

    public void setDefaultParm(String name, Object value) {
        if (this.uriParms.getValue(name) == null) {
            NameValue nv = new NameValue(name, value);
            this.uriParms.set(nv);
        }
    }

    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    public void setHost(Host h) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setHost(h);
    }

    public void setUriParms(NameValueList parms) {
        this.uriParms = parms;
    }

    public void setUriParm(String name, Object value) {
        NameValue nv = new NameValue(name, value);
        this.uriParms.set(nv);
    }

    public void setQheaders(NameValueList parms) {
        this.qheaders = parms;
    }

    public void setMAddr(String mAddr) {
        NameValue nameValue = this.uriParms.getNameValue("maddr");
        Host host = new Host();
        host.setAddress(mAddr);
        if (nameValue != null) {
            nameValue.setValueAsObject(host);
        } else {
            nameValue = new NameValue("maddr", host);
            this.uriParms.set(nameValue);
        }
    }

    public void setUserParam(String usertype) {
        this.uriParms.set("user", usertype);
    }

    public void setMethod(String method) {
        this.uriParms.set("method", method);
    }

    public void setIsdnSubAddress(String isdnSubAddress) {
        if (this.telephoneSubscriber == null) {
            this.telephoneSubscriber = new TelephoneNumber();
        }
        this.telephoneSubscriber.setIsdnSubaddress(isdnSubAddress);
    }

    public void setTelephoneSubscriber(TelephoneNumber tel) {
        this.telephoneSubscriber = tel;
    }

    public void setPort(int p) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setPort(p);
    }

    public boolean hasParameter(String name) {
        return this.uriParms.getValue(name) != null;
    }

    public void setQHeader(NameValue nameValue) {
        this.qheaders.set(nameValue);
    }

    public void setUriParameter(NameValue nameValue) {
        this.uriParms.set(nameValue);
    }

    public boolean hasTransport() {
        return this.hasParameter("transport");
    }

    public void removeParameter(String name) {
        this.uriParms.delete(name);
    }

    public void setHostPort(HostPort hostPort) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setHostPort(hostPort);
    }

    @Override
    public Object clone() {
        SipUri retval = (SipUri)super.clone();
        if (this.authority != null) {
            retval.authority = (Authority)this.authority.clone();
        }
        if (this.uriParms != null) {
            retval.uriParms = (NameValueList)this.uriParms.clone();
        }
        if (this.qheaders != null) {
            retval.qheaders = (NameValueList)this.qheaders.clone();
        }
        if (this.telephoneSubscriber != null) {
            retval.telephoneSubscriber = (TelephoneNumber)this.telephoneSubscriber.clone();
        }
        return retval;
    }

    public String getHeader(String name) {
        return this.qheaders.getValue(name) != null ? this.qheaders.getValue(name).toString() : null;
    }

    public Iterator<String> getHeaderNames() {
        return this.qheaders.getNames();
    }

    public String getLrParam() {
        boolean haslr = this.hasParameter("lr");
        return haslr ? "true" : null;
    }

    public String getMAddrParam() {
        NameValue maddr = this.uriParms.getNameValue("maddr");
        if (maddr == null) {
            return null;
        }
        String host = (String)maddr.getValueAsObject();
        return host;
    }

    public String getMethodParam() {
        return this.getParameter("method");
    }

    public String getParameter(String name) {
        Object val = this.uriParms.getValue(name);
        if (val == null) {
            return null;
        }
        if (val instanceof GenericObject) {
            return ((GenericObject)val).encode();
        }
        return val.toString();
    }

    public Iterator<String> getParameterNames() {
        return this.uriParms.getNames();
    }

    public int getTTLParam() {
        Integer ttl = (Integer)this.uriParms.getValue("ttl");
        if (ttl != null) {
            return ttl;
        }
        return -1;
    }

    public String getTransportParam() {
        if (this.uriParms != null) {
            return (String)this.uriParms.getValue("transport");
        }
        return null;
    }

    public String getUser() {
        return this.authority.getUser();
    }

    public boolean isSecure() {
        return this.getScheme().equalsIgnoreCase("sips");
    }

    @Override
    public boolean isSipURI() {
        return true;
    }

    public void setHeader(String name, String value) {
        NameValue nv = new NameValue(name, value);
        this.qheaders.set(nv);
    }

    public void setHost(String host) throws ParseException {
        Host h = new Host(host);
        this.setHost(h);
    }

    @Override
    public void setLrParam() {
        this.uriParms.set("lr", null);
    }

    public void setMAddrParam(String maddr) throws ParseException {
        if (maddr == null) {
            throw new NullPointerException("bad maddr");
        }
        this.setParameter("maddr", maddr);
    }

    public void setMethodParam(String method) throws ParseException {
        this.setParameter("method", method);
    }

    public void setParameter(String name, String value) throws ParseException {
        if (name.equalsIgnoreCase("ttl")) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new ParseException("bad parameter " + value, 0);
            }
        }
        this.uriParms.set(name, value);
    }

    public void setSecure(boolean secure) {
        this.scheme = secure ? "sips" : "sip";
    }

    public void setTTLParam(int ttl) {
        if (ttl <= 0) {
            throw new IllegalArgumentException("Bad ttl value");
        }
        if (this.uriParms != null) {
            NameValue nv = new NameValue("ttl", ttl);
            this.uriParms.set(nv);
        }
    }

    public void setTransportParam(String transport) throws ParseException {
        if (transport == null) {
            throw new NullPointerException("null arg");
        }
        if (transport.compareToIgnoreCase("UDP") != 0 && transport.compareToIgnoreCase("TLS") != 0 && transport.compareToIgnoreCase("TCP") != 0 && transport.compareToIgnoreCase("SCTP") != 0) {
            throw new ParseException("bad transport " + transport, 0);
        }
        NameValue nv = new NameValue("transport", transport.toLowerCase());
        this.uriParms.set(nv);
    }

    public String getUserParam() {
        return this.getParameter("user");
    }

    @Override
    public boolean hasLrParam() {
        return this.uriParms.getNameValue("lr") != null;
    }

    @Override
    public boolean hasGrParam() {
        return this.uriParms.getNameValue("gr") != null;
    }

    @Override
    public void setGrParam(String value) {
        this.uriParms.set("gr", value);
    }

    public String getGrParam() {
        return (String)this.uriParms.getValue("gr");
    }
}

