/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Random;

public class Utils {
    private static MessageDigest digester;
    private static Random rand;
    private static long counter;
    private static int callIDCounter;
    private static final char[] toHex;

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
        }
        return new String(c);
    }

    public static String getQuotedString(String str) {
        return '\"' + str + '\"';
    }

    protected static String reduceString(String input) {
        String newString = input.toLowerCase();
        int len = newString.length();
        String retval = "";
        for (int i = 0; i < len; ++i) {
            if (newString.charAt(i) == ' ' || newString.charAt(i) == '\t') continue;
            retval = retval + newString.charAt(i);
        }
        return retval;
    }

    public static synchronized String generateCallIdentifier(String address) {
        String date = new Long(System.currentTimeMillis() + (long)callIDCounter++ + rand.nextLong()).toString();
        byte[] cid = digester.digest(date.getBytes());
        String cidString = Utils.toHexString(cid);
        return cidString + "@" + address;
    }

    public static synchronized String generateTag() {
        return Integer.toHexString(rand.nextInt());
    }

    public static synchronized String generateBranchId() {
        long num = rand.nextLong() + counter++ + System.currentTimeMillis();
        byte[] bid = digester.digest(Long.toString(num).getBytes());
        return "z9hG4bK" + Utils.toHexString(bid);
    }

    public static void main(String[] args) {
        HashSet<String> branchIds = new HashSet<String>();
        for (int b = 0; b < 100000; ++b) {
            String bid = Utils.generateBranchId();
            if (branchIds.contains(bid)) {
                throw new RuntimeException("Duplicate Branch ID");
            }
            branchIds.add(bid);
        }
        System.out.println("Done!!");
    }

    static {
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not intialize Digester ", ex);
        }
        rand = new Random();
        counter = 0L;
        toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

