/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.ThreadAuditor;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.UDPMessageChannel;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class UDPMessageProcessor
extends MessageProcessor {
    private static final int HIGHWAT = 100;
    private static final int LOWAT = 50;
    private int port;
    protected LinkedList messageQueue;
    protected LinkedList messageChannels;
    protected int threadPoolSize;
    protected static final int MAX_DATAGRAM_SIZE = 8192;
    protected SIPTransactionStack sipStack;
    protected DatagramSocket sock;
    protected boolean isRunning;

    protected UDPMessageProcessor(InetAddress ipAddress, SIPTransactionStack sipStack, int port) throws IOException {
        super(ipAddress, port, "udp");
        this.sipStack = sipStack;
        this.messageQueue = new LinkedList();
        this.port = port;
        try {
            this.sock = sipStack.getNetworkLayer().createDatagramSocket(port, ipAddress);
            this.sock.setReceiveBufferSize(8192);
            if (sipStack.getThreadAuditor().isEnabled()) {
                this.sock.setSoTimeout((int)sipStack.getThreadAuditor().getPingIntervalInMillisecs());
            }
            if (ipAddress.getHostAddress().equals("0.0.0.0") || ipAddress.getHostAddress().equals("::0")) {
                super.setIpAddress(this.sock.getLocalAddress());
            }
        }
        catch (SocketException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws IOException {
        this.isRunning = true;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setName("UDPMessageProcessorThread");
        thread.setPriority(10);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.messageChannels = new LinkedList();
        if (this.sipStack.threadPoolSize != -1) {
            for (int i = 0; i < this.sipStack.threadPoolSize; ++i) {
                UDPMessageChannel channel = new UDPMessageChannel(this.sipStack, this);
                this.messageChannels.add(channel);
            }
        }
        ThreadAuditor.ThreadHandle threadHandle = this.sipStack.getThreadAuditor().addCurrentThread();
        while (this.isRunning) {
            try {
                threadHandle.ping();
                int bufsize = this.sock.getReceiveBufferSize();
                byte[] message = new byte[bufsize];
                DatagramPacket packet = new DatagramPacket(message, bufsize);
                this.sock.receive(packet);
                if (this.messageQueue.size() >= 100) {
                    if (!this.sipStack.logWriter.isLoggingEnabled()) continue;
                    this.sipStack.logWriter.logDebug("Dropping message -- queue length exceeded");
                    continue;
                }
                if (this.messageQueue.size() > 50 && this.messageQueue.size() < 100) {
                    boolean decision;
                    float threshold = (float)(this.messageQueue.size() - 50) / 50.0f;
                    boolean bl = decision = Math.random() > 1.0 - (double)threshold;
                    if (decision) {
                        if (!this.sipStack.logWriter.isLoggingEnabled()) continue;
                        this.sipStack.logWriter.logDebug("Dropping message with probability \t" + (1.0 - (double)threshold));
                        continue;
                    }
                }
                if (this.sipStack.threadPoolSize != -1) {
                    LinkedList linkedList = this.messageQueue;
                    synchronized (linkedList) {
                        this.messageQueue.addLast(packet);
                        this.messageQueue.notify();
                        continue;
                    }
                }
                new UDPMessageChannel(this.sipStack, this, packet);
            }
            catch (SocketTimeoutException ex) {
            }
            catch (SocketException ex) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.getSIPStack().logWriter.logDebug("UDPMessageProcessor: Stopping");
                }
                this.isRunning = false;
                LinkedList linkedList = this.messageQueue;
                synchronized (linkedList) {
                    this.messageQueue.notifyAll();
                }
            }
            catch (IOException ex) {
                this.isRunning = false;
                ex.printStackTrace();
                if (!this.sipStack.isLoggingEnabled()) continue;
                this.getSIPStack().logWriter.logDebug("UDPMessageProcessor: Got an IO Exception");
            }
            catch (Exception ex) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.getSIPStack().logWriter.logDebug("UDPMessageProcessor: Unexpected Exception - quitting");
                }
                InternalErrorHandler.handleException(ex);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LinkedList linkedList = this.messageQueue;
        synchronized (linkedList) {
            this.isRunning = false;
            this.messageQueue.notifyAll();
            this.sock.close();
        }
    }

    public String getTransport() {
        return "udp";
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public MessageChannel createMessageChannel(HostPort targetHostPort) throws UnknownHostException {
        return new UDPMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort(), this.sipStack, this);
    }

    public MessageChannel createMessageChannel(InetAddress host, int port) throws IOException {
        return new UDPMessageChannel(host, port, this.sipStack, this);
    }

    public int getDefaultTargetPort() {
        return 5060;
    }

    public boolean isSecure() {
        return false;
    }

    public int getMaximumMessageSize() {
        return 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inUse() {
        LinkedList linkedList = this.messageQueue;
        synchronized (linkedList) {
            return this.messageQueue.size() != 0;
        }
    }
}

