/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.NameValue;
import gov.nist.javax.sip.header.Authorization;
import gov.nist.javax.sip.header.Challenge;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.ProxyAuthorization;
import java.text.ParseException;
import javax.sip.address.URI;

public abstract class AuthenticationHeader
extends ParametersHeader {
    public static final String DOMAIN = "domain";
    public static final String REALM = "realm";
    public static final String OPAQUE = "opaque";
    public static final String ALGORITHM = "algorithm";
    public static final String QOP = "qop";
    public static final String STALE = "stale";
    public static final String SIGNATURE = "signature";
    public static final String RESPONSE = "response";
    public static final String SIGNED_BY = "signed-by";
    public static final String NC = "nc";
    public static final String URI = "uri";
    public static final String USERNAME = "username";
    public static final String CNONCE = "cnonce";
    public static final String NONCE = "nonce";
    public static final String IK = "ik";
    public static final String CK = "ck";
    public static final String INTEGRITY_PROTECTED = "integrity-protected";
    protected String scheme;

    public AuthenticationHeader(String name) {
        super(name);
        this.parameters.setSeparator(",");
        this.scheme = "Digest";
    }

    public AuthenticationHeader() {
        this.parameters.setSeparator(",");
    }

    public void setParameter(String name, String value) throws ParseException {
        NameValue nv = this.parameters.getNameValue(name.toLowerCase());
        if (nv == null) {
            nv = new NameValue(name, value);
            if (name.equalsIgnoreCase(QOP) || name.equalsIgnoreCase(REALM) || name.equalsIgnoreCase(CNONCE) || name.equalsIgnoreCase(NONCE) || name.equalsIgnoreCase(USERNAME) || name.equalsIgnoreCase(DOMAIN) || name.equalsIgnoreCase(OPAQUE) || name.equalsIgnoreCase("nextnonce") || name.equalsIgnoreCase(URI) || name.equalsIgnoreCase(RESPONSE) || name.equalsIgnoreCase(IK) || name.equalsIgnoreCase(CK) || name.equalsIgnoreCase(INTEGRITY_PROTECTED)) {
                if (!(this instanceof Authorization) && !(this instanceof ProxyAuthorization) || !name.equalsIgnoreCase(QOP)) {
                    nv.setQuotedValue();
                }
                if (value == null) {
                    throw new NullPointerException("null value");
                }
                if (value.startsWith("\"")) {
                    throw new ParseException(value + " : Unexpected DOUBLE_QUOTE", 0);
                }
            }
            super.setParameter(nv);
        } else {
            nv.setValueAsObject(value);
        }
    }

    public void setChallenge(Challenge challenge) {
        this.scheme = challenge.scheme;
        this.parameters = challenge.authParams;
    }

    public String encodeBody() {
        this.parameters.setSeparator(",");
        return this.scheme + " " + this.parameters.encode();
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setRealm(String realm) throws ParseException {
        if (realm == null) {
            throw new NullPointerException("JAIN-SIP Exception,  AuthenticationHeader, setRealm(), The realm parameter is null");
        }
        this.setParameter(REALM, realm);
    }

    public String getRealm() {
        return this.getParameter(REALM);
    }

    public void setNonce(String nonce) throws ParseException {
        if (nonce == null) {
            throw new NullPointerException("JAIN-SIP Exception,  AuthenticationHeader, setNonce(), The nonce parameter is null");
        }
        this.setParameter(NONCE, nonce);
    }

    public String getNonce() {
        return this.getParameter(NONCE);
    }

    public void setURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("Null URI");
        }
        NameValue nv = new NameValue(URI, uri);
        nv.setQuotedValue();
        this.parameters.set(nv);
    }

    public URI getURI() {
        return this.getParameterAsURI(URI);
    }

    public void setAlgorithm(String algorithm) throws ParseException {
        if (algorithm == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter(ALGORITHM, algorithm);
    }

    public String getAlgorithm() {
        return this.getParameter(ALGORITHM);
    }

    public void setQop(String qop) throws ParseException {
        if (qop == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter(QOP, qop);
    }

    public String getQop() {
        return this.getParameter(QOP);
    }

    public void setOpaque(String opaque) throws ParseException {
        if (opaque == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter(OPAQUE, opaque);
    }

    public String getOpaque() {
        return this.getParameter(OPAQUE);
    }

    public void setDomain(String domain) throws ParseException {
        if (domain == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter(DOMAIN, domain);
    }

    public String getDomain() {
        return this.getParameter(DOMAIN);
    }

    public void setStale(boolean stale) {
        this.setParameter(new NameValue(STALE, new Boolean(stale)));
    }

    public boolean isStale() {
        return this.getParameterAsBoolean(STALE);
    }

    public void setCNonce(String cnonce) throws ParseException {
        this.setParameter(CNONCE, cnonce);
    }

    public String getCNonce() {
        return this.getParameter(CNONCE);
    }

    public int getNonceCount() {
        return this.getParameterAsHexInt(NC);
    }

    public void setNonceCount(int param) throws ParseException {
        if (param < 0) {
            throw new ParseException("bad value", 0);
        }
        String nc = Integer.toHexString(param);
        String base = "00000000";
        nc = base.substring(0, 8 - nc.length()) + nc;
        this.setParameter(NC, nc);
    }

    public String getResponse() {
        return (String)this.getParameterValue(RESPONSE);
    }

    public void setResponse(String response) throws ParseException {
        if (response == null) {
            throw new NullPointerException("Null parameter");
        }
        this.setParameter(RESPONSE, response);
    }

    public String getUsername() {
        return this.getParameter(USERNAME);
    }

    public void setUsername(String username) throws ParseException {
        this.setParameter(USERNAME, username);
    }

    public void setIK(String ik) throws ParseException {
        if (ik == null) {
            throw new NullPointerException("JAIN-SIP Exception,  AuthenticationHeader, setIk(), The auth-param IK parameter is null");
        }
        this.setParameter(IK, ik);
    }

    public String getIK() {
        return this.getParameter(IK);
    }

    public void setCK(String ck) throws ParseException {
        if (ck == null) {
            throw new NullPointerException("JAIN-SIP Exception,  AuthenticationHeader, setCk(), The auth-param CK parameter is null");
        }
        this.setParameter(CK, ck);
    }

    public String getCK() {
        return this.getParameter(CK);
    }

    public void setIntegrityProtected(String integrityProtected) throws ParseException {
        if (integrityProtected == null) {
            throw new NullPointerException("JAIN-SIP Exception,  AuthenticationHeader, setIntegrityProtected(), The integrity-protected parameter is null");
        }
        this.setParameter(INTEGRITY_PROTECTED, integrityProtected);
    }

    public String getIntegrityProtected() {
        return this.getParameter(INTEGRITY_PROTECTED);
    }
}

