/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.ThreadAuditor;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.StringMsgParser;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.RawMessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import java.util.LinkedList;
import javax.sip.address.Hop;

public class UDPMessageChannel
extends MessageChannel
implements ParseExceptionListener,
Runnable,
RawMessageChannel {
    protected SIPTransactionStack sipStack;
    protected StringMsgParser myParser;
    private InetAddress peerAddress;
    private String myAddress;
    private int peerPacketSourcePort;
    private InetAddress peerPacketSourceAddress;
    private int peerPort;
    private String peerProtocol;
    protected int myPort;
    private DatagramPacket incomingPacket;
    private long receptionTime;

    protected UDPMessageChannel(SIPTransactionStack stack, UDPMessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
        this.sipStack = stack;
        Thread mythread = new Thread(this);
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        mythread.setName("UDPMessageChannelThread");
        mythread.setDaemon(true);
        mythread.start();
    }

    protected UDPMessageChannel(SIPTransactionStack stack, UDPMessageProcessor messageProcessor, DatagramPacket packet) {
        this.incomingPacket = packet;
        this.messageProcessor = messageProcessor;
        this.sipStack = stack;
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        Thread mythread = new Thread(this);
        mythread.setDaemon(true);
        mythread.start();
    }

    protected UDPMessageChannel(InetAddress targetAddr, int port, SIPTransactionStack sipStack, UDPMessageProcessor messageProcessor) {
        this.peerAddress = targetAddr;
        this.peerPort = port;
        this.peerProtocol = "UDP";
        this.messageProcessor = messageProcessor;
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        this.sipStack = sipStack;
        if (sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Creating message channel " + targetAddr.getHostAddress() + "/" + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ThreadAuditor.ThreadHandle threadHandle = null;
        do {
            DatagramPacket packet;
            if (this.myParser == null) {
                this.myParser = new StringMsgParser();
                this.myParser.setParseExceptionListener(this);
            }
            if (this.sipStack.threadPoolSize != -1) {
                LinkedList linkedList = ((UDPMessageProcessor)this.messageProcessor).messageQueue;
                synchronized (linkedList) {
                    while (((UDPMessageProcessor)this.messageProcessor).messageQueue.isEmpty()) {
                        if (!((UDPMessageProcessor)this.messageProcessor).isRunning) {
                            return;
                        }
                        try {
                            if (threadHandle == null) {
                                threadHandle = this.sipStack.getThreadAuditor().addCurrentThread();
                            }
                            threadHandle.ping();
                            ((UDPMessageProcessor)this.messageProcessor).messageQueue.wait(threadHandle.getPingIntervalInMillisecs());
                        }
                        catch (InterruptedException ex) {
                            if (((UDPMessageProcessor)this.messageProcessor).isRunning) continue;
                            return;
                        }
                    }
                    packet = (DatagramPacket)((UDPMessageProcessor)this.messageProcessor).messageQueue.removeFirst();
                }
                this.incomingPacket = packet;
            } else {
                packet = this.incomingPacket;
            }
            try {
                this.processIncomingDataPacket(packet);
            }
            catch (Exception e) {
                this.sipStack.logWriter.logError("Error while processing incoming UDP packet", e);
            }
        } while (this.sipStack.threadPoolSize != -1);
    }

    private void processIncomingDataPacket(DatagramPacket packet) throws Exception {
        this.peerAddress = packet.getAddress();
        int packetLength = packet.getLength();
        byte[] bytes = packet.getData();
        byte[] msgBytes = new byte[packetLength];
        System.arraycopy(bytes, 0, msgBytes, 0, packetLength);
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("UDPMessageChannel: processIncomingDataPacket : peerAddress = " + this.peerAddress.getHostAddress() + "/" + packet.getPort() + " Length = " + packetLength);
        }
        SIPMessage sipMessage = null;
        try {
            this.receptionTime = System.currentTimeMillis();
            sipMessage = this.myParser.parseSIPMessage(msgBytes);
            this.myParser = null;
        }
        catch (ParseException ex) {
            String msgString;
            this.myParser = null;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Rejecting message !  " + new String(msgBytes));
                this.sipStack.logWriter.logDebug("error message " + ex.getMessage());
                this.sipStack.logWriter.logException(ex);
            }
            if (!(msgString = new String(msgBytes, 0, packetLength)).startsWith("SIP/") && !msgString.startsWith("ACK ")) {
                String badReqRes = this.createBadReqRes(msgString, ex);
                if (badReqRes != null) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getLogWriter().logDebug("Sending automatic 400 Bad Request:");
                        this.sipStack.getLogWriter().logDebug(badReqRes);
                    }
                    try {
                        this.sendMessage(badReqRes.getBytes(), this.peerAddress, packet.getPort(), "UDP", false);
                    }
                    catch (IOException e) {
                        this.sipStack.logWriter.logException(e);
                    }
                } else if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getLogWriter().logDebug("Could not formulate automatic 400 Bad Request");
                }
            }
            return;
        }
        if (sipMessage == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Rejecting message !  + Null message parsed.");
            }
            return;
        }
        ViaList viaList = sipMessage.getViaHeaders();
        if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || sipMessage.getViaHeaders() == null) {
            String badmsg = new String(msgBytes);
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logError("bad message " + badmsg);
                this.sipStack.logWriter.logError(">>> Dropped Bad Msg From = " + sipMessage.getFrom() + "To = " + sipMessage.getTo() + "CallId = " + sipMessage.getCallId() + "CSeq = " + sipMessage.getCSeq() + "Via = " + sipMessage.getViaHeaders());
            }
            this.sipStack.logWriter.logError("BAD MESSAGE!");
            return;
        }
        if (sipMessage instanceof SIPRequest) {
            Via v = (Via)viaList.getFirst();
            Hop hop = this.sipStack.addressResolver.resolveAddress(v.getHop());
            this.peerPort = hop.getPort();
            this.peerProtocol = v.getTransport();
            this.peerPacketSourceAddress = packet.getAddress();
            this.peerPacketSourcePort = packet.getPort();
            try {
                this.peerAddress = packet.getAddress();
                boolean hasRPort = v.hasParameter("rport");
                if (hasRPort || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                    v.setParameter("received", this.peerAddress.getHostAddress());
                }
                if (hasRPort) {
                    v.setParameter("rport", Integer.toString(this.peerPacketSourcePort));
                }
            }
            catch (ParseException ex1) {
                InternalErrorHandler.handleException(ex1);
            }
        } else {
            this.peerPacketSourceAddress = packet.getAddress();
            this.peerPacketSourcePort = packet.getPort();
            this.peerAddress = packet.getAddress();
            this.peerPort = packet.getPort();
            this.peerProtocol = ((Via)viaList.getFirst()).getTransport();
        }
        this.processMessage(sipMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processMessage(SIPMessage sipMessage) {
        ServerResponseInterface sipServerResponse;
        block15: {
            block14: {
                if (sipMessage instanceof SIPRequest) {
                    SIPServerTransaction sipServerTx2;
                    ServerRequestInterface sipServerRequest;
                    SIPRequest sipRequest = (SIPRequest)sipMessage;
                    if (this.sipStack.logWriter.isLoggingEnabled(16)) {
                        this.sipStack.serverLog.logMessage(sipMessage, this.getPeerHostPort().toString(), this.getHost() + ":" + this.myPort, false, this.receptionTime);
                    }
                    if ((sipServerRequest = this.sipStack.newSIPServerRequest(sipRequest, this)) == null) {
                        if (!this.sipStack.isLoggingEnabled()) return;
                        this.sipStack.logWriter.logWarning("Null request interface returned -- dropping request");
                        return;
                    }
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.logWriter.logDebug("About to process " + sipRequest.getFirstLine() + "/" + sipServerRequest);
                    }
                    try {
                        sipServerRequest.processRequest(sipRequest, this);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        if (!(sipServerRequest instanceof SIPTransaction)) throw throwable;
                        SIPServerTransaction sipServerTx2 = (SIPServerTransaction)sipServerRequest;
                        if (sipServerTx2.passToListener()) throw throwable;
                        ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                        throw throwable;
                    }
                    if (sipServerRequest instanceof SIPTransaction && !(sipServerTx2 = (SIPServerTransaction)sipServerRequest).passToListener()) {
                        ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                    }
                    if (!this.sipStack.isLoggingEnabled()) return;
                    this.sipStack.logWriter.logDebug("Done processing " + sipRequest.getFirstLine() + "/" + sipServerRequest);
                    return;
                }
                SIPResponse sipResponse = (SIPResponse)sipMessage;
                try {
                    sipResponse.checkHeaders();
                }
                catch (ParseException ex) {
                    if (!this.sipStack.isLoggingEnabled()) return;
                    this.sipStack.logWriter.logError("Dropping Badly formatted response message >>> " + sipResponse);
                    return;
                }
                sipServerResponse = this.sipStack.newSIPServerResponse(sipResponse, this);
                if (sipServerResponse == null) {
                    if (!this.sipStack.isLoggingEnabled()) return;
                    this.sipStack.logWriter.logDebug("null sipServerResponse!");
                    return;
                }
                try {
                    if (sipServerResponse instanceof SIPClientTransaction && !((SIPClientTransaction)sipServerResponse).checkFromTag(sipResponse)) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logError("Dropping response message with invalid tag >>> " + sipResponse);
                        }
                        Object var8_12 = null;
                        break block14;
                    }
                    sipServerResponse.processResponse(sipResponse, this);
                    break block15;
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    if (!(sipServerResponse instanceof SIPTransaction)) throw throwable;
                    if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) throw throwable;
                    ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                    throw throwable;
                }
            }
            if (!(sipServerResponse instanceof SIPTransaction)) return;
            if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) return;
            ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
            return;
        }
        Object var8_13 = null;
        if (!(sipServerResponse instanceof SIPTransaction)) return;
        if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) return;
        ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
    }

    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            this.sipStack.logWriter.logError("BAD MESSAGE!");
            this.sipStack.logWriter.logError(message);
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMessage(SIPMessage sipMessage) throws IOException {
        long time;
        block9: {
            block8: {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logStackTrace();
                }
                time = System.currentTimeMillis();
                try {
                    try {
                        for (MessageProcessor messageProcessor : this.sipStack.getMessageProcessors()) {
                            MessageChannel messageChannel;
                            if (!messageProcessor.getIpAddress().equals(this.peerAddress) || messageProcessor.getPort() != this.peerPort || !messageProcessor.getTransport().equals(this.peerProtocol) || !((messageChannel = messageProcessor.createMessageChannel(this.peerAddress, this.peerPort)) instanceof RawMessageChannel)) continue;
                            ((RawMessageChannel)((Object)messageChannel)).processMessage(sipMessage);
                            this.sipStack.logWriter.logDebug("Self routing message");
                            Object var10_10 = null;
                            if (!this.sipStack.logWriter.isLoggingEnabled(16)) return;
                            break block8;
                        }
                        byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
                        this.sendMessage(msg, this.peerAddress, this.peerPort, this.peerProtocol, sipMessage instanceof SIPRequest);
                        break block9;
                    }
                    catch (IOException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        this.sipStack.logWriter.logError("An exception occured while sending message", ex);
                        throw new IOException("An exception occured while sending message");
                    }
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (!this.sipStack.logWriter.isLoggingEnabled(16)) throw throwable;
                    this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
                    throw throwable;
                }
            }
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
            return;
        }
        Object var10_11 = null;
        if (!this.sipStack.logWriter.isLoggingEnabled(16)) return;
        this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
    }

    protected void sendMessage(byte[] msg, InetAddress peerAddress, int peerPort, boolean reConnect) throws IOException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logStackTrace();
        }
        if (peerPort == -1) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug(this.getClass().getName() + ":sendMessage: Dropping reply!");
            }
            throw new IOException("Receiver port not set ");
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug(this.getClass().getName() + ":sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + new String(msg));
            this.sipStack.logWriter.logDebug("*******************\n");
        }
        DatagramPacket reply = new DatagramPacket(msg, msg.length, peerAddress, peerPort);
        try {
            DatagramSocket sock;
            boolean created = false;
            if (this.sipStack.udpFlag) {
                sock = ((UDPMessageProcessor)this.messageProcessor).sock;
            } else {
                sock = new DatagramSocket();
                created = true;
            }
            sock.send(reply);
            if (created) {
                sock.close();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendMessage(byte[] msg, InetAddress peerAddress, int peerPort, String peerProtocol, boolean retry) throws IOException {
        if (peerPort == -1) {
            if (!this.sipStack.isLoggingEnabled()) throw new IOException("Receiver port not set ");
            this.sipStack.logWriter.logDebug(this.getClass().getName() + ":sendMessage: Dropping reply!");
            throw new IOException("Receiver port not set ");
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug(this.getClass().getName() + ":sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + new String(msg));
            this.sipStack.logWriter.logDebug("*******************\n");
        }
        if (peerProtocol.compareToIgnoreCase("UDP") == 0) {
            DatagramPacket reply = new DatagramPacket(msg, msg.length, peerAddress, peerPort);
            try {
                DatagramSocket sock = this.sipStack.udpFlag ? ((UDPMessageProcessor)this.messageProcessor).sock : this.sipStack.getNetworkLayer().createDatagramSocket();
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + new String(msg));
                }
                sock.send(reply);
                if (this.sipStack.udpFlag) return;
                sock.close();
                return;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
                return;
            }
        } else {
            Socket outputSocket = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), peerAddress, peerPort, "tcp", msg, retry);
            OutputStream myOutputStream = outputSocket.getOutputStream();
            myOutputStream.write(msg, 0, msg.length);
            myOutputStream.flush();
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getTransport() {
        return "udp";
    }

    public String getHost() {
        return this.messageProcessor.getIpAddress().getHostAddress();
    }

    public int getPort() {
        return ((UDPMessageProcessor)this.messageProcessor).getPort();
    }

    public String getPeerName() {
        return this.peerAddress.getHostName();
    }

    public String getPeerAddress() {
        return this.peerAddress.getHostAddress();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public boolean equals(Object other) {
        boolean retval;
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            retval = false;
        } else {
            UDPMessageChannel that = (UDPMessageChannel)other;
            retval = this.getKey().equals(that.getKey());
        }
        return retval;
    }

    public String getKey() {
        return UDPMessageChannel.getKey(this.peerAddress, this.peerPort, "UDP");
    }

    public int getPeerPacketSourcePort() {
        return this.peerPacketSourcePort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerPacketSourceAddress;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public boolean isReliable() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    public void close() {
    }
}

