/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.facilities;

import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class AlarmLevel
implements Serializable {
    public static final int LEVEL_CLEAR = 0;
    public static final int LEVEL_INDETERMINATE = 1;
    public static final int LEVEL_CRITICAL = 2;
    public static final int LEVEL_MAJOR = 3;
    public static final int LEVEL_MINOR = 4;
    public static final int LEVEL_WARNING = 5;
    public static final AlarmLevel CLEAR = new AlarmLevel(0);
    public static final AlarmLevel INDETERMINATE = new AlarmLevel(1);
    public static final AlarmLevel CRITICAL = new AlarmLevel(2);
    public static final AlarmLevel MAJOR = new AlarmLevel(3);
    public static final AlarmLevel MINOR = new AlarmLevel(4);
    public static final AlarmLevel WARNING = new AlarmLevel(5);
    private final int level;

    public static AlarmLevel fromInt(int level) throws IllegalArgumentException {
        switch (level) {
            case 0: {
                return CLEAR;
            }
            case 1: {
                return INDETERMINATE;
            }
            case 2: {
                return CRITICAL;
            }
            case 3: {
                return MAJOR;
            }
            case 4: {
                return MINOR;
            }
            case 5: {
                return WARNING;
            }
        }
        throw new IllegalArgumentException("Invalid level: " + level);
    }

    public int toInt() {
        return this.level;
    }

    public boolean isClear() {
        return this.level == 0;
    }

    public boolean isIndeterminate() {
        return this.level == 1;
    }

    public boolean isCritical() {
        return this.level == 2;
    }

    public boolean isMajor() {
        return this.level == 3;
    }

    public boolean isMinor() {
        return this.level == 4;
    }

    public boolean isWarning() {
        return this.level == 5;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof AlarmLevel && ((AlarmLevel)obj).level == this.level;
    }

    public int hashCode() {
        return this.level;
    }

    public String toString() {
        switch (this.level) {
            case 0: {
                return "Clear";
            }
            case 1: {
                return "Indeterminate";
            }
            case 2: {
                return "Critical";
            }
            case 3: {
                return "Major";
            }
            case 4: {
                return "Minor";
            }
            case 5: {
                return "Warning";
            }
        }
        return "Invalid AlarmLevel";
    }

    private AlarmLevel(int level) {
        this.level = level;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return AlarmLevel.fromInt(this.level);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found");
        }
    }
}

