/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.facilities;

import java.io.Serializable;
import javax.slee.facilities.TimerPreserveMissed;

public class TimerOptions
implements Serializable {
    private boolean persistent;
    private long timeout;
    private TimerPreserveMissed preserveMissed;

    public TimerOptions() {
        this(false, 0L, TimerPreserveMissed.LAST);
    }

    public TimerOptions(TimerOptions options) {
        this(options.persistent, options.timeout, options.preserveMissed);
    }

    public TimerOptions(boolean persistent, long timeout, TimerPreserveMissed preserveMissed) throws NullPointerException, IllegalArgumentException {
        this.setPersistent(persistent);
        this.setTimeout(timeout);
        this.setPreserveMissed(preserveMissed);
    }

    public final boolean isPersistent() {
        return this.persistent;
    }

    public final void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(long timeout) throws IllegalArgumentException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout cannot be less than zero");
        }
        this.timeout = timeout;
    }

    public final TimerPreserveMissed getPreserveMissed() {
        return this.preserveMissed;
    }

    public final void setPreserveMissed(TimerPreserveMissed preserveMissed) throws NullPointerException {
        if (preserveMissed == null) {
            throw new NullPointerException("preserveMissed is null");
        }
        this.preserveMissed = preserveMissed;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TimerOptions)) {
            return false;
        }
        TimerOptions that = (TimerOptions)obj;
        return this.persistent == that.persistent && this.timeout == that.timeout && this.preserveMissed.equals(that.preserveMissed);
    }

    public int hashCode() {
        return (int)this.timeout | (this.persistent ? 4096 : 0) | this.preserveMissed.hashCode() << 20;
    }

    public String toString() {
        return "TimerOptions[persistent=" + this.persistent + ",timeout=" + this.timeout + ",preserve missed=" + this.preserveMissed + "]";
    }
}

