/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.util.HashMap;
import java.util.Iterator;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.slee.management.AlarmNotification;

public class AlarmDuplicateFilter
implements NotificationFilter {
    private final long period;
    private final HashMap knownAlarms = new HashMap();

    public AlarmDuplicateFilter(long period) {
        this.period = period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotificationEnabled(Notification notification) {
        if (!(notification instanceof AlarmNotification)) {
            return false;
        }
        HashMap hashMap = this.knownAlarms;
        synchronized (hashMap) {
            this.clearStaleTimeouts();
            if (this.knownAlarms.containsKey(notification)) {
                return false;
            }
            this.knownAlarms.put(notification, new Long(System.currentTimeMillis()));
            return true;
        }
    }

    private void clearStaleTimeouts() {
        Iterator iterator = this.knownAlarms.values().iterator();
        long currentTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Long firstSeenTime = (Long)iterator.next();
            if (firstSeenTime + this.period >= currentTime) continue;
            iterator.remove();
        }
    }
}

