/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import javax.management.Notification;
import javax.slee.facilities.AlarmLevel;
import javax.slee.facilities.Level;
import javax.slee.management.AlarmMBean;

public class AlarmNotification
extends Notification {
    public static final String ALARM_NOTIFICATION_TYPE = "javax.slee.management.alarm";
    private final String alarmType;
    private final Object alarmSource;
    private final Level alarmLevel;
    private final AlarmLevel level;
    private final Throwable cause;

    public AlarmNotification(AlarmMBean notificationSource, String alarmType, Object alarmSource, Level alarmLevel, String message, Throwable cause, long sequenceNumber, long timeStamp) throws NullPointerException, IllegalArgumentException {
        super(ALARM_NOTIFICATION_TYPE, notificationSource, sequenceNumber, timeStamp, message);
        if (notificationSource == null) {
            throw new NullPointerException("notificationSource is null");
        }
        if (alarmType == null) {
            throw new NullPointerException("alarmType is null");
        }
        if (alarmLevel == null) {
            throw new NullPointerException("alarmLevel is null");
        }
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        if (alarmLevel.isOff()) {
            throw new IllegalArgumentException("alarmLevel cannot be Level.OFF");
        }
        this.alarmType = alarmType;
        this.alarmSource = alarmSource;
        this.alarmLevel = alarmLevel;
        this.cause = cause;
        this.level = null;
    }

    public AlarmNotification(String notificationType, AlarmMBean notificationSource, String alarmType, AlarmLevel alarmLevel, String message, Throwable cause, long sequenceNumber, long timeStamp) throws NullPointerException {
        super(notificationType, notificationSource, sequenceNumber, timeStamp, message);
        if (notificationType == null) {
            throw new NullPointerException("notificationType is null");
        }
        if (notificationSource == null) {
            throw new NullPointerException("notificationSource is null");
        }
        if (alarmType == null) {
            throw new NullPointerException("alarmType is null");
        }
        if (alarmLevel == null) {
            throw new NullPointerException("alarmLevel is null");
        }
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        this.alarmType = alarmType;
        this.level = alarmLevel;
        this.cause = cause;
        this.alarmLevel = null;
        this.alarmSource = null;
    }

    public final String getAlarmType() {
        return this.alarmType;
    }

    public final Object getAlarmSource() {
        return this.alarmSource;
    }

    public final Level getLevel() {
        return this.alarmLevel;
    }

    public final AlarmLevel getAlarmLevel() {
        return this.level;
    }

    public final Throwable getCause() {
        return this.cause;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AlarmNotification)) {
            return false;
        }
        AlarmNotification that = (AlarmNotification)obj;
        if (this.alarmLevel != null) {
            if (that.alarmLevel == null) {
                return false;
            }
            return this.alarmType.equals(that.alarmType) && this.alarmSource.equals(that.alarmSource) && this.alarmLevel.equals(that.alarmLevel) && this.getMessage().equals(that.getMessage());
        }
        if (that.alarmLevel != null) {
            return false;
        }
        return this.alarmType.equals(that.alarmType) && this.level.equals(that.level) && this.getMessage().equals(that.getMessage());
    }

    public int hashCode() {
        return this.getMessage().hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("AlarmNotification[type=").append(this.alarmType).append(",level=").append(this.level).append(",message=").append(this.getMessage()).append(",cause=").append(this.cause).append(",timestamp=").append(this.getTimeStamp()).append("]");
        return buf.toString();
    }
}

