/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.Serializable;

public interface Properties {
    public Property[] getProperties();

    public Property getProperty(String var1);

    public static final class Property
    implements Serializable {
        private final String name;
        private final String type;
        private Object value;

        public Property(String name, String type, Object value) throws IllegalArgumentException {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            if (type == null) {
                throw new NullPointerException("type is null");
            }
            this.name = name;
            this.type = type;
            this.setValue(value);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) throws IllegalArgumentException {
            if (value == null) {
                this.value = null;
                return;
            }
            if (!value.getClass().getName().equals(this.type)) {
                throw new IllegalArgumentException("Value is of type " + value.getClass().getName() + ", required type is " + this.type);
            }
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Property)) {
                return false;
            }
            Property that = (Property)obj;
            if (!this.name.equals(that.name)) {
                return false;
            }
            if (!this.type.equals(that.type)) {
                return false;
            }
            return this.value == null ? that.value == null : this.value.equals(that.value);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Property[").append(this.name).append(':').append(this.type).append('=').append(this.value).append(']');
            return buf.toString();
        }

        public static Object toObject(String type, String value) throws IllegalArgumentException {
            if (type == null) {
                throw new NullPointerException("type is null");
            }
            if (value == null) {
                throw new NullPointerException("value is null");
            }
            try {
                if (type.equals("java.lang.Integer")) {
                    return new Integer(value);
                }
                if (type.equals("java.lang.Long")) {
                    return new Long(value);
                }
                if (type.equals("java.lang.Double")) {
                    return new Double(value);
                }
                if (type.equals("java.lang.Float")) {
                    return new Float(value);
                }
                if (type.equals("java.lang.Short")) {
                    return new Short(value);
                }
                if (type.equals("java.lang.Byte")) {
                    return new Byte(value);
                }
                if (type.equals("java.lang.Character")) {
                    if (value.length() != 1) {
                        throw new IllegalArgumentException("Invalid value for java.lang.Character type: " + value);
                    }
                    return new Character(value.charAt(0));
                }
                if (type.equals("java.lang.Boolean")) {
                    String caps = value.toUpperCase();
                    if (caps.equals("TRUE")) {
                        return new Boolean(true);
                    }
                    if (caps.equals("FALSE")) {
                        return new Boolean(false);
                    }
                    throw new IllegalArgumentException("Invalid value for java.lang.Boolean type: " + value);
                }
                if (type.equals("java.lang.String")) {
                    return value;
                }
                throw new IllegalArgumentException("Unsupported type: " + type);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid value for " + type + " type: " + value);
            }
        }
    }
}

