/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class ResourceAdaptorEntityState
implements Serializable {
    public static final int ENTITY_INACTIVE = 0;
    public static final int ENTITY_ACTIVE = 1;
    public static final int ENTITY_STOPPING = 2;
    public static final ResourceAdaptorEntityState INACTIVE = new ResourceAdaptorEntityState(0);
    public static final ResourceAdaptorEntityState ACTIVE = new ResourceAdaptorEntityState(1);
    public static final ResourceAdaptorEntityState STOPPING = new ResourceAdaptorEntityState(2);
    private final int state;

    public static ResourceAdaptorEntityState fromInt(int state) throws IllegalArgumentException {
        switch (state) {
            case 0: {
                return INACTIVE;
            }
            case 1: {
                return ACTIVE;
            }
            case 2: {
                return STOPPING;
            }
        }
        throw new IllegalArgumentException("Invalid state: " + state);
    }

    public int toInt() {
        return this.state;
    }

    public boolean isInactive() {
        return this.state == 0;
    }

    public boolean isActive() {
        return this.state == 1;
    }

    public boolean isStopping() {
        return this.state == 2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof ResourceAdaptorEntityState && ((ResourceAdaptorEntityState)obj).state == this.state;
    }

    public int hashCode() {
        return this.state;
    }

    public String toString() {
        switch (this.state) {
            case 0: {
                return "Resource Adaptor Inactive";
            }
            case 1: {
                return "Resource Adaptor Active";
            }
            case 2: {
                return "Resource Adaptor Stopping";
            }
        }
        return "Resource Adaptor Entity in Unknown and Invalid State";
    }

    private ResourceAdaptorEntityState(int state) {
        this.state = state;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return ResourceAdaptorEntityState.fromInt(this.state);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found");
        }
    }
}

