/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.facilities.AlarmLevel;
import javax.slee.management.AlarmMBean;
import javax.slee.management.AlarmNotification;

public class SbbAlarmNotification
extends AlarmNotification {
    public static final String ALARM_NOTIFICATION_TYPE = "javax.slee.management.alarm.sbb";
    private final ServiceID service;
    private final SbbID sbb;

    public SbbAlarmNotification(AlarmMBean notificationSource, ServiceID service, SbbID sbb, String alarmType, AlarmLevel alarmLevel, String message, Throwable cause, long sequenceNumber, long timeStamp) throws NullPointerException {
        super(ALARM_NOTIFICATION_TYPE, notificationSource, alarmType, alarmLevel, message, cause, sequenceNumber, timeStamp);
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        if (sbb == null) {
            throw new NullPointerException("sbb is null");
        }
        this.service = service;
        this.sbb = sbb;
    }

    public final ServiceID getService() {
        return this.service;
    }

    public final SbbID getSbb() {
        return this.sbb;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SbbAlarmNotification)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SbbAlarmNotification that = (SbbAlarmNotification)obj;
        return this.service.equals(that.service) && this.sbb.equals(that.sbb);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SbbAlarmNotification[service=").append(this.service).append(",sbb=").append(this.sbb).append(",type=").append(this.getAlarmType()).append(",level=").append(this.getAlarmLevel()).append(",message=").append(this.getMessage()).append(",cause=").append(this.getCause()).append(",timestamp=").append(this.getTimeStamp()).append("]");
        return buf.toString();
    }
}

