/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class ServiceState
implements Serializable {
    public static final int SERVICE_INACTIVE = 0;
    public static final int SERVICE_ACTIVE = 1;
    public static final int SERVICE_STOPPING = 2;
    public static final ServiceState INACTIVE = new ServiceState(0);
    public static final ServiceState ACTIVE = new ServiceState(1);
    public static final ServiceState STOPPING = new ServiceState(2);
    private final int state;

    public static ServiceState fromInt(int state) throws IllegalArgumentException {
        switch (state) {
            case 0: {
                return INACTIVE;
            }
            case 1: {
                return ACTIVE;
            }
            case 2: {
                return STOPPING;
            }
        }
        throw new IllegalArgumentException("Invalid state: " + state);
    }

    public int toInt() {
        return this.state;
    }

    public boolean isInactive() {
        return this.state == 0;
    }

    public boolean isActive() {
        return this.state == 1;
    }

    public boolean isStopping() {
        return this.state == 2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof ServiceState && ((ServiceState)obj).state == this.state;
    }

    public int hashCode() {
        return this.state;
    }

    public String toString() {
        switch (this.state) {
            case 0: {
                return "Service Inactive";
            }
            case 1: {
                return "Service Active";
            }
            case 2: {
                return "Service Stopping";
            }
        }
        return "Service in Unknown and Invalid State";
    }

    private ServiceState(int state) {
        this.state = state;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return ServiceState.fromInt(this.state);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found");
        }
    }
}

