/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class SleeState
implements Serializable {
    public static final int SLEE_STOPPED = 0;
    public static final int SLEE_STARTING = 1;
    public static final int SLEE_RUNNING = 2;
    public static final int SLEE_STOPPING = 3;
    public static final SleeState STOPPED = new SleeState(0);
    public static final SleeState STARTING = new SleeState(1);
    public static final SleeState RUNNING = new SleeState(2);
    public static final SleeState STOPPING = new SleeState(3);
    private final int state;

    public static SleeState fromInt(int state) throws IllegalArgumentException {
        switch (state) {
            case 0: {
                return STOPPED;
            }
            case 1: {
                return STARTING;
            }
            case 2: {
                return RUNNING;
            }
            case 3: {
                return STOPPING;
            }
        }
        throw new IllegalArgumentException("Invalid state: " + state);
    }

    public int toInt() {
        return this.state;
    }

    public boolean isStopped() {
        return this.state == 0;
    }

    public boolean isStarting() {
        return this.state == 1;
    }

    public boolean isRunning() {
        return this.state == 2;
    }

    public boolean isStopping() {
        return this.state == 3;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof SleeState && ((SleeState)obj).state == this.state;
    }

    public int hashCode() {
        return this.state;
    }

    public String toString() {
        switch (this.state) {
            case 0: {
                return "Stopped";
            }
            case 1: {
                return "Starting";
            }
            case 2: {
                return "Running";
            }
            case 3: {
                return "Stopping";
            }
        }
        return "SLEE in Unknown and Invalid State";
    }

    private SleeState(int state) {
        this.state = state;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return SleeState.fromInt(this.state);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found");
        }
    }
}

