/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import javax.management.Notification;
import javax.slee.management.SleeManagementMBean;
import javax.slee.management.SleeState;

public class SleeStateChangeNotification
extends Notification {
    private final SleeState newState;
    private final SleeState oldState;

    public SleeStateChangeNotification(SleeManagementMBean notificationSource, SleeState newState, SleeState oldState, long sequenceNumber) throws NullPointerException {
        super("javax.slee.management.sleestatechange", notificationSource, sequenceNumber, System.currentTimeMillis(), "SLEE state changed from " + oldState + " to " + newState);
        if (notificationSource == null) {
            throw new NullPointerException("notificationSource is null");
        }
        if (newState == null) {
            throw new NullPointerException("newState is null");
        }
        if (oldState == null) {
            throw new NullPointerException("oldState is null");
        }
        this.newState = newState;
        this.oldState = oldState;
    }

    public final SleeState getNewState() {
        return this.newState;
    }

    public final SleeState getOldState() {
        return this.oldState;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SleeStateChangeNotification[timestamp=").append(this.getTimeStamp()).append(",oldState=").append(this.oldState).append(",newState=").append(this.newState).append("]");
        return buf.toString();
    }
}

