/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import javax.management.Notification;
import javax.slee.facilities.Level;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.TraceMBean;

public class TraceNotification
extends Notification {
    public static final String TRACE_NOTIFICATION_TYPE = "javax.slee.management.trace";
    private final String tracerName;
    private final Object messageSource;
    private final Level traceLevel;
    private final TraceLevel level;
    private final Throwable cause;

    public TraceNotification(TraceMBean notificationSource, String messageType, Object messageSource, Level traceLevel, String message, Throwable cause, long sequenceNumber, long timeStamp) throws NullPointerException, IllegalArgumentException {
        super(TRACE_NOTIFICATION_TYPE, notificationSource, sequenceNumber, timeStamp, message);
        if (notificationSource == null) {
            throw new NullPointerException("notificationSource is null");
        }
        if (messageType == null) {
            throw new NullPointerException("messageType is null");
        }
        if (traceLevel == null) {
            throw new NullPointerException("traceLevel is null");
        }
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        if (traceLevel.isOff()) {
            throw new IllegalArgumentException("traceLevel cannot be Level.OFF");
        }
        this.tracerName = messageType;
        this.messageSource = messageSource;
        this.traceLevel = traceLevel;
        this.cause = cause;
        this.level = TraceNotification.get11LevelFrom10Level(traceLevel);
    }

    public TraceNotification(String notificationType, TraceMBean notificationSource, String tracerName, TraceLevel traceLevel, String message, Throwable cause, long sequenceNumber, long timeStamp) throws NullPointerException, IllegalArgumentException {
        super(notificationType, notificationSource, sequenceNumber, timeStamp, message);
        if (notificationType == null) {
            throw new NullPointerException("notificationType is null");
        }
        if (notificationSource == null) {
            throw new NullPointerException("notificationSource is null");
        }
        if (tracerName == null) {
            throw new NullPointerException("tracerName is null");
        }
        if (traceLevel == null) {
            throw new NullPointerException("traceLevel is null");
        }
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        if (traceLevel.isOff()) {
            throw new IllegalArgumentException("level cannot be Level.OFF");
        }
        this.tracerName = tracerName;
        this.level = traceLevel;
        this.cause = cause;
        this.traceLevel = TraceNotification.get10LevelFrom11Level(traceLevel);
        this.messageSource = null;
    }

    public final String getMessageType() {
        return this.tracerName;
    }

    public final String getTracerName() {
        return this.tracerName;
    }

    public final Object getMessageSource() {
        return this.messageSource;
    }

    public final Level getLevel() {
        return this.traceLevel;
    }

    public final TraceLevel getTraceLevel() {
        return this.level;
    }

    public final Throwable getCause() {
        return this.cause;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TraceNotification)) {
            return false;
        }
        TraceNotification that = (TraceNotification)obj;
        if (!this.tracerName.equals(that.tracerName)) {
            return false;
        }
        if (!this.traceLevel.equals(that.traceLevel)) {
            return false;
        }
        if (this.messageSource == null) {
            if (that.messageSource != null) {
                return false;
            }
        } else {
            if (that.messageSource == null) {
                return false;
            }
            if (!this.messageSource.equals(that.messageSource)) {
                return false;
            }
        }
        return this.getMessage().equals(that.getMessage());
    }

    public int hashCode() {
        return this.getMessage().hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TraceNotification[tracer=").append(this.tracerName).append(",level=").append(this.level).append(",message=").append(this.getMessage()).append(",cause=").append(this.cause).append(",timestamp=").append(this.getTimeStamp()).append("]");
        return buf.toString();
    }

    static TraceLevel get11LevelFrom10Level(Level traceLevel) {
        if (traceLevel.isOff()) {
            return TraceLevel.OFF;
        }
        if (traceLevel.isSevere()) {
            return TraceLevel.SEVERE;
        }
        if (traceLevel.isWarning()) {
            return TraceLevel.WARNING;
        }
        if (traceLevel.isMinor()) {
            return TraceLevel.INFO;
        }
        if (traceLevel.isConfig()) {
            return TraceLevel.CONFIG;
        }
        if (traceLevel.isFine()) {
            return TraceLevel.FINE;
        }
        if (traceLevel.isFiner()) {
            return TraceLevel.FINER;
        }
        return TraceLevel.FINEST;
    }

    static Level get10LevelFrom11Level(TraceLevel level) {
        if (level.isOff()) {
            return Level.OFF;
        }
        if (level.isSevere()) {
            return Level.SEVERE;
        }
        if (level.isWarning()) {
            return Level.WARNING;
        }
        if (level.isInfo()) {
            return Level.INFO;
        }
        if (level.isConfig()) {
            return Level.CONFIG;
        }
        if (level.isFine()) {
            return Level.FINE;
        }
        if (level.isFiner()) {
            return Level.FINER;
        }
        return Level.FINEST;
    }
}

