/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.resource;

import java.io.StreamCorruptedException;

public class FailureReason {
    public static final int REASON_REASON_UNKNOWN = 0;
    public static final int REASON_ACTIVITY_ENDING = -1;
    public static final int REASON_EVENT_QUEUE_FULL = -2;
    public static final int REASON_EVENT_QUEUE_TIMEOUT = -3;
    public static final int REASON_SYSTEM_OVERLOAD = -4;
    public static final int REASON_EVENT_SERIALIZATION_ERROR = -5;
    public static final FailureReason REASON_UNKNOWN = new FailureReason(0);
    public static final FailureReason ACTIVITY_ENDING = new FailureReason(-1);
    public static final FailureReason EVENT_QUEUE_FULL = new FailureReason(-2);
    public static final FailureReason EVENT_QUEUE_TIMEOUT = new FailureReason(-3);
    public static final FailureReason SYSTEM_OVERLOAD = new FailureReason(-4);
    public static final FailureReason EVENT_SERIALIZATION_ERROR = new FailureReason(-5);
    private final int reason;

    public static FailureReason fromInt(int reason) throws IllegalArgumentException {
        switch (reason) {
            case 0: {
                return REASON_UNKNOWN;
            }
            case -1: {
                return ACTIVITY_ENDING;
            }
            case -2: {
                return EVENT_QUEUE_FULL;
            }
            case -3: {
                return EVENT_QUEUE_TIMEOUT;
            }
            case -4: {
                return SYSTEM_OVERLOAD;
            }
            case -5: {
                return EVENT_SERIALIZATION_ERROR;
            }
        }
        throw new IllegalArgumentException("Invalid level: " + reason);
    }

    public int toInt() {
        return this.reason;
    }

    public boolean isReasonUnknown() {
        return this.reason == 0;
    }

    public boolean isActivityEnding() {
        return this.reason == -1;
    }

    public boolean isEventQueueFull() {
        return this.reason == -2;
    }

    public boolean isEventQueueTimeout() {
        return this.reason == -3;
    }

    public boolean isSystemOverLoad() {
        return this.reason == -4;
    }

    public boolean isEventSerializationError() {
        return this.reason == -5;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof FailureReason && ((FailureReason)obj).reason == this.reason;
    }

    public int hashCode() {
        return this.reason;
    }

    public String toString() {
        switch (this.reason) {
            case 0: {
                return "Unknown reason";
            }
            case -1: {
                return "Activity is ending";
            }
            case -2: {
                return "Event queue full";
            }
            case -3: {
                return "Event timed out while queued";
            }
            case -4: {
                return "System overload";
            }
            case -5: {
                return "Event serialization error";
            }
        }
        return "Undefined reason";
    }

    private FailureReason(int reason) {
        this.reason = reason;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return FailureReason.fromInt(this.reason);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found");
        }
    }
}

