/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.usage;

import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.slee.InvalidArgumentException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.usage.UsageNotification;

public class UsageOutOfRangeFilter
implements NotificationFilter {
    private final ServiceID service;
    private final SbbID sbb;
    private final String paramName;
    private final long lowValue;
    private final long highValue;

    public UsageOutOfRangeFilter(ServiceID service, SbbID sbb, String paramName, long lowValue, long highValue) throws NullPointerException, InvalidArgumentException {
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        if (sbb == null) {
            throw new NullPointerException("sbb is null");
        }
        if (paramName == null) {
            throw new NullPointerException("paramName is null");
        }
        if (highValue < lowValue) {
            throw new InvalidArgumentException("highValue < lowValue");
        }
        this.service = service;
        this.sbb = sbb;
        this.paramName = paramName;
        this.lowValue = lowValue;
        this.highValue = highValue;
    }

    public boolean isNotificationEnabled(Notification notification) {
        if (!(notification instanceof UsageNotification)) {
            return false;
        }
        UsageNotification usageNotification = (UsageNotification)notification;
        return usageNotification.getService().equals(this.service) && usageNotification.getSbb().equals(this.sbb) && usageNotification.getUsageParameterName().equals(this.paramName) && (usageNotification.getValue() < this.lowValue || usageNotification.getValue() > this.highValue);
    }
}

