/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.usage;

import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.usage.UsageNotification;

public class UsageThresholdFilter
implements NotificationFilter {
    private final ServiceID service;
    private final SbbID sbb;
    private final String paramName;
    private final long threshold;
    private long previous = 0L;
    private long lastDir = 0L;

    public UsageThresholdFilter(ServiceID service, SbbID sbb, String paramName, long threshold) throws NullPointerException {
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        if (sbb == null) {
            throw new NullPointerException("sbb is null");
        }
        if (paramName == null) {
            throw new NullPointerException("paramName is null");
        }
        this.service = service;
        this.sbb = sbb;
        this.paramName = paramName;
        this.threshold = threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotificationEnabled(Notification notification) {
        boolean bl;
        block6: {
            if (!(notification instanceof UsageNotification)) {
                return false;
            }
            UsageNotification usageNotification = (UsageNotification)notification;
            if (!usageNotification.getService().equals(this.service)) {
                return false;
            }
            if (!usageNotification.getSbb().equals(this.sbb)) {
                return false;
            }
            if (!usageNotification.getUsageParameterName().equals(this.paramName)) {
                return false;
            }
            long current = usageNotification.getValue();
            try {
                bl = this.previous != this.threshold ? this.previous < this.threshold && current > this.threshold || this.previous > this.threshold && current < this.threshold : (long)this.getDirection(this.previous, current) == this.lastDir;
                Object var7_5 = null;
                if (this.previous == current) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var7_6 = null;
                    if (this.previous == current) break block7;
                    this.lastDir = this.getDirection(this.previous, current);
                    this.previous = current;
                }
                throw throwable;
            }
            this.lastDir = this.getDirection(this.previous, current);
            this.previous = current;
        }
        return bl;
    }

    private int getDirection(long x, long y) {
        return x == y ? 0 : (x < y ? 1 : -1);
    }
}

