package javax.slee.profile;

import javax.slee.Address;

/**
 * This interface is implemented by profile added events generated by
 * <code>ProfileProvisioningMBean</code> objects when a profile is added to a
 * profile table.
 * <p>
 * The event type name of profile added events is
 * "<code>javax.slee.profile.ProfileAddedEvent</code>".
 */
public interface ProfileAddedEvent {
    /**
     * Get the profile identifier for the profile that was added.
     * @return the profile identifier for the profile that was added.
     */
    public ProfileID getProfile();

    /**
     * Get the address of the profile that was added.  The address plan of this
     * address is {@link javax.slee.AddressPlan#SLEE_PROFILE}.
     * @return the address of the profile that was added.
     */
    public Address getProfileAddress();

    /**
     * Get the committed state of the profile that was added.  The actual type of the
     * return value is the Profile CMP Interface defined by the profile specification
     * of the profile table in which the profile resides, and may be safely typecast
     * using the normal Java typecast mechanism.
     * <p>
     * The object returned from this method is only valid within the event-handler transaction
     * in which the event was delivered to an SBB entity.  The state contained in the
     * object is read-only and cannot be modified.
     * @return the committed state of the profile that was added.  This method may
     *        return <code>null</code> in the case where the required profile specification
     *        classes are not available in the classloader of the calling SLEE component,
     *        eg. the SLEE component's deployment descriptor has not defined a reference
     *        to the profile specification of this event's profile table.
     * @deprecated Replaced with {@link #getAddedProfileLocal()} which returns an object
     *        implementing the Profile Local Interface rather than the Profile CMP Interface.
     */
    public Object getAddedProfile();

    /**
     * Get a profile local object associated with the committed state of the profile
     * that was added.  The actual type of the return value is the Profile Local Interface
     * defined by the profile specification of the profile table in which the profile
     * resides, and may be safely typecast using the normal Java typecast mechanism.
     * <p>
     * The object returned from this method is only valid within the event-handler transaction
     * in which the event was delivered to an SBB entity.  The state accessed via the
     * profile local object is read-only and cannot be modified.
     * @return a profile local object associated with the committed state of the profile
     *        that was added.  This method may return <code>null</code> in the case where
     *        the required profile specification classes are not available in the classloader
     *        of the calling SLEE component, eg. the SLEE component's deployment descriptor
     *        has not defined a reference to the profile specification of this event's profile
     *        table.
     * @since SLEE 1.1
     */
    public ProfileLocalObject getAddedProfileLocal();
}

