package javax.slee.profile;

import javax.slee.InvalidStateException;
import javax.slee.management.ManagementException;

/**
 * This interface is implemented by a Profile MBean Class generated by the
 * SLEE for a profile specification. This interface contains essential operations
 * for managaing the life-cycle of Profile MBean objects.
 * <p>
 * The base JMX Object Name of a <code>ProfileMBean</code> object is specified by the
 * {@link #BASE_OBJECT_NAME} constant.  The {@link #PROFILE_TABLE_NAME_KEY} and
 * {@link #PROFILE_NAME_KEY} constants define additional Object Name properties that
 * uniquely identify a profile.  The complete Object Name for a Profile MBean can
 * be obtained by a management client via various methods in the
 * {@link javax.slee.management.ProfileProvisioningMBean} interface.
 */
public interface ProfileMBean {
    /**
     * The base JMX Object Name string of all SLEE Profile MBeans.  This string is
     * equal to "javax.slee.profile:type=Profile" and the string <code>BASE_OBJECT_NAME + ",*"</code>
     * defines a JMX Object Name property pattern which matches with all Profile MBeans
     * that are registered with the MBean Server.  A Profile MBean is registered with
     * the MBean Server using this base name in conjunction with properties whose keys
     * are specified by the {@link #PROFILE_TABLE_NAME_KEY} and {@link #PROFILE_NAME_KEY}
     * constants.
     * @since SLEE 1.1
     */
    public static final String BASE_OBJECT_NAME = "javax.slee.profile:type=Profile";

    /**
     * The JMX Object Name property key that identifies a Profile MBean as representing
     * a profile belonging to the profile table specified by the value of this key in
     * the Object Name.  This key is equal to the string "profileTableName".
     * @see #BASE_OBJECT_NAME
     * @see #PROFILE_NAME_KEY
     * @since SLEE 1.1
     */
    public static final String PROFILE_TABLE_NAME_KEY = "profileTableName";

    /**
     * The JMX Object Name property key that identifies a Profile MBean as representing
     * the profile specified by the value of this key in the Object Name.  This key
     * is equal to the string "profileName".
     * @see #BASE_OBJECT_NAME
     * @see #PROFILE_TABLE_NAME_KEY
     * @since SLEE 1.1
     */
    public static final String PROFILE_NAME_KEY = "profileName";


    /**
     * Request that the client be granted read/write access to the profile
     * so that it may be updated.  If the client already has read/write access
     * to the profile, this method returns silently.
     * @throws ManagementException if the profile could not be opened in
     *       read/write mode due to a system-level failure.
     */
    public void editProfile()
        throws ManagementException;

    /**
     * Request that changes made to a profile be committed by the SLEE.
     * If this method returns successfully, the SLEE must again permit the
     * client read-only access to the profile.
     * @throws InvalidStateException if the client does not have read/write
     *       access to the profile, ie {@link #isProfileWriteable()} returns <code>false</code>.
     * @throws ProfileVerificationException if thrown by the {@link Profile#profileVerify}
     *       callback method in the profile's Management Profile Abstract Class.  This exception
     *       can also be thrown by the profile MBean if the deployment descriptor for the profile
     *       specification documents an indexed attribute as requiring unique values and a
     *       non-unique value has been supplied in the profile.
     * @throws ManagementException if the commit operation could not be successfully
     *       completed due to a system-level failure.
     */
    public void commitProfile()
        throws InvalidStateException, ProfileVerificationException, ManagementException;

    /**
     * Request that changes made to profile should be discarded by the SLEE.
     * This method is typically invoked by a management client, but may also be
     * invoked by the SLEE if a client session times out.
     * If this method returns successfully, the SLEE must again permit the
     * client read-only access to the profile.
     * @throws InvalidStateException if the client does not have read/write
     *       access to the profile, ie {@link #isProfileWriteable()} returns <code>false</code>.
     * @throws ManagementException if the restore operation could not be successfully
     *       completed due to a system-level failure.
     */
    public void restoreProfile()
        throws InvalidStateException, ManagementException;

    /**
     * Notify the SLEE that the profile is no longer required by the management
     * client.  As the SLEE may subsequently deregister the profile from the MBean
     * server if no other client is currently accessing the profile, a client that
     * invokes this method should assume that the Object Name they had for the profile
     * is no longer valid once this method returns.
     * @throws InvalidStateException if the profile is in read-write mode and contains
     *       uncommitted changes.
     * @throws ManagementException if the profile could not be closed by the SLEE due
     *       to a system-level failure.
     */
    public void closeProfile()
        throws InvalidStateException, ManagementException;

    /**
     * Determine if the profile has been modified since the request to edit the profile.
     * @return <code>true</code> if the profile has been modified in the current
     *       editing session, <code>false</code> if the profile hasn't been modified or
     *       the profile is read-only to the client.
     * @throws ManagementException if it could not be determined if the profile has
     *       been modified due to a system-level failure.
     */
    public boolean isProfileDirty()
        throws ManagementException;

    /**
     * Get the current read-write status of the profile.
     * @return <code>true</code> if the profile MBean may be changed by the management
     *       client, ie. {@link #editProfile()} has been successfully invoked,
     *       <code>false</code> otherwise.
     * @throws ManagementException if the read-write status of the profile could not
     *       be interrogated due to a system-level failure.
     */
    public boolean isProfileWriteable()
        throws ManagementException;

}
