package javax.slee.profile;

import javax.slee.Address;

/**
 * This interface is implemented by profile removed events generated by
 * <code>ProfileProvisioningMBean</code> objects when a profile is removed from a
 * profile table.
 * <p>
 * The event type name of profile removed events is
 * "<code>javax.slee.profile.ProfileRemovedEvent</code>".
 */
public interface ProfileRemovedEvent {
    /**
     * Get the profile identifier for the profile that was removed.
     * @return the profile identifier for the profile that was removed.
     */
    public ProfileID getProfile();

    /**
     * Get the address of the profile that was removed.  The address plan of this
     * address is {@link javax.slee.AddressPlan#SLEE_PROFILE}.
     * @return the address of the profile that was removed.
     */
    public Address getProfileAddress();

    /**
     * Get the committed state of the profile just before it was removed.  The actual type
     * of the return value is the Profile CMP Interface defined by the profile specification
     * of the profile table in which the profile resided, and may be safely typecast
     * using the normal Java typecast mechanism.
     * <p>
     * The object returned from this method is only valid within the event-handler transaction
     * in which the event was delivered to an SBB entity.  The state contained in the
     * object is read-only and cannot be modified.
     * @return the committed state of the profile just before it was removed.  This method may
     *        return <code>null</code> in the case where the required profile specification
     *        classes are not available in the classloader of the calling SLEE component,
     *        eg. the SLEE component's deployment descriptor has not defined a reference
     *        to the profile specification of this event's profile table.
     * @deprecated Replaced with {@link #getRemovedProfileLocal()} which returns an object
     *        implementing the Profile Local Interface rather than the Profile CMP Interface.
     */
    public Object getRemovedProfile();

    /**
     * Get a profile local object associated with the committed state of the profile
     * before it was updated.  The actual type of the return value is the Profile Local
     * Interface defined by the profile specification of the profile table in which the
     * profile resides, and may be safely typecast using the normal Java typecast mechanism.
     * <p>
     * The object returned from this method is only valid within the event-handler transaction
     * in which the event was delivered to an SBB entity.  The state accessed via the
     * profile local object is read-only and cannot be modified.
     * @return a profile local object associated with the committed state of the profile
     *        before it was removed.  This method may return <code>null</code> in the case where
     *        the required profile specification classes are not available in the classloader
     *        of the calling SLEE component, eg. the SLEE component's deployment descriptor
     *        has not defined a reference to the profile specification of this event's profile
     *        table.
     * @since SLEE 1.1
     */
    public ProfileLocalObject getRemovedProfileLocal();
}

