package javax.slee.usage;

import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.InvalidStateException;
import javax.slee.management.ManagementException;
import javax.slee.management.ServiceUsageMBean;


/**
 * The <code>SbbUsageMBean</code> interface must be implemented by an SBB Usage MBean Class
 * generated by the SLEE.  This interface contains functionality that provides basic
 * management of an SBB's usage parameters.  The Object Name of a <code>SbbUsageMBean</code>
 * object can be obtained by a management client by invoking one of the <code>getSbbUsageMBean</code>
 * methods on a {@link ServiceUsageMBean} object.
 * <p>
 * <b>Interface extension</b><br>
 * During SBB deployment the <code>SbbUsageMBean</code> interface is extended to provide access
 * to the usage parameters defined by the SBB.  Each counter-type usage parameter causes the
 * addition of a managed operation with the following signature:
 * <p>
 * <ul><code>public long get<i>&lt;usage-parameter-name&gt;</i>(boolean reset) throws ManagementException;</code></ul>
 * <p>
 * Each sample-type usage parameter causes the addition of a managed operation with the
 * following signature:
 * <p>
 * <ul><code>public SampleStatistics get<i>&lt;usage-parameter-name&gt;</i>(boolean reset) throws ManagementException;</code></ul>
 * <p>
 * In each operation, <code><i>usage-parameter-name</i></code> is the name of the usage
 * parameter, with the first letter capitalized.  The <code>reset</code> parameter taken by
 * each operation is used to optionally reset the usage parameter value after the return
 * result has been obtained.
 * <p>
 * <b>Notifications</b><br>
 * Since <code>SbbUsageMBean</code> objects can emit {@link UsageNotification Usage}
 * notifications, it is required that a <code>SbbUsageMBean</code> object implement
 * the <code>javax.management.NotificationBroadcaster</code> interface.
 * @deprecated This interface has been replaced with the {@link UsageMBean} interface,
 * which specifies the source of the usage information using a generic
 * {@link javax.slee.management.NotificationSource} object. However, to ensure backward
 * compatibility, a <code>UsageMBean</code> object that is created by the SLEE for an
 * SBB installed using a SLEE 1.0 deployment descriptor (as determined by the deployment
 * descriptor's <code>DOCTYPE</code> declaration) must continue to implement this interface
 * as well as the <code>UsageMBean</code> interface of SLEE 1.1.
 */
public interface SbbUsageMBean {
    /**
     * The notification type of usage notifications emitted by this MBean.
     * The usage notification type is equal to the string "javax.slee.management.usage".
     * @deprecated Usage notification types are specified by the various classes that
     *        implement {@link javax.slee.management.NotificationSource NotificationSource}
     *        and refenced by a {@link UsageMBean} (which replaces this interface).
     */
    public static final String USAGE_NOTIFICATION_TYPE = "javax.slee.management.usage";

    /**
     * Get the component identifier of the Service containing the SBB that this MBean is
     * presenting usage information for.
     * @return the component identifier of the Service containing the SBB that this MBean
     *        is presenting usage information for.
     * @throws ManagementException if the Service component identifier could not be
     *        obtained due to a system-level failure.
     * @deprecated Replaced with a {@link UsageMBean} containing an
     *        {@link javax.slee.management.SbbNotification} as a notification source.
     */
    public ServiceID getService()
        throws ManagementException;

    /**
     * Get the component identifier of the SBB that this MBean is presenting usage
     * information for.
     * @return the component identifier of the SBB that this MBean is presenting usage
     *        information for.
     * @throws ManagementException if the SBB component identifier could not be
     *        obtained due to a system-level failure.
     * @deprecated Replaced with a {@link UsageMBean} containing an
     *        {@link javax.slee.management.SbbNotification} as a notification source.
     */
    public SbbID getSbb()
        throws ManagementException;

    /**
     * Get the name of the SBB usage parameter set that this MBean is presenting usage
     * information for.
     * @return the name of the SBB usage parameter set that this MBean is presenting usage
     *        information for, or <code>null</code> if this MBean is presenting usage
     *        information for the SBB's default usage parameter set.
     * @throws ManagementException if the SBB usage parameter set name could not be
     *        obtained due to a system-level failure.
     * @deprecated Replaced with {@link UsageMBean#getUsageParameterSet()}.
     */
    public String getUsageParameterSet()
        throws ManagementException;

    /**
     * Notify the SLEE that the SBB usage MBean is no longer required by the management
     * client.  As the SLEE may subsequently deregister the usage MBean from the MBean
     * server, a client that invokes this method should assume that the Object Name they
     * had for the MBean is no longer valid once this method returns.
     * @throws InvalidStateException if notification listeners are still attached to the sbb
     *       usage MBean.
     * @throws ManagementException if the SBB usage MBean could not be closed by the SLEE
     *       due to a system-level failure.
     * @deprecated Replaced with {@link UsageMBean#close()}.
     */
    public void close()
        throws InvalidStateException, ManagementException;

    /**
     * Reset all SBB usage parameters in the usage parameter set managed by this MBean.
     * Counter-type usage parameters are reset to <tt>0</tt> and sample-type usage parameters
     * have all samples cleared.
     * @throws ManagementException if the values of the usage parameters could not be
     *        reset due to a system-level failure.
     * @deprecated Replaced with {@link UsageMBean#resetAllUsageParameters()}.
     */
    public void resetAllUsageParameters()
        throws ManagementException;
}
