/*
 * Decompiled with CFR 0.152.
 */
package javax.slee;

import java.io.Serializable;
import javax.slee.AddressPlan;
import javax.slee.AddressPresentation;
import javax.slee.AddressScreening;

public class Address
implements Serializable {
    private final AddressPlan addressPlan;
    private final String addressString;
    private final AddressPresentation addressPresentation;
    private final AddressScreening addressScreening;
    private final String subAddressString;
    private final String addressName;

    public Address(AddressPlan addressPlan, String addressString) {
        this(addressPlan, addressString, null, null, null, null);
    }

    public Address(AddressPlan addressPlan, String addressString, AddressPresentation addressPresentation, AddressScreening addressScreening, String subAddressString, String addressName) {
        if (addressPlan == null) {
            throw new NullPointerException("addressPlan is null");
        }
        if (addressString == null) {
            throw new NullPointerException("addressString is null");
        }
        if (addressString.length() == 0) {
            throw new IllegalArgumentException("addressString is zero-length");
        }
        this.addressPlan = addressPlan;
        this.addressString = addressString;
        this.addressPresentation = addressPresentation;
        this.addressScreening = addressScreening;
        this.subAddressString = subAddressString;
        this.addressName = addressName;
    }

    public AddressPlan getAddressPlan() {
        return this.addressPlan;
    }

    public String getAddressString() {
        return this.addressString;
    }

    public AddressPresentation getAddressPresentation() {
        return this.addressPresentation;
    }

    public AddressScreening getAddressScreening() {
        return this.addressScreening;
    }

    public String getSubAddressString() {
        return this.subAddressString;
    }

    public String getAddressName() {
        return this.addressName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address that = (Address)obj;
        return this.addressPlan.equals(that.addressPlan) && this.addressString.equals(that.addressString);
    }

    public int hashCode() {
        return this.addressString.hashCode() ^ this.addressPlan.toInt() << 15;
    }

    public String toString() {
        return this.addressPlan.toString() + ": " + this.addressString;
    }
}

