/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.facilities;

import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class AlarmLevel
implements Serializable {
    public static final int LEVEL_CLEAR = 0;
    public static final int LEVEL_CRITICAL = 1;
    public static final int LEVEL_MAJOR = 2;
    public static final int LEVEL_WARNING = 3;
    public static final int LEVEL_INDETERMINATE = 4;
    public static final int LEVEL_MINOR = 5;
    public static final String CLEAR_STRING = "Clear";
    public static final String CRITICAL_STRING = "Critical";
    public static final String MAJOR_STRING = "Major";
    public static final String WARNING_STRING = "Warning";
    public static final String INDETERMINATE_STRING = "Indeterminate";
    public static final String MINOR_STRING = "Minor";
    public static final AlarmLevel CLEAR = new AlarmLevel(0);
    public static final AlarmLevel CRITICAL = new AlarmLevel(1);
    public static final AlarmLevel MAJOR = new AlarmLevel(2);
    public static final AlarmLevel WARNING = new AlarmLevel(3);
    public static final AlarmLevel INDETERMINATE = new AlarmLevel(4);
    public static final AlarmLevel MINOR = new AlarmLevel(5);
    private final int level;

    public static AlarmLevel fromInt(int level) throws IllegalArgumentException {
        switch (level) {
            case 0: {
                return CLEAR;
            }
            case 1: {
                return CRITICAL;
            }
            case 2: {
                return MAJOR;
            }
            case 3: {
                return WARNING;
            }
            case 4: {
                return INDETERMINATE;
            }
            case 5: {
                return MINOR;
            }
        }
        throw new IllegalArgumentException("Invalid level: " + level);
    }

    public static AlarmLevel fromString(String level) throws NullPointerException, IllegalArgumentException {
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        if (level.equalsIgnoreCase(CLEAR_STRING)) {
            return CLEAR;
        }
        if (level.equalsIgnoreCase(CRITICAL_STRING)) {
            return CRITICAL;
        }
        if (level.equalsIgnoreCase(MAJOR_STRING)) {
            return MAJOR;
        }
        if (level.equalsIgnoreCase(WARNING_STRING)) {
            return WARNING;
        }
        if (level.equalsIgnoreCase(INDETERMINATE_STRING)) {
            return INDETERMINATE;
        }
        if (level.equalsIgnoreCase(MINOR_STRING)) {
            return MINOR;
        }
        throw new IllegalArgumentException("Invalid level: " + level);
    }

    public int toInt() {
        return this.level;
    }

    public boolean isClear() {
        return this.level == 0;
    }

    public boolean isCritical() {
        return this.level == 1;
    }

    public boolean isMajor() {
        return this.level == 2;
    }

    public boolean isWarning() {
        return this.level == 3;
    }

    public boolean isIndeterminate() {
        return this.level == 4;
    }

    public boolean isMinor() {
        return this.level == 5;
    }

    public boolean isHigherLevel(AlarmLevel other) throws NullPointerException {
        if (other == null) {
            throw new NullPointerException("other is null");
        }
        return this.level < other.level;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof AlarmLevel && ((AlarmLevel)obj).level == this.level;
    }

    public int hashCode() {
        return this.level;
    }

    public String toString() {
        switch (this.level) {
            case 0: {
                return CLEAR_STRING;
            }
            case 1: {
                return CRITICAL_STRING;
            }
            case 2: {
                return MAJOR_STRING;
            }
            case 3: {
                return WARNING_STRING;
            }
            case 4: {
                return INDETERMINATE_STRING;
            }
            case 5: {
                return MINOR_STRING;
            }
        }
        return "AlarmLevel in Unknown and Invalid State";
    }

    private AlarmLevel(int level) {
        this.level = level;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return AlarmLevel.fromInt(this.level);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found");
        }
    }
}

