/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.MarshalledObject;
import javax.management.Notification;
import javax.slee.facilities.AlarmLevel;
import javax.slee.facilities.Level;
import javax.slee.management.AlarmMBean;
import javax.slee.management.NotificationSource;
import javax.slee.management.VendorExtensionUtils;
import javax.slee.management.VendorExtensions;

public final class AlarmNotification
extends Notification
implements VendorExtensions {
    private final String alarmID;
    private final NotificationSource notificationSource;
    private final String alarmType;
    private final String instanceID;
    private final Object alarmSource;
    private final Level level_10;
    private final AlarmLevel level_11;
    private transient Throwable cause;
    private static volatile boolean vendorDataSerializationEnabled = false;
    private static volatile boolean vendorDataDeserializationEnabled = false;
    private transient Object vendorData;

    public AlarmNotification(AlarmMBean alarmMBean, String alarmType, Object alarmSource, Level alarmLevel, String message, Throwable cause, long sequenceNumber, long timestamp) throws NullPointerException, IllegalArgumentException {
        super("javax.slee.management.alarm", alarmMBean, sequenceNumber, timestamp, message);
        if (alarmMBean == null) {
            throw new NullPointerException("alarmMBean is null");
        }
        if (alarmType == null) {
            throw new NullPointerException("alarmType is null");
        }
        if (alarmLevel == null) {
            throw new NullPointerException("alarmLevel is null");
        }
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        if (alarmLevel.isOff()) {
            throw new IllegalArgumentException("alarmLevel cannot be Level.OFF");
        }
        this.alarmType = alarmType;
        this.alarmSource = alarmSource;
        this.level_10 = alarmLevel;
        this.cause = cause;
        this.alarmID = null;
        this.notificationSource = null;
        this.instanceID = null;
        this.level_11 = null;
    }

    public AlarmNotification(String type, AlarmMBean alarmMBean, String alarmID, NotificationSource notificationSource, String alarmType, String instanceID, AlarmLevel alarmLevel, String message, Throwable cause, long sequenceNumber, long timestamp) throws NullPointerException {
        super(type, alarmMBean, sequenceNumber, timestamp, message);
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (alarmMBean == null) {
            throw new NullPointerException("alarmMBean is null");
        }
        if (alarmID == null) {
            throw new NullPointerException("alarmID is null");
        }
        if (notificationSource == null) {
            throw new NullPointerException("notificationSource is null");
        }
        if (alarmType == null) {
            throw new NullPointerException("alarmType is null");
        }
        if (instanceID == null) {
            throw new NullPointerException("instanceID is null");
        }
        if (alarmLevel == null) {
            throw new NullPointerException("alarmLevel is null");
        }
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        this.alarmID = alarmID;
        this.notificationSource = notificationSource;
        this.alarmType = alarmType;
        this.instanceID = instanceID;
        this.level_11 = alarmLevel;
        this.cause = cause;
        this.alarmSource = notificationSource;
        this.level_10 = Level.INFO;
    }

    public String getAlarmID() {
        return this.alarmID;
    }

    public NotificationSource getNotificationSource() {
        return this.notificationSource;
    }

    public String getAlarmType() {
        return this.alarmType;
    }

    public Object getAlarmSource() {
        return this.alarmSource;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public Level getLevel() {
        return this.level_10;
    }

    public AlarmLevel getAlarmLevel() {
        return this.level_11;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public static void enableVendorDataSerialization() {
        vendorDataSerializationEnabled = true;
    }

    public static void disableVendorDataSerialization() {
        vendorDataSerializationEnabled = false;
    }

    public static void enableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = true;
    }

    public static void disableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = false;
    }

    public void setVendorData(Object vendorData) {
        this.vendorData = vendorData;
    }

    public Object getVendorData() {
        return this.vendorData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AlarmNotification)) {
            return false;
        }
        AlarmNotification that = (AlarmNotification)obj;
        if (this.notificationSource == null) {
            if (that.notificationSource != null) {
                return false;
            }
            return this.alarmType.equals(that.alarmType) && this.alarmSource.equals(that.alarmSource) && this.level_10.equals(that.level_10) && this.getMessage().equals(that.getMessage());
        }
        if (that.notificationSource == null) {
            return false;
        }
        return this.alarmID.equals(that.alarmID) && ((Object)this.notificationSource).equals(that.notificationSource) && this.alarmType.equals(that.alarmType) && this.instanceID.equals(that.instanceID) && this.level_11.equals(that.level_11) && this.getMessage().equals(that.getMessage());
    }

    public int hashCode() {
        return this.level_10 != null ? this.getMessage().hashCode() : this.alarmID.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("AlarmNotification[");
        if (this.notificationSource == null) {
            buf.append("type=").append(this.getType()).append(",timestamp=").append(this.getTimeStamp()).append(",alarmType=").append(this.alarmType).append(",source=").append(this.alarmSource).append(",level=").append(this.level_10).append(",message=").append(this.getMessage()).append(",cause=").append(this.cause);
        } else {
            buf.append("type=").append(this.getType()).append(",id=").append(this.alarmID).append(",source=").append(this.notificationSource).append(",alarmType=").append(this.alarmType).append(",instanceID=").append(this.instanceID).append(",level=").append(this.level_11).append(",message=").append(this.getMessage()).append(",cause=").append(this.cause).append(",timestamp=").append(this.getTimeStamp());
        }
        if (this.vendorData != null) {
            buf.append(",vendor data=").append(this.vendorData);
        }
        buf.append("]");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        VendorExtensionUtils.writeObject(out, vendorDataSerializationEnabled ? this.vendorData : null);
        if (this.cause != null) {
            out.writeBoolean(true);
            out.writeObject(new MarshalledObject<Throwable>(this.cause));
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.cause.printStackTrace(pw);
            pw.flush();
            out.writeUTF(sw.getBuffer().toString());
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.vendorData = VendorExtensionUtils.readObject(in, vendorDataDeserializationEnabled);
        if (in.readBoolean()) {
            try {
                this.cause = (Throwable)((MarshalledObject)in.readObject()).get();
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            String causeString = in.readUTF();
            if (this.cause == null) {
                this.cause = new Exception("Undeserializable cause, original cause stack trace follows: " + causeString);
            }
        }
    }
}

