/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.LibraryID;
import javax.slee.management.VendorExtensionUtils;
import javax.slee.management.VendorExtensions;

public abstract class ComponentDescriptor
implements VendorExtensions,
Serializable {
    private final DeployableUnitID deployableUnit;
    private final ComponentID component;
    private final String source;
    private final LibraryID[] libraries;
    private static volatile boolean vendorDataSerializationEnabled = false;
    private static volatile boolean vendorDataDeserializationEnabled = false;
    private transient Object vendorData;

    protected ComponentDescriptor(ComponentID component, DeployableUnitID deployableUnit, String source, LibraryID[] libraries) {
        if (component == null) {
            throw new NullPointerException("component is null");
        }
        if (deployableUnit == null) {
            throw new NullPointerException("deployableUnit is null");
        }
        if (source == null) {
            throw new NullPointerException("source is null");
        }
        if (libraries == null) {
            throw new NullPointerException("libraries is null");
        }
        this.component = component;
        this.deployableUnit = deployableUnit;
        this.source = source;
        this.libraries = libraries;
    }

    public final DeployableUnitID getDeployableUnit() {
        return this.deployableUnit;
    }

    public final String getSource() {
        return this.source;
    }

    public final ComponentID getID() {
        return this.component;
    }

    public final String getName() {
        return this.component.getName();
    }

    public final String getVendor() {
        return this.component.getVendor();
    }

    public final String getVersion() {
        return this.component.getVersion();
    }

    public final LibraryID[] getLibraries() {
        return this.libraries;
    }

    public static void enableVendorDataSerialization() {
        vendorDataSerializationEnabled = true;
    }

    public static void disableVendorDataSerialization() {
        vendorDataSerializationEnabled = false;
    }

    public static void enableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = true;
    }

    public static void disableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = false;
    }

    public void setVendorData(Object vendorData) {
        this.vendorData = vendorData;
    }

    public Object getVendorData() {
        return this.vendorData;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ComponentDescriptor)) {
            return false;
        }
        return this.component.equals(((ComponentDescriptor)obj).component);
    }

    public final int hashCode() {
        return this.component.hashCode();
    }

    protected final void toString(StringBuffer buf) {
        buf.append("name=").append(this.component.getName()).append(",vendor=").append(this.component.getVendor()).append(",version=").append(this.component.getVersion()).append(",deployable unit=").append(this.deployableUnit).append(",source=").append(this.source).append(",libraries=").append(Arrays.asList(this.libraries));
        if (this.vendorData != null) {
            buf.append(",vendor data=").append(this.vendorData);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        VendorExtensionUtils.writeObject(out, vendorDataSerializationEnabled ? this.vendorData : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.vendorData = VendorExtensionUtils.readObject(in, vendorDataDeserializationEnabled);
    }
}

