/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.profile;

import java.io.Serializable;
import javax.slee.Address;
import javax.slee.AddressPlan;

public class ProfileID
implements Serializable,
Cloneable {
    private String profileTableName;
    private String profileName;
    private transient Address address;

    public ProfileID(String profileTableName, String profileName) throws NullPointerException, IllegalArgumentException {
        this.setProfileID(profileTableName, profileName);
    }

    public ProfileID(Address address) throws NullPointerException, IllegalArgumentException {
        if (address == null) {
            throw new NullPointerException("address is null");
        }
        if (!address.getAddressPlan().equals(AddressPlan.SLEE_PROFILE)) {
            throw new IllegalArgumentException("address must have the SLEE_PROFILE address plan");
        }
        String addressString = address.getAddressString();
        int div = addressString.indexOf(47);
        if (div < 0) {
            throw new IllegalArgumentException("address string does not contain a '/' seperator character");
        }
        this.profileTableName = addressString.substring(0, div);
        this.profileName = addressString.substring(div + 1);
        this.address = address;
    }

    public final String getProfileTableName() {
        return this.profileTableName;
    }

    public final String getProfileName() {
        return this.profileName;
    }

    public final void setProfileID(String profileTableName, String profileName) throws NullPointerException, IllegalArgumentException {
        if (profileTableName == null) {
            throw new NullPointerException("profileTableName is null");
        }
        if (profileName == null) {
            throw new NullPointerException("profileName is null");
        }
        if (profileTableName.indexOf(47) >= 0) {
            throw new IllegalArgumentException("profileTableName cannot contain the '/' character");
        }
        this.profileTableName = profileTableName;
        this.profileName = profileName;
        this.address = null;
    }

    public Address toAddress() {
        if (this.address == null) {
            this.address = new Address(AddressPlan.SLEE_PROFILE, this.profileTableName + '/' + this.profileName);
        }
        return this.address;
    }

    public Object clone() {
        return new ProfileID(this.profileTableName, this.profileName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProfileID)) {
            return false;
        }
        ProfileID that = (ProfileID)obj;
        return this.profileTableName.equals(that.profileTableName) && this.profileName.equals(that.profileName);
    }

    public int hashCode() {
        return this.profileTableName.hashCode() | this.profileName.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ProfileID[table=").append(this.profileTableName).append(",profile=").append(this.profileName).append("]");
        return buf.toString();
    }
}

