/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.profile.query;

import javax.slee.profile.query.GreaterThanOrEquals;
import javax.slee.profile.query.LessThanOrEquals;
import javax.slee.profile.query.QueryCollator;
import javax.slee.profile.query.QueryExpression;

public final class RangeMatch
extends QueryExpression {
    private final GreaterThanOrEquals lowerBound;
    private final LessThanOrEquals upperBound;

    public RangeMatch(String attrName, Object fromValue, Object toValue) {
        if (attrName == null) {
            throw new NullPointerException("attrName is null");
        }
        if (fromValue == null) {
            throw new NullPointerException("fromValue is null");
        }
        if (toValue == null) {
            throw new NullPointerException("toValue is null");
        }
        this.lowerBound = new GreaterThanOrEquals(attrName, fromValue);
        this.upperBound = new LessThanOrEquals(attrName, toValue);
    }

    public RangeMatch(String attrName, String fromValue, String toValue, QueryCollator collator) {
        if (fromValue == null) {
            throw new NullPointerException("fromValue is null");
        }
        if (toValue == null) {
            throw new NullPointerException("toValue is null");
        }
        this.lowerBound = new GreaterThanOrEquals(attrName, fromValue, collator);
        this.upperBound = new LessThanOrEquals(attrName, toValue, collator);
    }

    public String getAttributeName() {
        return this.lowerBound.getAttributeName();
    }

    public Object getFromValue() {
        return this.lowerBound.getAttributeValue();
    }

    public Object getToValue() {
        return this.upperBound.getAttributeValue();
    }

    public QueryCollator getCollator() {
        return this.lowerBound.getCollator();
    }

    protected void toString(StringBuffer buf) {
        buf.append(this.lowerBound.getAttributeValue()).append(" <= ").append(this.getAttributeName()).append(" <= ").append(this.upperBound.getAttributeValue());
    }
}

