/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.usage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.slee.management.VendorExtensionUtils;
import javax.slee.management.VendorExtensions;

public final class SampleStatistics
implements VendorExtensions,
Serializable {
    private final long sampleCount;
    private final long min;
    private final long max;
    private final double mean;
    private static volatile boolean vendorDataSerializationEnabled = false;
    private static volatile boolean vendorDataDeserializationEnabled = false;
    private transient Object vendorData;

    public SampleStatistics() {
        this(0L, Long.MAX_VALUE, Long.MIN_VALUE, 0.0);
    }

    public SampleStatistics(long sampleCount, long min, long max, double mean) {
        this.sampleCount = sampleCount;
        this.min = min;
        this.max = max;
        this.mean = mean;
    }

    public long getSampleCount() {
        return this.sampleCount;
    }

    public long getMinimum() {
        return this.min;
    }

    public long getMaximum() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public static void enableVendorDataSerialization() {
        vendorDataSerializationEnabled = true;
    }

    public static void disableVendorDataSerialization() {
        vendorDataSerializationEnabled = false;
    }

    public static void enableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = true;
    }

    public static void disableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = false;
    }

    public void setVendorData(Object vendorData) {
        this.vendorData = vendorData;
    }

    public Object getVendorData() {
        return this.vendorData;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SampleStatistics[sample count=").append(this.sampleCount);
        if (this.sampleCount > 0L) {
            buf.append(",min=").append(this.min).append(",max=").append(this.max).append(",mean=").append(this.mean);
        }
        if (this.vendorData != null) {
            buf.append(",vendor data=").append(this.vendorData);
        }
        buf.append(']');
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        VendorExtensionUtils.writeObject(out, vendorDataSerializationEnabled ? this.vendorData : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.vendorData = VendorExtensionUtils.readObject(in, vendorDataDeserializationEnabled);
    }
}

