/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.visrec.ml.ClassifierCreationException;
import javax.visrec.util.InvalidBuilderConfigurationException;

public interface Builder<T> {
    public T build() throws ClassifierCreationException;

    default public T build(Map<String, Object> configuration) throws ClassifierCreationException {
        Method[] methods;
        for (Method method : methods = this.getClass().getDeclaredMethods()) {
            if (method.getName().equals("build") || method.getParameterCount() != 1 || !configuration.containsKey(method.getName())) continue;
            try {
                method.invoke((Object)this, configuration.get(method.getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new InvalidBuilderConfigurationException("Couldn't invoke '" + method.getName() + "'", e);
            }
        }
        return this.build();
    }
}

