/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.visrec.ImageFactory;
import javax.visrec.ml.ClassificationException;
import javax.visrec.ml.classification.ImageClassifier;
import javax.visrec.spi.ServiceProvider;

public abstract class AbstractImageClassifier<IMAGE_CLASS, MODEL_CLASS>
implements ImageClassifier<IMAGE_CLASS> {
    private ImageFactory<IMAGE_CLASS> imageFactory;
    private MODEL_CLASS model;
    private float threshold = 0.5f;

    protected AbstractImageClassifier(Class<IMAGE_CLASS> imgCls, MODEL_CLASS model) {
        Optional<ImageFactory<IMAGE_CLASS>> optionalImageFactory = ServiceProvider.current().getImageFactoryService().getByImageType(imgCls);
        if (!optionalImageFactory.isPresent()) {
            throw new IllegalArgumentException(String.format("Could not find ImageFactory by '%s'", BufferedImage.class.getName()));
        }
        this.imageFactory = optionalImageFactory.get();
        this.setModel(model);
    }

    public ImageFactory<IMAGE_CLASS> getImageFactory() {
        return this.imageFactory;
    }

    @Override
    public Map<String, Float> classify(File file) throws ClassificationException {
        IMAGE_CLASS image;
        try {
            image = this.imageFactory.getImage(file);
        }
        catch (IOException e) {
            throw new ClassificationException("Couldn't transform input into a BufferedImage", e);
        }
        return (Map)this.classify(image);
    }

    @Override
    public Map<String, Float> classify(InputStream inputStream) throws ClassificationException {
        IMAGE_CLASS image;
        try {
            image = this.imageFactory.getImage(inputStream);
        }
        catch (IOException e) {
            throw new ClassificationException("Couldn't transform input into a BufferedImage", e);
        }
        return (Map)this.classify(image);
    }

    public MODEL_CLASS getModel() {
        return this.model;
    }

    public final void setModel(MODEL_CLASS model) {
        this.model = Objects.requireNonNull(model, "Model cannot bu null!");
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }
}

