/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec.ml.classification;

import java.io.File;
import java.util.Map;
import javax.visrec.ml.ClassifierCreationException;
import javax.visrec.ml.classification.BinaryClassifier;
import javax.visrec.spi.ServiceProvider;

public interface NeuralNetBinaryClassifier<T>
extends BinaryClassifier<T> {
    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private BuildingBlock<T> block;

        private Builder() {
            this(new BuildingBlock());
        }

        private Builder(BuildingBlock<T> block) {
            this.block = block;
        }

        public <R> Builder<R> inputClass(Class<R> cls) {
            BuildingBlock newBlock = BuildingBlock.copyWithNewTargetClass((BuildingBlock)this.block, cls);
            return new Builder<T>(newBlock);
        }

        public Builder<T> inputsNum(int inputsNum) {
            ((BuildingBlock)this.block).inputsNum = inputsNum;
            return this;
        }

        public Builder<T> hiddenLayers(int ... hiddenLayers) {
            BuildingBlock.access$402(this.block, hiddenLayers);
            return this;
        }

        public Builder<T> maxError(float maxError) {
            ((BuildingBlock)this.block).maxError = maxError;
            return this;
        }

        public Builder<T> maxEpochs(int maxEpochs) {
            ((BuildingBlock)this.block).maxEpochs = maxEpochs;
            return this;
        }

        public Builder<T> learningRate(float learningRate) {
            ((BuildingBlock)this.block).learningRate = learningRate;
            return this;
        }

        public Builder<T> trainingFile(File trainingFile) {
            ((BuildingBlock)this.block).trainingFile = trainingFile;
            return this;
        }

        public BuildingBlock<T> getBuildingBlock() {
            return this.block;
        }

        public BinaryClassifier<T> build() throws ClassifierCreationException {
            return ServiceProvider.current().getClassifierFactoryService().createNeuralNetBinaryClassifier(this.block);
        }

        public BinaryClassifier<T> build(Map<String, Object> configuration) throws ClassifierCreationException {
            throw new IllegalStateException("not implemented yet");
        }
    }

    public static class BuildingBlock<T> {
        private Class<T> inputCls;
        private int inputsNum;
        private int[] hiddenLayers;
        private float maxError;
        private int maxEpochs;
        private float learningRate;
        private File trainingFile;

        private BuildingBlock() {
        }

        public Class<T> getInputClass() {
            return this.inputCls;
        }

        public int getInputsNum() {
            return this.inputsNum;
        }

        public int[] getHiddenLayers() {
            return this.hiddenLayers;
        }

        public float getMaxError() {
            return this.maxError;
        }

        public int getMaxEpochs() {
            return this.maxEpochs;
        }

        public float getLearningRate() {
            return this.learningRate;
        }

        public File getTrainingFile() {
            return this.trainingFile;
        }

        private static <R> BuildingBlock<R> copyWithNewTargetClass(BuildingBlock<?> block, Class<R> cls) {
            BuildingBlock newBlock = new BuildingBlock();
            newBlock.inputCls = cls;
            newBlock.inputsNum = block.inputsNum;
            newBlock.hiddenLayers = block.hiddenLayers;
            newBlock.maxError = block.maxError;
            newBlock.maxEpochs = block.maxEpochs;
            newBlock.learningRate = block.learningRate;
            newBlock.trainingFile = block.trainingFile;
            return newBlock;
        }

        static /* synthetic */ int[] access$402(BuildingBlock x0, int[] x1) {
            x0.hiddenLayers = x1;
            return x1;
        }
    }
}

