/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec.ml.classification;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Map;
import javax.visrec.ml.ClassifierCreationException;
import javax.visrec.ml.classification.ImageClassifier;
import javax.visrec.spi.ServiceProvider;

public interface NeuralNetImageClassifier<T>
extends ImageClassifier<T> {
    public static <IMAGE_CLASS> Builder<IMAGE_CLASS> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private BuildingBlock<T> block;

        private Builder() {
            this.block = new BuildingBlock();
        }

        private Builder(BuildingBlock<T> block) {
            this.block = block;
        }

        public <R> Builder<R> inputClass(Class<R> cls) {
            BuildingBlock newBlock = BuildingBlock.copyWithNewInputClass((BuildingBlock)this.block, cls);
            return new Builder<T>(newBlock);
        }

        public Builder<T> imageWidth(int imageWidth) {
            ((BuildingBlock)this.block).imageWidth = imageWidth;
            return this;
        }

        public Builder<T> imageHeight(int imageHeight) {
            ((BuildingBlock)this.block).imageHeight = imageHeight;
            return this;
        }

        public Builder<T> trainingFile(File trainingFile) {
            ((BuildingBlock)this.block).trainingFile = trainingFile;
            return this;
        }

        public Builder<T> labelsFile(File labelsFile) {
            ((BuildingBlock)this.block).labelsFile = labelsFile;
            return this;
        }

        public Builder<T> maxError(float maxError) {
            ((BuildingBlock)this.block).maxError = maxError;
            return this;
        }

        public Builder<T> maxEpochs(int epochs) {
            ((BuildingBlock)this.block).maxEpochs = epochs;
            return this;
        }

        public Builder<T> learningRate(float learningRate) {
            ((BuildingBlock)this.block).learningRate = learningRate;
            return this;
        }

        public Builder<T> exportModel(Path path) {
            ((BuildingBlock)this.block).exportPath = path;
            return this;
        }

        public Builder<T> importModel(Path path) {
            ((BuildingBlock)this.block).importPath = path;
            return this;
        }

        public Builder<T> networkArchitecture(File architecture) {
            ((BuildingBlock)this.block).networkArchitecture = architecture;
            return this;
        }

        public BuildingBlock getBuildingBlock() {
            return this.block;
        }

        public ImageClassifier<T> build() throws ClassifierCreationException {
            return ServiceProvider.current().getClassifierFactoryService().createNeuralNetImageClassifier(this.block);
        }

        public ImageClassifier<T> build(Map<String, Object> configuration) throws ClassifierCreationException {
            Method[] methods;
            for (Method method : methods = this.getClass().getDeclaredMethods()) {
                if (method.getName().equals("build") || method.getParameterCount() != 1 || !configuration.containsKey(method.getName())) continue;
                try {
                    Object value = configuration.get(method.getName());
                    Class<?> expectedParameterType = method.getParameterTypes()[0];
                    if ((expectedParameterType.equals(Integer.TYPE) || expectedParameterType.equals(Integer.class)) && value instanceof String) {
                        method.invoke((Object)this, Integer.parseInt((String)value));
                        continue;
                    }
                    if ((expectedParameterType.equals(Float.TYPE) || expectedParameterType.equals(Float.class)) && value instanceof String) {
                        method.invoke((Object)this, Float.valueOf(Float.parseFloat((String)value)));
                        continue;
                    }
                    if (expectedParameterType.equals(File.class) && value instanceof String) {
                        method.invoke((Object)this, new File((String)value));
                        continue;
                    }
                    method.invoke((Object)this, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new ClassifierCreationException("Couldn't invoke '" + method.getName() + "'", e);
                }
            }
            return this.build();
        }
    }

    public static class BuildingBlock<T> {
        private int imageWidth;
        private int imageHeight;
        private File networkArchitecture;
        private File trainingFile;
        private File labelsFile;
        private float maxError;
        private float learningRate;
        private Path exportPath;
        private Path importPath;
        private int maxEpochs;
        private Class<T> inputCls;

        private BuildingBlock() {
        }

        public File getNetworkArchitecture() {
            return this.networkArchitecture;
        }

        public int getImageWidth() {
            return this.imageWidth;
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public File getTrainingFile() {
            return this.trainingFile;
        }

        public File getLabelsFile() {
            return this.labelsFile;
        }

        public float getMaxError() {
            return this.maxError;
        }

        public float getLearningRate() {
            return this.learningRate;
        }

        public Path getExportPath() {
            return this.exportPath;
        }

        public Path getImportPath() {
            return this.importPath;
        }

        public int getMaxEpochs() {
            return this.maxEpochs;
        }

        public Class<T> getInputClass() {
            return this.inputCls;
        }

        private static <R> BuildingBlock<R> copyWithNewInputClass(BuildingBlock<?> block, Class<R> cls) {
            BuildingBlock newBlock = new BuildingBlock();
            newBlock.inputCls = cls;
            newBlock.imageHeight = block.imageHeight;
            newBlock.imageWidth = block.imageWidth;
            newBlock.labelsFile = block.labelsFile;
            newBlock.exportPath = block.exportPath;
            newBlock.importPath = block.importPath;
            newBlock.networkArchitecture = block.networkArchitecture;
            newBlock.maxError = block.maxError;
            newBlock.maxEpochs = block.maxEpochs;
            newBlock.learningRate = block.learningRate;
            newBlock.trainingFile = block.trainingFile;
            return newBlock;
        }
    }
}

