/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec.ml.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.visrec.ml.data.DataSet;

public class BasicDataSet<E>
implements DataSet<E> {
    protected List<E> items;
    private DataSet.Column[] columns;

    protected BasicDataSet() {
        this.items = new ArrayList();
    }

    public BasicDataSet(DataSet.Column[] cols) {
        this.columns = cols;
        this.items = new ArrayList();
    }

    public BasicDataSet(List<E> elements) {
        this.items = elements;
    }

    @Override
    public List<E> getItems() {
        return this.items;
    }

    @Override
    public String[] getTargetNames() {
        List<String> targetLabels = Arrays.asList(this.columns).stream().filter(col -> col.isTarget()).map(col -> col.getName()).collect(Collectors.toList());
        return targetLabels.toArray(new String[0]);
    }

    @Override
    public void setColumnNames(String[] columnNames) {
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = new DataSet.Column(columnNames[i]);
        }
    }

    @Override
    public String[] getColumnNames() {
        String[] colNames = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            colNames[i] = this.columns[i].getName();
        }
        return colNames;
    }

    @Override
    public DataSet<E>[] split(double ... parts) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

