/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.visrec.spi.BuilderService;
import javax.visrec.spi.ClassifierFactoryService;
import javax.visrec.spi.ImageFactoryService;
import javax.visrec.spi.ImplementationService;

public abstract class ServiceProvider {
    private static final Object LOCK = new Object();
    private static List<ServiceProvider> providers;

    protected ServiceProvider() {
    }

    public int getPriority() {
        return 0;
    }

    @Deprecated
    public abstract BuilderService getBuilderService();

    public ClassifierFactoryService getClassifierFactoryService() {
        return ClassifierFactoryService.getInstance();
    }

    public abstract ImageFactoryService getImageFactoryService();

    public abstract ImplementationService getImplementationService();

    public static ServiceProvider current() {
        if (ServiceProvider.available().size() == 0) {
            throw new IllegalStateException("No service provider found");
        }
        return ServiceProvider.available().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrent(ServiceProvider provider) {
        Objects.requireNonNull(provider);
        Object object = LOCK;
        synchronized (object) {
            List<ServiceProvider> foundProviders = ServiceProvider.available();
            if (foundProviders.isEmpty()) {
                throw new IllegalStateException("No providers found.");
            }
            if (!foundProviders.contains(provider)) {
                throw new IllegalArgumentException("ServiceProvider given through the parameters is not known.");
            }
            ArrayList<ServiceProvider> copiedProviders = new ArrayList<ServiceProvider>();
            Collections.copy(copiedProviders, foundProviders);
            copiedProviders.remove(provider);
            copiedProviders.add(0, provider);
            copiedProviders.trimToSize();
            providers = Collections.unmodifiableList(copiedProviders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ServiceProvider> available() {
        if (Objects.isNull(providers)) {
            Object object = LOCK;
            synchronized (object) {
                if (Objects.nonNull(providers)) {
                    return providers;
                }
                ServiceLoader<ServiceProvider> serviceLoader = ServiceLoader.load(ServiceProvider.class);
                ArrayList<ServiceProvider> localProviders = new ArrayList<ServiceProvider>();
                for (ServiceProvider provider : serviceLoader) {
                    localProviders.add(provider);
                }
                localProviders.trimToSize();
                localProviders.sort((p1, p2) -> p2.getPriority() - p1.getPriority());
                providers = Collections.unmodifiableList(localProviders);
            }
        }
        return providers;
    }
}

