/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec.ml.classification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.visrec.ml.classification.Classifier;

public final class EnsambleClassifier<T, R>
implements Classifier<T, R> {
    private final Map<String, Classifier<T, R>> classifiers = new HashMap<String, Classifier<T, R>>();

    @Override
    public R classify(T input) {
        ArrayList<R> results = new ArrayList<R>();
        HashMap<String, Integer> freqCount = new HashMap<String, Integer>();
        int maxFreq = 0;
        R maxClass = null;
        for (Map.Entry<String, Classifier<T, R>> classifier : this.classifiers.entrySet()) {
            R result = classifier.getValue().classify(input);
            results.add(result);
            if (freqCount.containsKey(result)) {
                freqCount.put(result.toString(), (Integer)freqCount.get(result.toString()) + 1);
            } else {
                freqCount.put(result.toString(), 1);
            }
            if ((Integer)freqCount.get(result.toString()) <= maxFreq) continue;
            maxFreq = (Integer)freqCount.get(result.toString());
            maxClass = result;
        }
        return maxClass;
    }

    public EnsambleClassifier addClassifier(String classifierId, Classifier<T, R> classifier) {
        this.classifiers.put(classifierId, classifier);
        return this;
    }

    public Classifier getClassifier(String classiferId) {
        return this.classifiers.get(classiferId);
    }

    public void remove(String classifierId) {
        this.classifiers.remove(classifierId);
    }
}

