/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;

public final class Link {
    public static final String CONSUMES = "consumes";
    public static final String METHOD = "method";
    public static final String PRODUCES = "produces";
    public static final String TITLE = "title";
    public static final String REL = "rel";
    public static final String TYPE = "type";
    private URI uri;
    private MultivaluedMap<String, String> map = new MultivaluedHashMap<String, String>();
    private static final RuntimeDelegate.HeaderDelegate<Link> delegate = RuntimeDelegate.getInstance().createHeaderDelegate(Link.class);

    public URI getUri() {
        return this.uri;
    }

    public UriBuilder getUriBuilder() {
        return UriBuilder.fromUri(this.uri);
    }

    public List<String> getRel() {
        List l = (List)this.map.get(REL);
        return l != null ? new ArrayList(l) : Collections.emptyList();
    }

    public String getTitle() {
        return this.map.getFirst(TITLE);
    }

    public String getType() {
        return this.map.getFirst(TYPE);
    }

    public String getMethod() {
        return this.map.getFirst(METHOD);
    }

    public List<String> getProduces() {
        List l = (List)this.map.get(PRODUCES);
        return l != null ? new ArrayList(l) : Collections.emptyList();
    }

    public List<String> getConsumes() {
        List l = (List)this.map.get(CONSUMES);
        return l != null ? new ArrayList(l) : Collections.emptyList();
    }

    public MultivaluedMap<String, String> getParams() {
        return new MultivaluedHashMap<String, String>(this.map);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Link) {
            Link olink = (Link)other;
            return this.uri.equals(olink.uri) && this.map.equals(olink.map);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        hash = 89 * hash + (this.map != null ? this.map.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return delegate.toString(this);
    }

    public static Link valueOf(String value) throws IllegalArgumentException {
        return delegate.fromString(value);
    }

    public static Builder fromUri(URI uri) throws IllegalArgumentException {
        Builder b = new Builder();
        b.uri(uri);
        return b;
    }

    public static Builder fromUri(String uri) throws IllegalArgumentException {
        Builder b = new Builder();
        b.uri(uri);
        return b;
    }

    public static Builder fromLink(Link link) {
        Builder b = new Builder();
        b.uri(link.uri);
        ((Builder)b).link.map = new MultivaluedHashMap<String, String>(link.map);
        return b;
    }

    public static Builder fromResourceMethod(Class<?> resource, String method) throws IllegalArgumentException {
        return Link.fromResourceMethod(resource, method, method);
    }

    public static Builder fromResourceMethod(Class<?> resource, String method, String rel) throws IllegalArgumentException {
        Method[] methods;
        if (resource == null || method == null || rel == null) {
            throw new IllegalArgumentException("All parameters must be non-null");
        }
        Builder lb = Link.fromUri(UriBuilder.fromResource(resource).build(new Object[0]));
        lb.rel(rel);
        for (Method m : methods = resource.getMethods()) {
            if (!m.getName().equals(method)) continue;
            String httpMethod = null;
            for (Annotation a : m.getAnnotations()) {
                Class<? extends Annotation> at = a.annotationType();
                HttpMethod hm = at.getAnnotation(HttpMethod.class);
                if (hm == null) continue;
                httpMethod = at.getSimpleName();
                lb.method(httpMethod);
                break;
            }
            if (httpMethod == null) {
                throw new IllegalArgumentException("Unable to find HTTP method annotation in " + method);
            }
            Produces ps = m.getAnnotation(Produces.class);
            if (ps == null) {
                lb.produces("*/*");
            } else {
                for (String p : ps.value()) {
                    lb.produces(p);
                }
            }
            Consumes cs = m.getAnnotation(Consumes.class);
            if (cs == null) {
                if (httpMethod.equals("POST") || httpMethod.equals("PUT")) {
                    lb.consumes("*/*");
                }
            } else {
                for (String c : cs.value()) {
                    lb.consumes(c);
                }
            }
            return lb;
        }
        throw new IllegalArgumentException("Method '" + method + "' not found in class '" + resource.getName() + "'");
    }

    public static class JaxbAdapter
    extends XmlAdapter<JaxbLink, Link> {
        public Link unmarshal(JaxbLink v) throws Exception {
            Builder lb = Link.fromUri(v.getUri());
            for (Map.Entry<QName, Object> e : v.getParams().entrySet()) {
                String[] values;
                String name = e.getKey().getLocalPart();
                if (Link.TITLE.equals(name) || Link.METHOD.equals(name)) {
                    lb.param(name, e.getValue().toString());
                    continue;
                }
                for (String value : values = e.getValue().toString().split(" ")) {
                    lb.param(name, value);
                }
            }
            return lb.build();
        }

        public JaxbLink marshal(Link v) throws Exception {
            JaxbLink jl = new JaxbLink(v.getUri());
            for (Map.Entry e : v.getParams().entrySet()) {
                String name = (String)e.getKey();
                if (Link.TITLE.equals(name) || Link.METHOD.equals(name)) {
                    jl.getParams().put(new QName("", name), ((List)e.getValue()).get(0));
                    continue;
                }
                boolean first = true;
                StringBuilder sb = new StringBuilder();
                for (String value : (List)e.getValue()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(" ");
                    }
                    sb.append(value);
                }
                jl.getParams().put(new QName("", (String)e.getKey()), sb.toString());
            }
            return jl;
        }
    }

    public static class JaxbLink {
        private URI uri;
        private Map<QName, Object> params;

        public JaxbLink() {
        }

        public JaxbLink(URI uri) {
            this.uri = uri;
        }

        public JaxbLink(URI uri, Map<QName, Object> params) {
            this.uri = uri;
            this.params = params;
        }

        @XmlAttribute(name="href")
        public URI getUri() {
            return this.uri;
        }

        @XmlAnyAttribute
        public Map<QName, Object> getParams() {
            if (this.params == null) {
                this.params = new HashMap<QName, Object>();
            }
            return this.params;
        }
    }

    public static class Builder {
        private Link link = new Link();
        private UriBuilder uriBuilder;

        public Builder uri(URI uri) {
            this.uriBuilder = UriBuilder.fromUri(uri);
            return this;
        }

        public Builder uri(String uri) throws IllegalArgumentException {
            this.uriBuilder = UriBuilder.fromUri(uri);
            return this;
        }

        public Builder rel(String name) {
            this.link.map.add(Link.REL, name);
            return this;
        }

        public Builder title(String title) {
            this.link.map.putSingle(Link.TITLE, title);
            return this;
        }

        public Builder type(String type) {
            this.link.map.add(Link.TYPE, type);
            return this;
        }

        public Builder method(String method) {
            this.link.map.putSingle(Link.METHOD, method);
            return this;
        }

        public Builder produces(String type) {
            this.link.map.add(Link.PRODUCES, type);
            return this;
        }

        public Builder consumes(String type) {
            this.link.map.add(Link.CONSUMES, type);
            return this;
        }

        public Builder param(String name, String value) throws IllegalArgumentException {
            if (name == null || value == null) {
                throw new IllegalArgumentException("Link parameter name or value is null");
            }
            this.link.map.add(name, value);
            return this;
        }

        public Link build() {
            this.link.uri = this.uriBuilder.build(new Object[0]);
            return this.link;
        }

        public Link build(Object ... values) throws UriBuilderException {
            this.link.uri = this.uriBuilder.build(values);
            return this.link;
        }
    }
}

