/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl;

import com.sun.org.apache.xerces.internal.impl.XML11EntityScanner;
import com.sun.org.apache.xerces.internal.impl.XMLEntityHandler;
import com.sun.org.apache.xerces.internal.impl.XMLEntityScanner;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.io.ASCIIReader;
import com.sun.org.apache.xerces.internal.impl.io.UCSReader;
import com.sun.org.apache.xerces.internal.impl.io.UTF8Reader;
import com.sun.org.apache.xerces.internal.impl.validation.ValidationManager;
import com.sun.org.apache.xerces.internal.util.AugmentationsImpl;
import com.sun.org.apache.xerces.internal.util.EncodingMap;
import com.sun.org.apache.xerces.internal.util.SecurityManager;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.URI;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.util.XMLEntityDescriptionImpl;
import com.sun.org.apache.xerces.internal.util.XMLResourceIdentifierImpl;
import com.sun.org.apache.xerces.internal.xinclude.XIncludeInputSource;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.XMLResourceIdentifier;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;

public class XMLEntityManager
implements XMLComponent,
XMLEntityResolver {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final int DEFAULT_XMLDECL_BUFFER_SIZE = 64;
    public static final int DEFAULT_INTERNAL_BUFFER_SIZE = 1024;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String WARN_ON_DUPLICATE_ENTITYDEF = "http://apache.org/xml/features/warn-on-duplicate-entitydef";
    protected static final String STANDARD_URI_CONFORMANT = "http://apache.org/xml/features/standard-uri-conformant";
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String BUFFER_SIZE = "http://apache.org/xml/properties/input-buffer-size";
    protected static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/warn-on-duplicate-entitydef", "http://apache.org/xml/features/standard-uri-conformant"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/input-buffer-size", "http://apache.org/xml/properties/security-manager"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null, null, new Integer(2048), null};
    private static final String XMLEntity = "[xml]".intern();
    private static final String DTDEntity = "[dtd]".intern();
    private static final boolean DEBUG_BUFFER = false;
    private static final boolean DEBUG_ENTITIES = false;
    private static final boolean DEBUG_ENCODINGS = false;
    private static final boolean DEBUG_RESOLVER = false;
    protected boolean fValidation;
    protected boolean fExternalGeneralEntities = true;
    protected boolean fExternalParameterEntities = true;
    protected boolean fAllowJavaEncodings;
    protected boolean fWarnDuplicateEntityDef;
    protected boolean fStrictURI;
    protected boolean fCharsetOverrideXmlEncoding;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected ValidationManager fValidationManager;
    protected int fBufferSize = 2048;
    protected SecurityManager fSecurityManager = null;
    protected boolean fStandalone;
    protected boolean fInExternalSubset = false;
    protected XMLEntityHandler fEntityHandler;
    protected XMLEntityScanner fEntityScanner;
    protected XMLEntityScanner fXML10EntityScanner;
    protected XMLEntityScanner fXML11EntityScanner;
    protected int fEntityExpansionLimit = 0;
    protected int fEntityExpansionCount = 0;
    protected Hashtable fEntities = new Hashtable();
    protected Stack fEntityStack = new Stack();
    protected ScannedEntity fCurrentEntity;
    protected Hashtable fDeclaredEntities;
    private final XMLResourceIdentifierImpl fResourceIdentifier = new XMLResourceIdentifierImpl();
    private final Augmentations fEntityAugs = new AugmentationsImpl();
    protected Stack fReaderStack = new Stack();
    private static String gUserDir;
    private static String gEscapedUserDir;
    private static boolean[] gNeedEscaping;
    private static char[] gAfterEscaping1;
    private static char[] gAfterEscaping2;
    private static char[] gHexChs;

    public XMLEntityManager() {
        this(null);
    }

    public XMLEntityManager(XMLEntityManager entityManager) {
        this.fDeclaredEntities = entityManager != null ? entityManager.getDeclaredEntities() : null;
        this.setScannerVersion((short)1);
    }

    public void setStandalone(boolean standalone) {
        this.fStandalone = standalone;
    }

    public boolean isStandalone() {
        return this.fStandalone;
    }

    public void setEntityHandler(XMLEntityHandler entityHandler) {
        this.fEntityHandler = entityHandler;
    }

    public XMLResourceIdentifier getCurrentResourceIdentifier() {
        return this.fResourceIdentifier;
    }

    public ScannedEntity getCurrentEntity() {
        return this.fCurrentEntity;
    }

    public void addInternalEntity(String name, String text) {
        if (!this.fEntities.containsKey(name)) {
            InternalEntity entity = new InternalEntity(name, text, this.fInExternalSubset);
            this.fEntities.put(name, entity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{name}, (short)0);
        }
    }

    public void addExternalEntity(String name, String publicId, String literalSystemId, String baseSystemId) throws IOException {
        if (!this.fEntities.containsKey(name)) {
            if (baseSystemId == null) {
                int size = this.fEntityStack.size();
                if (size == 0 && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null) {
                    baseSystemId = this.fCurrentEntity.entityLocation.getExpandedSystemId();
                }
                for (int i = size - 1; i >= 0; --i) {
                    ScannedEntity externalEntity = (ScannedEntity)this.fEntityStack.elementAt(i);
                    if (externalEntity.entityLocation == null || externalEntity.entityLocation.getExpandedSystemId() == null) continue;
                    baseSystemId = externalEntity.entityLocation.getExpandedSystemId();
                    break;
                }
            }
            ExternalEntity entity = new ExternalEntity(name, new XMLEntityDescriptionImpl(name, publicId, literalSystemId, baseSystemId, XMLEntityManager.expandSystemId(literalSystemId, baseSystemId, false)), null, this.fInExternalSubset);
            this.fEntities.put(name, entity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{name}, (short)0);
        }
    }

    public boolean isExternalEntity(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            return false;
        }
        return entity.isExternal();
    }

    public boolean isEntityDeclInExternalSubset(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            return false;
        }
        return entity.isEntityDeclInExternalSubset();
    }

    public void addUnparsedEntity(String name, String publicId, String systemId, String baseSystemId, String notation) {
        if (!this.fEntities.containsKey(name)) {
            ExternalEntity entity = new ExternalEntity(name, new XMLEntityDescriptionImpl(name, publicId, systemId, baseSystemId, null), notation, this.fInExternalSubset);
            this.fEntities.put(name, entity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{name}, (short)0);
        }
    }

    public boolean isUnparsedEntity(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            return false;
        }
        return entity.isUnparsed();
    }

    public boolean isDeclaredEntity(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        return entity != null;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws IOException, XNIException {
        boolean needExpand;
        if (resourceIdentifier == null) {
            return null;
        }
        String publicId = resourceIdentifier.getPublicId();
        String literalSystemId = resourceIdentifier.getLiteralSystemId();
        String baseSystemId = resourceIdentifier.getBaseSystemId();
        String expandedSystemId = resourceIdentifier.getExpandedSystemId();
        boolean bl = needExpand = expandedSystemId == null;
        if (baseSystemId == null && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null && (baseSystemId = this.fCurrentEntity.entityLocation.getExpandedSystemId()) != null) {
            needExpand = true;
        }
        if (needExpand) {
            expandedSystemId = XMLEntityManager.expandSystemId(literalSystemId, baseSystemId, false);
        }
        XMLInputSource xmlInputSource = null;
        if (this.fEntityResolver != null) {
            resourceIdentifier.setBaseSystemId(baseSystemId);
            resourceIdentifier.setExpandedSystemId(expandedSystemId);
            xmlInputSource = this.fEntityResolver.resolveEntity(resourceIdentifier);
        }
        if (xmlInputSource == null) {
            xmlInputSource = new XMLInputSource(publicId, literalSystemId, baseSystemId);
        }
        return xmlInputSource;
    }

    public void startEntity(String entityName, boolean literal) throws IOException, XNIException {
        int size;
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            if (this.fEntityHandler != null) {
                String encoding = null;
                this.fResourceIdentifier.clear();
                this.fEntityAugs.removeAllItems();
                this.fEntityAugs.putItem("ENTITY_SKIPPED", Boolean.TRUE);
                this.fEntityHandler.startEntity(entityName, this.fResourceIdentifier, encoding, this.fEntityAugs);
                this.fEntityAugs.removeAllItems();
                this.fEntityAugs.putItem("ENTITY_SKIPPED", Boolean.TRUE);
                this.fEntityHandler.endEntity(entityName, this.fEntityAugs);
            }
            return;
        }
        boolean external = entity.isExternal();
        if (external && (this.fValidationManager == null || !this.fValidationManager.isCachedDTD())) {
            boolean general;
            boolean unparsed = entity.isUnparsed();
            boolean parameter = entityName.startsWith("%");
            boolean bl = general = !parameter;
            if (unparsed || general && !this.fExternalGeneralEntities || parameter && !this.fExternalParameterEntities) {
                if (this.fEntityHandler != null) {
                    this.fResourceIdentifier.clear();
                    String encoding = null;
                    ExternalEntity externalEntity = (ExternalEntity)entity;
                    String extLitSysId = externalEntity.entityLocation != null ? externalEntity.entityLocation.getLiteralSystemId() : null;
                    String extBaseSysId = externalEntity.entityLocation != null ? externalEntity.entityLocation.getBaseSystemId() : null;
                    String expandedSystemId = XMLEntityManager.expandSystemId(extLitSysId, extBaseSysId, false);
                    this.fResourceIdentifier.setValues(externalEntity.entityLocation != null ? externalEntity.entityLocation.getPublicId() : null, extLitSysId, extBaseSysId, expandedSystemId);
                    this.fEntityAugs.removeAllItems();
                    this.fEntityAugs.putItem("ENTITY_SKIPPED", Boolean.TRUE);
                    this.fEntityHandler.startEntity(entityName, this.fResourceIdentifier, encoding, this.fEntityAugs);
                    this.fEntityAugs.removeAllItems();
                    this.fEntityAugs.putItem("ENTITY_SKIPPED", Boolean.TRUE);
                    this.fEntityHandler.endEntity(entityName, this.fEntityAugs);
                }
                return;
            }
        }
        for (int i = size = this.fEntityStack.size(); i >= 0; --i) {
            Entity activeEntity;
            Entity entity2 = activeEntity = i == size ? this.fCurrentEntity : (Entity)this.fEntityStack.elementAt(i);
            if (activeEntity.name != entityName) continue;
            String path = entityName;
            for (int j = i + 1; j < size; ++j) {
                activeEntity = (Entity)this.fEntityStack.elementAt(j);
                path = path + " -> " + activeEntity.name;
            }
            path = path + " -> " + this.fCurrentEntity.name;
            path = path + " -> " + entityName;
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "RecursiveReference", new Object[]{entityName, path}, (short)2);
            if (this.fEntityHandler != null) {
                this.fResourceIdentifier.clear();
                String encoding = null;
                if (external) {
                    ExternalEntity externalEntity = (ExternalEntity)entity;
                    String extLitSysId = externalEntity.entityLocation != null ? externalEntity.entityLocation.getLiteralSystemId() : null;
                    String extBaseSysId = externalEntity.entityLocation != null ? externalEntity.entityLocation.getBaseSystemId() : null;
                    String expandedSystemId = XMLEntityManager.expandSystemId(extLitSysId, extBaseSysId, false);
                    this.fResourceIdentifier.setValues(externalEntity.entityLocation != null ? externalEntity.entityLocation.getPublicId() : null, extLitSysId, extBaseSysId, expandedSystemId);
                }
                this.fEntityAugs.removeAllItems();
                this.fEntityAugs.putItem("ENTITY_SKIPPED", Boolean.TRUE);
                this.fEntityHandler.startEntity(entityName, this.fResourceIdentifier, encoding, this.fEntityAugs);
                this.fEntityAugs.removeAllItems();
                this.fEntityAugs.putItem("ENTITY_SKIPPED", Boolean.TRUE);
                this.fEntityHandler.endEntity(entityName, this.fEntityAugs);
            }
            return;
        }
        XMLInputSource xmlInputSource = null;
        if (external) {
            ExternalEntity externalEntity = (ExternalEntity)entity;
            xmlInputSource = this.resolveEntity(externalEntity.entityLocation);
        } else {
            InternalEntity internalEntity = (InternalEntity)entity;
            StringReader reader = new StringReader(internalEntity.text);
            xmlInputSource = new XMLInputSource(null, null, null, reader, null);
        }
        this.startEntity(entityName, xmlInputSource, literal, external);
    }

    public void startDocumentEntity(XMLInputSource xmlInputSource) throws IOException, XNIException {
        this.startEntity(XMLEntity, xmlInputSource, false, true);
    }

    public void startDTDEntity(XMLInputSource xmlInputSource) throws IOException, XNIException {
        this.startEntity(DTDEntity, xmlInputSource, false, true);
    }

    public void startExternalSubset() {
        this.fInExternalSubset = true;
    }

    public void endExternalSubset() {
        this.fInExternalSubset = false;
    }

    public void startEntity(String name, XMLInputSource xmlInputSource, boolean literal, boolean isExternal) throws IOException, XNIException {
        String encoding = this.setupCurrentEntity(name, xmlInputSource, literal, isExternal);
        ++this.fEntityExpansionCount;
        if (this.fSecurityManager != null && this.fEntityExpansionCount > this.fEntityExpansionLimit) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityExpansionLimitExceeded", new Object[]{new Integer(this.fEntityExpansionLimit)}, (short)2);
            this.fEntityExpansionCount = 0;
        }
        if (this.fEntityHandler != null) {
            this.fEntityHandler.startEntity(name, this.fResourceIdentifier, encoding, null);
        }
    }

    public String setupCurrentEntity(String name, XMLInputSource xmlInputSource, boolean literal, boolean isExternal) throws IOException, XNIException {
        String publicId = xmlInputSource.getPublicId();
        String literalSystemId = xmlInputSource.getSystemId();
        String baseSystemId = xmlInputSource.getBaseSystemId();
        String encoding = xmlInputSource.getEncoding();
        Boolean isBigEndian = null;
        boolean declaredEncoding = false;
        InputStream stream = null;
        Reader reader = xmlInputSource.getCharacterStream();
        String expandedSystemId = XMLEntityManager.expandSystemId(literalSystemId, baseSystemId, this.fStrictURI);
        if (baseSystemId == null) {
            baseSystemId = expandedSystemId;
        }
        if (reader == null) {
            Object[] b4;
            stream = xmlInputSource.getByteStream();
            if (stream != null && encoding != null) {
                declaredEncoding = true;
            }
            if (stream == null) {
                String redirect;
                URL location = new URL(expandedSystemId);
                URLConnection connect = location.openConnection();
                if (connect instanceof HttpURLConnection) {
                    this.setHttpProperties(connect, xmlInputSource);
                }
                stream = connect.getInputStream();
                if (connect instanceof HttpURLConnection && !(redirect = connect.getURL().toString()).equals(expandedSystemId)) {
                    literalSystemId = redirect;
                    expandedSystemId = redirect;
                }
            }
            stream = new RewindableInputStream(stream);
            if (encoding == null) {
                int count;
                b4 = new byte[4];
                for (count = 0; count < 4; ++count) {
                    b4[count] = (byte)stream.read();
                }
                if (count == 4) {
                    Object[] encodingDesc = this.getEncodingName((byte[])b4, count);
                    encoding = (String)encodingDesc[0];
                    isBigEndian = (Boolean)encodingDesc[1];
                    stream.reset();
                    if (count > 2 && encoding.equals("UTF-8")) {
                        int b0 = b4[0] & 0xFF;
                        int b1 = b4[1] & 0xFF;
                        int b2 = b4[2] & 0xFF;
                        if (b0 == 239 && b1 == 187 && b2 == 191) {
                            stream.skip(3L);
                        }
                    }
                    reader = this.createReader(stream, encoding, isBigEndian);
                } else {
                    reader = this.createReader(stream, encoding, isBigEndian);
                }
            } else {
                if ((encoding = encoding.toUpperCase(Locale.ENGLISH)).equals("UTF-8")) {
                    int count;
                    int[] b3 = new int[3];
                    for (count = 0; count < 3; ++count) {
                        b3[count] = stream.read();
                        if (b3[count] == -1) break;
                    }
                    if (count == 3) {
                        if (b3[0] != 239 || b3[1] != 187 || b3[2] != 191) {
                            stream.reset();
                        }
                    } else {
                        stream.reset();
                    }
                } else if (encoding.equals("ISO-10646-UCS-4")) {
                    int count;
                    b4 = new int[4];
                    for (count = 0; count < 4; ++count) {
                        b4[count] = stream.read();
                        if (b4[count] == -1) break;
                    }
                    stream.reset();
                    if (count == 4) {
                        if (b4[0] == 0 && b4[1] == 0 && b4[2] == 0 && b4[3] == 60) {
                            isBigEndian = Boolean.TRUE;
                        } else if (b4[0] == 60 && b4[1] == 0 && b4[2] == 0 && b4[3] == 0) {
                            isBigEndian = Boolean.FALSE;
                        }
                    }
                } else if (encoding.equals("ISO-10646-UCS-2")) {
                    int count;
                    b4 = new int[4];
                    for (count = 0; count < 4; ++count) {
                        b4[count] = stream.read();
                        if (b4[count] == -1) break;
                    }
                    stream.reset();
                    if (count == 4) {
                        if (b4[0] == 0 && b4[1] == 60 && b4[2] == 0 && b4[3] == 63) {
                            isBigEndian = Boolean.TRUE;
                        } else if (b4[0] == 60 && b4[1] == 0 && b4[2] == 63 && b4[3] == 0) {
                            isBigEndian = Boolean.FALSE;
                        }
                    }
                }
                reader = this.createReader(stream, encoding, isBigEndian);
            }
        }
        this.fReaderStack.push(reader);
        if (this.fCurrentEntity != null) {
            this.fEntityStack.push(this.fCurrentEntity);
        }
        this.fCurrentEntity = new ScannedEntity(name, new XMLResourceIdentifierImpl(publicId, literalSystemId, baseSystemId, expandedSystemId), stream, reader, encoding, literal, false, isExternal);
        this.fCurrentEntity.setDeclaredEncoding(declaredEncoding);
        this.fEntityScanner.setCurrentEntity(this.fCurrentEntity);
        this.fResourceIdentifier.setValues(publicId, literalSystemId, baseSystemId, expandedSystemId);
        return encoding;
    }

    void setHttpProperties(URLConnection conn, XMLInputSource source) {
        if (source instanceof XIncludeInputSource) {
            String fAccept = null;
            String fAcceptCharset = null;
            String fAcceptLanguage = null;
            XIncludeInputSource xiSrc = (XIncludeInputSource)source;
            fAccept = (String)xiSrc.getProperty("Accept");
            fAcceptCharset = (String)xiSrc.getProperty("Accept-Charset");
            fAcceptLanguage = (String)xiSrc.getProperty("Accept-Language");
            if (fAccept != null && fAccept.length() > 0) {
                conn.setRequestProperty("Accept", fAccept);
            }
            if (fAcceptCharset != null && fAcceptCharset.length() > 0) {
                conn.setRequestProperty("Accept-Charset", fAcceptCharset);
            }
            if (fAcceptLanguage != null && fAcceptLanguage.length() > 0) {
                conn.setRequestProperty("Accept-Language", fAcceptLanguage);
            }
        }
    }

    public void setScannerVersion(short version) {
        if (version == 1) {
            if (this.fXML10EntityScanner == null) {
                this.fXML10EntityScanner = new XMLEntityScanner();
            }
            this.fXML10EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
            this.fEntityScanner = this.fXML10EntityScanner;
            this.fEntityScanner.setCurrentEntity(this.fCurrentEntity);
        } else {
            if (this.fXML11EntityScanner == null) {
                this.fXML11EntityScanner = new XML11EntityScanner();
            }
            this.fXML11EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
            this.fEntityScanner = this.fXML11EntityScanner;
            this.fEntityScanner.setCurrentEntity(this.fCurrentEntity);
        }
    }

    public XMLEntityScanner getEntityScanner() {
        if (this.fEntityScanner == null) {
            if (this.fXML10EntityScanner == null) {
                this.fXML10EntityScanner = new XMLEntityScanner();
            }
            this.fXML10EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
            this.fEntityScanner = this.fXML10EntityScanner;
        }
        return this.fEntityScanner;
    }

    public void closeReaders() {
        for (int i = this.fReaderStack.size() - 1; i >= 0; --i) {
            try {
                ((Reader)this.fReaderStack.pop()).close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        boolean parser_settings;
        try {
            parser_settings = componentManager.getFeature(PARSER_SETTINGS);
        }
        catch (XMLConfigurationException e) {
            parser_settings = true;
        }
        if (!parser_settings) {
            this.reset();
            return;
        }
        try {
            this.fValidation = componentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fValidation = false;
        }
        try {
            this.fExternalGeneralEntities = componentManager.getFeature(EXTERNAL_GENERAL_ENTITIES);
        }
        catch (XMLConfigurationException e) {
            this.fExternalGeneralEntities = true;
        }
        try {
            this.fExternalParameterEntities = componentManager.getFeature(EXTERNAL_PARAMETER_ENTITIES);
        }
        catch (XMLConfigurationException e) {
            this.fExternalParameterEntities = true;
        }
        try {
            this.fAllowJavaEncodings = componentManager.getFeature(ALLOW_JAVA_ENCODINGS);
        }
        catch (XMLConfigurationException e) {
            this.fAllowJavaEncodings = false;
        }
        try {
            this.fWarnDuplicateEntityDef = componentManager.getFeature(WARN_ON_DUPLICATE_ENTITYDEF);
        }
        catch (XMLConfigurationException e) {
            this.fWarnDuplicateEntityDef = false;
        }
        try {
            this.fStrictURI = componentManager.getFeature(STANDARD_URI_CONFORMANT);
        }
        catch (XMLConfigurationException e) {
            this.fStrictURI = false;
        }
        try {
            this.fCharsetOverrideXmlEncoding = componentManager.getFeature("charset-overrides-xml-encoding");
        }
        catch (XMLConfigurationException e) {
            this.fCharsetOverrideXmlEncoding = true;
        }
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
        try {
            this.fEntityResolver = (XMLEntityResolver)componentManager.getProperty(ENTITY_RESOLVER);
        }
        catch (XMLConfigurationException e) {
            this.fEntityResolver = null;
        }
        try {
            this.fValidationManager = (ValidationManager)componentManager.getProperty(VALIDATION_MANAGER);
        }
        catch (XMLConfigurationException e) {
            this.fValidationManager = null;
        }
        try {
            this.fSecurityManager = (SecurityManager)componentManager.getProperty(SECURITY_MANAGER);
        }
        catch (XMLConfigurationException e) {
            this.fSecurityManager = null;
        }
        this.reset();
    }

    public void reset() {
        this.fEntityExpansionLimit = this.fSecurityManager != null ? this.fSecurityManager.getEntityExpansionLimit() : 0;
        this.fStandalone = false;
        this.fEntities.clear();
        this.fEntityStack.removeAllElements();
        this.fEntityExpansionCount = 0;
        this.fCurrentEntity = null;
        if (this.fXML10EntityScanner != null) {
            this.fXML10EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
        }
        if (this.fXML11EntityScanner != null) {
            this.fXML11EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
        }
        if (this.fDeclaredEntities != null) {
            Enumeration keys = this.fDeclaredEntities.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = this.fDeclaredEntities.get(key);
                this.fEntities.put(key, value);
            }
        }
        this.fEntityHandler = null;
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        int suffixLength;
        if (featureId.startsWith("http://apache.org/xml/features/") && (suffixLength = featureId.length() - "http://apache.org/xml/features/".length()) == "allow-java-encodings".length() && featureId.endsWith("allow-java-encodings")) {
            this.fAllowJavaEncodings = state;
        }
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            Integer bufferSize;
            int suffixLength = propertyId.length() - "http://apache.org/xml/properties/".length();
            if (suffixLength == "internal/symbol-table".length() && propertyId.endsWith("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)value;
                return;
            }
            if (suffixLength == "internal/error-reporter".length() && propertyId.endsWith("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)value;
                return;
            }
            if (suffixLength == "internal/entity-resolver".length() && propertyId.endsWith("internal/entity-resolver")) {
                this.fEntityResolver = (XMLEntityResolver)value;
                return;
            }
            if (suffixLength == "input-buffer-size".length() && propertyId.endsWith("input-buffer-size") && (bufferSize = (Integer)value) != null && bufferSize > 64) {
                this.fBufferSize = bufferSize;
                this.fEntityScanner.setBufferSize(this.fBufferSize);
            }
            if (suffixLength == "security-manager".length() && propertyId.endsWith("security-manager")) {
                this.fSecurityManager = (SecurityManager)value;
                this.fEntityExpansionLimit = this.fSecurityManager != null ? this.fSecurityManager.getEntityExpansionLimit() : 0;
            }
        }
    }

    public Boolean getFeatureDefault(String featureId) {
        for (int i = 0; i < RECOGNIZED_FEATURES.length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(featureId)) continue;
            return FEATURE_DEFAULTS[i];
        }
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        for (int i = 0; i < RECOGNIZED_PROPERTIES.length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(propertyId)) continue;
            return PROPERTY_DEFAULTS[i];
        }
        return null;
    }

    private static synchronized String getUserDir() {
        int i;
        int ch;
        String userDir = "";
        try {
            userDir = System.getProperty("user.dir");
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (userDir.length() == 0) {
            return "";
        }
        if (userDir.equals(gUserDir)) {
            return gEscapedUserDir;
        }
        gUserDir = userDir;
        char separator = File.separatorChar;
        userDir = userDir.replace(separator, '/');
        int len = userDir.length();
        StringBuffer buffer = new StringBuffer(len * 3);
        if (len >= 2 && userDir.charAt(1) == ':' && (ch = Character.toUpperCase(userDir.charAt(0))) >= 65 && ch <= 90) {
            buffer.append('/');
        }
        for (i = 0; i < len && (ch = userDir.charAt(i)) < 128; ++i) {
            if (gNeedEscaping[ch]) {
                buffer.append('%');
                buffer.append(gAfterEscaping1[ch]);
                buffer.append(gAfterEscaping2[ch]);
                continue;
            }
            buffer.append((char)ch);
        }
        if (i < len) {
            byte[] bytes = null;
            try {
                bytes = userDir.substring(i).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return userDir;
            }
            len = bytes.length;
            for (i = 0; i < len; ++i) {
                byte b = bytes[i];
                if (b < 0) {
                    ch = b + 256;
                    buffer.append('%');
                    buffer.append(gHexChs[ch >> 4]);
                    buffer.append(gHexChs[ch & 0xF]);
                    continue;
                }
                if (gNeedEscaping[b]) {
                    buffer.append('%');
                    buffer.append(gAfterEscaping1[b]);
                    buffer.append(gAfterEscaping2[b]);
                    continue;
                }
                buffer.append((char)b);
            }
        }
        if (!userDir.endsWith("/")) {
            buffer.append('/');
        }
        gEscapedUserDir = buffer.toString();
        return gEscapedUserDir;
    }

    public static String expandSystemId(String systemId, String baseSystemId, boolean strict) throws URI.MalformedURIException {
        if (strict) {
            if (systemId == null) {
                return null;
            }
            try {
                new URI(systemId);
                return systemId;
            }
            catch (URI.MalformedURIException ex) {
                URI base = null;
                if (baseSystemId == null || baseSystemId.length() == 0) {
                    base = new URI("file", "", XMLEntityManager.getUserDir(), null, null);
                } else {
                    try {
                        base = new URI(baseSystemId);
                    }
                    catch (URI.MalformedURIException e) {
                        String dir = XMLEntityManager.getUserDir();
                        dir = dir + baseSystemId;
                        base = new URI("file", "", dir, null, null);
                    }
                }
                URI uri = new URI(base, systemId);
                return uri.toString();
            }
        }
        if (systemId == null || systemId.length() == 0) {
            return systemId;
        }
        try {
            URI uri = new URI(systemId.trim());
            if (uri != null) {
                return systemId;
            }
        }
        catch (URI.MalformedURIException e) {
            // empty catch block
        }
        String id = XMLEntityManager.fixURI(systemId);
        URI base = null;
        URI uri = null;
        try {
            if (baseSystemId == null || baseSystemId.length() == 0 || baseSystemId.equals(systemId)) {
                String dir = XMLEntityManager.getUserDir();
                base = new URI("file", "", dir, null, null);
            } else {
                try {
                    base = new URI(XMLEntityManager.fixURI(baseSystemId).trim());
                }
                catch (URI.MalformedURIException e) {
                    if (baseSystemId.indexOf(58) != -1) {
                        base = new URI("file", "", XMLEntityManager.fixURI(baseSystemId).trim(), null, null);
                    }
                    String dir = XMLEntityManager.getUserDir();
                    dir = dir + XMLEntityManager.fixURI(baseSystemId);
                    base = new URI("file", "", dir, null, null);
                }
            }
            uri = new URI(base, id.trim());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (uri == null) {
            return systemId;
        }
        return uri.toString();
    }

    void endEntity() throws XNIException {
        if (this.fEntityHandler != null) {
            this.fEntityHandler.endEntity(this.fCurrentEntity.name, null);
        }
        try {
            this.fCurrentEntity.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.fReaderStack.isEmpty()) {
            this.fReaderStack.pop();
        }
        this.fCurrentEntity = this.fEntityStack.size() > 0 ? (ScannedEntity)this.fEntityStack.pop() : null;
        this.fEntityScanner.setCurrentEntity(this.fCurrentEntity);
    }

    protected Object[] getEncodingName(byte[] b4, int count) {
        if (count < 2) {
            return new Object[]{"UTF-8", null};
        }
        int b0 = b4[0] & 0xFF;
        int b1 = b4[1] & 0xFF;
        if (b0 == 254 && b1 == 255) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (b0 == 255 && b1 == 254) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (count < 3) {
            return new Object[]{"UTF-8", null};
        }
        int b2 = b4[2] & 0xFF;
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            return new Object[]{"UTF-8", null};
        }
        if (count < 4) {
            return new Object[]{"UTF-8", null};
        }
        int b3 = b4[3] & 0xFF;
        if (b0 == 0 && b1 == 0 && b2 == 0 && b3 == 60) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (b0 == 60 && b1 == 0 && b2 == 0 && b3 == 0) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(false)};
        }
        if (b0 == 0 && b1 == 0 && b2 == 60 && b3 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null};
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null};
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (b0 == 76 && b1 == 111 && b2 == 167 && b3 == 148) {
            return new Object[]{"CP037", null};
        }
        return new Object[]{"UTF-8", null};
    }

    protected Reader createReader(InputStream inputStream, String encoding, Boolean isBigEndian) throws IOException {
        String javaEncoding;
        String ENCODING;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if ((ENCODING = encoding.toUpperCase(Locale.ENGLISH)).equals("UTF-8")) {
            return new UTF8Reader(inputStream, this.fBufferSize, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        if (ENCODING.equals("ISO-10646-UCS-4")) {
            if (isBigEndian != null) {
                boolean isBE = isBigEndian;
                if (isBE) {
                    return new UCSReader(inputStream, 8);
                }
                return new UCSReader(inputStream, 4);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{encoding}, (short)2);
        }
        if (ENCODING.equals("ISO-10646-UCS-2")) {
            if (isBigEndian != null) {
                boolean isBE = isBigEndian;
                if (isBE) {
                    return new UCSReader(inputStream, 2);
                }
                return new UCSReader(inputStream, 1);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{encoding}, (short)2);
        }
        boolean validIANA = XMLChar.isValidIANAEncoding(encoding);
        boolean validJava = XMLChar.isValidJavaEncoding(encoding);
        if (!validIANA || this.fAllowJavaEncodings && !validJava) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{encoding}, (short)2);
            encoding = "ISO-8859-1";
        }
        if ((javaEncoding = EncodingMap.getIANA2JavaMapping(ENCODING)) == null) {
            if (this.fAllowJavaEncodings) {
                javaEncoding = encoding;
            } else {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{encoding}, (short)2);
                javaEncoding = "ISO8859_1";
            }
        } else if (javaEncoding.equals("ASCII")) {
            return new ASCIIReader(inputStream, this.fBufferSize, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        return new InputStreamReader(inputStream, javaEncoding);
    }

    protected static String fixURI(String str) {
        int pos;
        str = str.replace(File.separatorChar, '/');
        StringBuffer sb = null;
        if (str.length() >= 2) {
            char ch1 = str.charAt(1);
            if (ch1 == ':') {
                char ch0 = Character.toUpperCase(str.charAt(0));
                if (ch0 >= 'A' && ch0 <= 'Z') {
                    sb = new StringBuffer(str.length());
                    sb.append('/');
                }
            } else if (ch1 == '/' && str.charAt(0) == '/') {
                sb = new StringBuffer(str.length());
                sb.append("file:");
            }
        }
        if ((pos = str.indexOf(32)) < 0) {
            if (sb != null) {
                sb.append(str);
                str = sb.toString();
            }
        } else {
            int i;
            if (sb == null) {
                sb = new StringBuffer(str.length());
            }
            for (i = 0; i < pos; ++i) {
                sb.append(str.charAt(i));
            }
            sb.append("%20");
            for (i = pos + 1; i < str.length(); ++i) {
                if (str.charAt(i) == ' ') {
                    sb.append("%20");
                    continue;
                }
                sb.append(str.charAt(i));
            }
            str = sb.toString();
        }
        return str;
    }

    Hashtable getDeclaredEntities() {
        return this.fEntities;
    }

    static final void print(ScannedEntity currentEntity) {
    }

    static {
        gNeedEscaping = new boolean[128];
        gAfterEscaping1 = new char[128];
        gAfterEscaping2 = new char[128];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i <= 31; ++i) {
            XMLEntityManager.gNeedEscaping[i] = true;
            XMLEntityManager.gAfterEscaping1[i] = gHexChs[i >> 4];
            XMLEntityManager.gAfterEscaping2[i] = gHexChs[i & 0xF];
        }
        XMLEntityManager.gNeedEscaping[127] = true;
        XMLEntityManager.gAfterEscaping1[127] = 55;
        XMLEntityManager.gAfterEscaping2[127] = 70;
        char[] escChs = new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int len = escChs.length;
        for (int i = 0; i < len; ++i) {
            char ch = escChs[i];
            XMLEntityManager.gNeedEscaping[ch] = true;
            XMLEntityManager.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            XMLEntityManager.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
        }
    }

    protected final class RewindableInputStream
    extends InputStream {
        private InputStream fInputStream;
        private byte[] fData = new byte[64];
        private int fStartOffset;
        private int fEndOffset;
        private int fOffset;
        private int fLength;
        private int fMark;

        public RewindableInputStream(InputStream is) {
            this.fInputStream = is;
            this.fStartOffset = 0;
            this.fEndOffset = -1;
            this.fOffset = 0;
            this.fLength = 0;
            this.fMark = 0;
        }

        public void setStartOffset(int offset) {
            this.fStartOffset = offset;
        }

        public void rewind() {
            this.fOffset = this.fStartOffset;
        }

        public int read() throws IOException {
            int b = 0;
            if (this.fOffset < this.fLength) {
                return this.fData[this.fOffset++] & 0xFF;
            }
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            if (this.fOffset == this.fData.length) {
                byte[] newData = new byte[this.fOffset << 1];
                System.arraycopy(this.fData, 0, newData, 0, this.fOffset);
                this.fData = newData;
            }
            if ((b = this.fInputStream.read()) == -1) {
                this.fEndOffset = this.fOffset;
                return -1;
            }
            this.fData[this.fLength++] = (byte)b;
            ++this.fOffset;
            return b & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int bytesLeft = this.fLength - this.fOffset;
            if (bytesLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                if (XMLEntityManager.this.fCurrentEntity.mayReadChunks) {
                    return this.fInputStream.read(b, off, len);
                }
                int returnedVal = this.read();
                if (returnedVal == -1) {
                    this.fEndOffset = this.fOffset;
                    return -1;
                }
                b[off] = (byte)returnedVal;
                return 1;
            }
            if (len < bytesLeft) {
                if (len <= 0) {
                    return 0;
                }
            } else {
                len = bytesLeft;
            }
            if (b != null) {
                System.arraycopy(this.fData, this.fOffset, b, off, len);
            }
            this.fOffset += len;
            return len;
        }

        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int bytesLeft = this.fLength - this.fOffset;
            if (bytesLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return 0L;
                }
                return this.fInputStream.skip(n);
            }
            if (n <= (long)bytesLeft) {
                this.fOffset = (int)((long)this.fOffset + n);
                return n;
            }
            this.fOffset += bytesLeft;
            if (this.fOffset == this.fEndOffset) {
                return bytesLeft;
            }
            return this.fInputStream.skip(n -= (long)bytesLeft) + (long)bytesLeft;
        }

        public int available() throws IOException {
            int bytesLeft = this.fLength - this.fOffset;
            if (bytesLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return XMLEntityManager.this.fCurrentEntity.mayReadChunks ? this.fInputStream.available() : 0;
            }
            return bytesLeft;
        }

        public void mark(int howMuch) {
            this.fMark = this.fOffset;
        }

        public void reset() {
            this.fOffset = this.fMark;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() throws IOException {
            if (this.fInputStream != null) {
                this.fInputStream.close();
                this.fInputStream = null;
            }
        }
    }

    public class ScannedEntity
    extends Entity {
        public InputStream stream;
        public Reader reader;
        public XMLResourceIdentifier entityLocation;
        public int lineNumber = 1;
        public int columnNumber = 1;
        public String encoding;
        boolean declaredEncoding = false;
        public boolean literal;
        public boolean isExternal;
        public char[] ch = null;
        public int position;
        public int count;
        public boolean mayReadChunks;

        public ScannedEntity(String name, XMLResourceIdentifier entityLocation, InputStream stream, Reader reader, String encoding, boolean literal, boolean mayReadChunks, boolean isExternal) {
            super(name, XMLEntityManager.this.fInExternalSubset);
            this.entityLocation = entityLocation;
            this.stream = stream;
            this.reader = reader;
            this.encoding = encoding;
            this.literal = literal;
            this.mayReadChunks = mayReadChunks;
            this.isExternal = isExternal;
            this.ch = new char[isExternal ? XMLEntityManager.this.fBufferSize : 1024];
        }

        public final boolean isExternal() {
            return this.isExternal;
        }

        public final boolean isUnparsed() {
            return false;
        }

        public void setReader(InputStream stream, String encoding, Boolean isBigEndian) throws IOException {
            this.reader = XMLEntityManager.this.createReader(stream, encoding, isBigEndian);
        }

        public String getExpandedSystemId() {
            int size = XMLEntityManager.this.fEntityStack.size();
            for (int i = size - 1; i >= 0; --i) {
                ScannedEntity externalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (externalEntity.entityLocation == null || externalEntity.entityLocation.getExpandedSystemId() == null) continue;
                return externalEntity.entityLocation.getExpandedSystemId();
            }
            return null;
        }

        public String getLiteralSystemId() {
            int size = XMLEntityManager.this.fEntityStack.size();
            for (int i = size - 1; i >= 0; --i) {
                ScannedEntity externalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (externalEntity.entityLocation == null || externalEntity.entityLocation.getLiteralSystemId() == null) continue;
                return externalEntity.entityLocation.getLiteralSystemId();
            }
            return null;
        }

        public int getLineNumber() {
            int size = XMLEntityManager.this.fEntityStack.size();
            for (int i = size - 1; i > 0; --i) {
                ScannedEntity firstExternalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (!firstExternalEntity.isExternal()) continue;
                return firstExternalEntity.lineNumber;
            }
            return -1;
        }

        public int getColumnNumber() {
            int size = XMLEntityManager.this.fEntityStack.size();
            for (int i = size - 1; i > 0; --i) {
                ScannedEntity firstExternalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (!firstExternalEntity.isExternal()) continue;
                return firstExternalEntity.columnNumber;
            }
            return -1;
        }

        public String getEncoding() {
            int size = XMLEntityManager.this.fEntityStack.size();
            for (int i = size - 1; i > 0; --i) {
                ScannedEntity firstExternalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (!firstExternalEntity.isExternal()) continue;
                return firstExternalEntity.encoding;
            }
            return null;
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append("name=\"" + this.name + '\"');
            str.append(",ch=");
            str.append(this.ch);
            str.append(",position=" + this.position);
            str.append(",count=" + this.count);
            return str.toString();
        }

        public boolean isDeclaredEncoding() {
            return this.declaredEncoding;
        }

        public void setDeclaredEncoding(boolean value) {
            this.declaredEncoding = value;
        }
    }

    protected static class ExternalEntity
    extends Entity {
        public XMLResourceIdentifier entityLocation;
        public String notation;

        public ExternalEntity() {
            this.clear();
        }

        public ExternalEntity(String name, XMLResourceIdentifier entityLocation, String notation, boolean inExternalSubset) {
            super(name, inExternalSubset);
            this.entityLocation = entityLocation;
            this.notation = notation;
        }

        public final boolean isExternal() {
            return true;
        }

        public final boolean isUnparsed() {
            return this.notation != null;
        }

        public void clear() {
            super.clear();
            this.entityLocation = null;
            this.notation = null;
        }

        public void setValues(Entity entity) {
            super.setValues(entity);
            this.entityLocation = null;
            this.notation = null;
        }

        public void setValues(ExternalEntity entity) {
            super.setValues(entity);
            this.entityLocation = entity.entityLocation;
            this.notation = entity.notation;
        }
    }

    protected static class InternalEntity
    extends Entity {
        public String text;

        public InternalEntity() {
            this.clear();
        }

        public InternalEntity(String name, String text, boolean inExternalSubset) {
            super(name, inExternalSubset);
            this.text = text;
        }

        public final boolean isExternal() {
            return false;
        }

        public final boolean isUnparsed() {
            return false;
        }

        public void clear() {
            super.clear();
            this.text = null;
        }

        public void setValues(Entity entity) {
            super.setValues(entity);
            this.text = null;
        }

        public void setValues(InternalEntity entity) {
            super.setValues(entity);
            this.text = entity.text;
        }
    }

    public static abstract class Entity {
        public String name;
        public boolean inExternalSubset;

        public Entity() {
            this.clear();
        }

        public Entity(String name, boolean inExternalSubset) {
            this.name = name;
            this.inExternalSubset = inExternalSubset;
        }

        public boolean isEntityDeclInExternalSubset() {
            return this.inExternalSubset;
        }

        public abstract boolean isExternal();

        public abstract boolean isUnparsed();

        public void clear() {
            this.name = null;
            this.inExternalSubset = false;
        }

        public void setValues(Entity entity) {
            this.name = entity.name;
            this.inExternalSubset = entity.inExternalSubset;
        }
    }
}

