/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.traversers;

import com.sun.org.apache.xerces.internal.impl.dv.InvalidDatatypeFacetException;
import com.sun.org.apache.xerces.internal.impl.dv.SchemaDVFactory;
import com.sun.org.apache.xerces.internal.impl.dv.XSSimpleType;
import com.sun.org.apache.xerces.internal.impl.dv.xs.SchemaDVFactoryImpl;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaGrammar;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaSymbols;
import com.sun.org.apache.xerces.internal.impl.xs.XSAnnotationImpl;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSAttributeChecker;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDAbstractTraverser;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDHandler;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDocumentInfo;
import com.sun.org.apache.xerces.internal.impl.xs.util.XInt;
import com.sun.org.apache.xerces.internal.impl.xs.util.XSObjectListImpl;
import com.sun.org.apache.xerces.internal.util.DOMUtil;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xs.XSObject;
import com.sun.org.apache.xerces.internal.xs.XSObjectList;
import com.sun.org.apache.xerces.internal.xs.XSTypeDefinition;
import java.util.Vector;
import org.w3c.dom.Element;

class XSDSimpleTypeTraverser
extends XSDAbstractTraverser {
    private final SchemaDVFactory schemaFactory = SchemaDVFactory.getInstance();
    private boolean fIsBuiltIn = false;

    XSDSimpleTypeTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
        if (this.schemaFactory instanceof SchemaDVFactoryImpl) {
            ((SchemaDVFactoryImpl)this.schemaFactory).setDeclPool(handler.fDeclPool);
        }
    }

    XSSimpleType traverseGlobal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, true, schemaDoc);
        String nameAtt = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        XSSimpleType type = this.traverseSimpleTypeDecl(elmNode, attrValues, schemaDoc, grammar);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (nameAtt == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, SchemaSymbols.ATT_NAME}, elmNode);
            type = null;
        }
        if (type != null) {
            grammar.addGlobalTypeDecl(type);
        }
        return type;
    }

    XSSimpleType traverseLocal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, false, schemaDoc);
        XSSimpleType type = this.traverseSimpleTypeDecl(elmNode, attrValues, schemaDoc, grammar);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    private XSSimpleType traverseSimpleTypeDecl(Element simpleTypeDecl, Object[] attrValues, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        XSObjectList dvs;
        String name = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        XInt finalAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_FINAL];
        int finalProperty = finalAttr == null ? schemaDoc.fFinalDefault : finalAttr.intValue();
        Element child = DOMUtil.getFirstChildElement(simpleTypeDecl);
        XSObject[] annotations = null;
        if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
            XSAnnotationImpl annotation = this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
            if (annotation != null) {
                annotations = new XSAnnotationImpl[]{annotation};
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        if (child == null) {
            this.reportSchemaError("s4s-elt-must-match.2", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, "(annotation?, (restriction | list | union))"}, simpleTypeDecl);
            return this.errorType(name, schemaDoc.fTargetNamespace, (short)2);
        }
        String varietyProperty = DOMUtil.getLocalName(child);
        short refType = 2;
        boolean restriction = false;
        boolean list = false;
        boolean union = false;
        if (varietyProperty.equals(SchemaSymbols.ELT_RESTRICTION)) {
            refType = 2;
            restriction = true;
        } else if (varietyProperty.equals(SchemaSymbols.ELT_LIST)) {
            refType = 16;
            list = true;
        } else if (varietyProperty.equals(SchemaSymbols.ELT_UNION)) {
            refType = 8;
            union = true;
        } else {
            this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, "(annotation?, (restriction | list | union))", varietyProperty}, simpleTypeDecl);
            return this.errorType(name, schemaDoc.fTargetNamespace, (short)2);
        }
        Element nextChild = DOMUtil.getNextSiblingElement(child);
        if (nextChild != null) {
            this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, "(annotation?, (restriction | list | union))", DOMUtil.getLocalName(nextChild)}, nextChild);
        }
        Object[] contentAttrs = this.fAttrChecker.checkAttributes(child, false, schemaDoc);
        QName baseTypeName = (QName)contentAttrs[restriction ? XSAttributeChecker.ATTIDX_BASE : XSAttributeChecker.ATTIDX_ITEMTYPE];
        Vector memberTypes = (Vector)contentAttrs[XSAttributeChecker.ATTIDX_MEMBERTYPES];
        Element content = DOMUtil.getFirstChildElement(child);
        if (content != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
            XSAnnotationImpl annotation = this.traverseAnnotationDecl(content, contentAttrs, false, schemaDoc);
            if (annotation != null) {
                if (annotations == null) {
                    annotations = new XSAnnotationImpl[]{annotation};
                } else {
                    XSAnnotationImpl[] tempArray = new XSAnnotationImpl[2];
                    tempArray[0] = annotations[0];
                    annotations = tempArray;
                    annotations[1] = annotation;
                }
            }
            content = DOMUtil.getNextSiblingElement(content);
        }
        XSSimpleType baseValidator = null;
        if ((restriction || list) && baseTypeName != null && (baseValidator = this.findDTValidator(child, name, baseTypeName, refType, schemaDoc)) == null && this.fIsBuiltIn) {
            this.fIsBuiltIn = false;
            return null;
        }
        Vector<XSObject> dTValidators = null;
        XSSimpleType dv = null;
        if (union && memberTypes != null && memberTypes.size() > 0) {
            int size = memberTypes.size();
            dTValidators = new Vector<XSObject>(size, 2);
            for (int i = 0; i < size; ++i) {
                dv = this.findDTValidator(child, name, (QName)memberTypes.elementAt(i), (short)8, schemaDoc);
                if (dv == null) continue;
                if (dv.getVariety() == 3) {
                    dvs = dv.getMemberTypes();
                    for (int j = 0; j < dvs.getLength(); ++j) {
                        dTValidators.addElement(dvs.item(j));
                    }
                    continue;
                }
                dTValidators.addElement(dv);
            }
        }
        boolean skipFacets = false;
        if (content != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
            if (restriction || list) {
                if (baseTypeName != null) {
                    this.reportSchemaError(list ? "src-simple-type.3.a" : "src-simple-type.2.a", null, content);
                } else {
                    baseValidator = this.traverseLocal(content, schemaDoc, grammar);
                }
                content = DOMUtil.getNextSiblingElement(content);
            } else if (union) {
                if (dTValidators == null) {
                    dTValidators = new Vector(2, 2);
                }
                do {
                    if ((dv = this.traverseLocal(content, schemaDoc, grammar)) == null) continue;
                    if (dv.getVariety() == 3) {
                        dvs = dv.getMemberTypes();
                        for (int j = 0; j < dvs.getLength(); ++j) {
                            dTValidators.addElement(dvs.item(j));
                        }
                    } else {
                        dTValidators.addElement(dv);
                    }
                } while ((content = DOMUtil.getNextSiblingElement(content)) != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_SIMPLETYPE));
            }
        } else if ((restriction || list) && baseTypeName == null) {
            this.reportSchemaError(list ? "src-simple-type.3.b" : "src-simple-type.2.b", null, child);
            skipFacets = true;
            baseValidator = SchemaGrammar.fAnySimpleType;
        } else if (union && (memberTypes == null || memberTypes.size() == 0)) {
            this.reportSchemaError("src-union-memberTypes-or-simpleTypes", null, child);
            dTValidators = new Vector(1);
            dTValidators.addElement(SchemaGrammar.fAnySimpleType);
        }
        if ((restriction || list) && baseValidator == null) {
            baseValidator = SchemaGrammar.fAnySimpleType;
        }
        if (union && (dTValidators == null || dTValidators.size() == 0)) {
            dTValidators = new Vector(1);
            dTValidators.addElement(SchemaGrammar.fAnySimpleType);
        }
        if (list && this.isListDatatype(baseValidator)) {
            this.reportSchemaError("cos-st-restricts.2.1", new Object[]{name, baseValidator.getName()}, child);
        }
        XSSimpleType newDecl = null;
        if (restriction) {
            newDecl = this.schemaFactory.createTypeRestriction(name, schemaDoc.fTargetNamespace, (short)finalProperty, baseValidator, annotations == null ? null : new XSObjectListImpl(annotations, annotations.length));
        } else if (list) {
            newDecl = this.schemaFactory.createTypeList(name, schemaDoc.fTargetNamespace, (short)finalProperty, baseValidator, annotations == null ? null : new XSObjectListImpl(annotations, annotations.length));
        } else if (union) {
            XSSimpleType[] memberDecls = new XSSimpleType[dTValidators.size()];
            for (int i = 0; i < dTValidators.size(); ++i) {
                memberDecls[i] = (XSSimpleType)dTValidators.elementAt(i);
            }
            newDecl = this.schemaFactory.createTypeUnion(name, schemaDoc.fTargetNamespace, (short)finalProperty, memberDecls, annotations == null ? null : new XSObjectListImpl(annotations, annotations.length));
        }
        if (restriction && content != null) {
            XSDAbstractTraverser.FacetInfo fi = this.traverseFacets(content, baseValidator, schemaDoc);
            content = fi.nodeAfterFacets;
            if (!skipFacets) {
                try {
                    this.fValidationState.setNamespaceSupport(schemaDoc.fNamespaceSupport);
                    newDecl.applyFacets(fi.facetdata, fi.fPresentFacets, fi.fFixedFacets, this.fValidationState);
                }
                catch (InvalidDatatypeFacetException ex) {
                    this.reportSchemaError(ex.getKey(), ex.getArgs(), child);
                }
            }
        }
        if (content != null) {
            if (restriction) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_RESTRICTION, "(annotation?, (simpleType?, (minExclusive | minInclusive | maxExclusive | maxInclusive | totalDigits | fractionDigits | length | minLength | maxLength | enumeration | whiteSpace | pattern)*))", DOMUtil.getLocalName(content)}, content);
            } else if (list) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_LIST, "(annotation?, (simpleType?))", DOMUtil.getLocalName(content)}, content);
            } else if (union) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_UNION, "(annotation?, (simpleType*))", DOMUtil.getLocalName(content)}, content);
            }
        }
        this.fAttrChecker.returnAttrArray(contentAttrs, schemaDoc);
        return newDecl;
    }

    private XSSimpleType findDTValidator(Element elm, String refName, QName baseTypeStr, short baseRefContext, XSDocumentInfo schemaDoc) {
        if (baseTypeStr == null) {
            return null;
        }
        XSTypeDefinition baseType = (XSTypeDefinition)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, baseTypeStr, elm);
        if (baseType != null) {
            if (baseType.getTypeCategory() != 14 || baseType == SchemaGrammar.fAnySimpleType && baseRefContext == 2) {
                if (baseType == SchemaGrammar.fAnySimpleType && this.checkBuiltIn(refName, schemaDoc.fTargetNamespace)) {
                    return null;
                }
                this.reportSchemaError("cos-st-restricts.1.1", new Object[]{baseTypeStr.rawname, refName}, elm);
                return SchemaGrammar.fAnySimpleType;
            }
            if ((baseType.getFinal() & baseRefContext) != 0) {
                if (baseRefContext == 2) {
                    this.reportSchemaError("st-props-correct.3", new Object[]{refName, baseTypeStr.rawname}, elm);
                } else if (baseRefContext == 16) {
                    this.reportSchemaError("cos-st-restricts.2.3.1.1", new Object[]{baseTypeStr.rawname, refName}, elm);
                } else if (baseRefContext == 8) {
                    this.reportSchemaError("cos-st-restricts.3.3.1.1", new Object[]{baseTypeStr.rawname, refName}, elm);
                }
            }
        }
        return (XSSimpleType)baseType;
    }

    private final boolean checkBuiltIn(String name, String namespace) {
        if (namespace != SchemaSymbols.URI_SCHEMAFORSCHEMA) {
            return false;
        }
        if (SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl(name) != null) {
            this.fIsBuiltIn = true;
        }
        return this.fIsBuiltIn;
    }

    private boolean isListDatatype(XSSimpleType validator) {
        if (validator.getVariety() == 2) {
            return true;
        }
        if (validator.getVariety() == 3) {
            XSObjectList temp = validator.getMemberTypes();
            for (int i = 0; i < temp.getLength(); ++i) {
                if (((XSSimpleType)temp.item(i)).getVariety() != 2) continue;
                return true;
            }
        }
        return false;
    }

    private XSSimpleType errorType(String name, String namespace, short refType) {
        switch (refType) {
            case 2: {
                return this.schemaFactory.createTypeRestriction(name, namespace, (short)0, SchemaGrammar.fAnySimpleType, null);
            }
            case 16: {
                return this.schemaFactory.createTypeList(name, namespace, (short)0, SchemaGrammar.fAnySimpleType, null);
            }
            case 8: {
                return this.schemaFactory.createTypeUnion(name, namespace, (short)0, new XSSimpleType[]{SchemaGrammar.fAnySimpleType}, null);
            }
        }
        return null;
    }
}

