/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.impl.xs.opti.DefaultXMLDocumentHandler;
import com.sun.org.apache.xerces.internal.util.AttributesProxy;
import com.sun.org.apache.xerces.internal.util.LocatorProxy;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XNI2SAX
extends DefaultXMLDocumentHandler {
    private ContentHandler fContentHandler;
    private String fVersion;
    protected NamespaceContext fNamespaceContext;
    private final AttributesProxy fAttributesProxy = new AttributesProxy();

    public void setContentHandler(ContentHandler handler) {
        this.fContentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        this.fVersion = version;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.fNamespaceContext = namespaceContext;
        this.fContentHandler.setDocumentLocator(new LocatorProxy(locator, this.fVersion));
        try {
            this.fContentHandler.startDocument();
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void endDocument(Augmentations augs) throws XNIException {
        try {
            this.fContentHandler.endDocument();
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        try {
            this.fContentHandler.processingInstruction(target, data.toString());
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        try {
            int count = this.fNamespaceContext.getDeclaredPrefixCount();
            if (count > 0) {
                String prefix = null;
                String uri = null;
                for (int i = 0; i < count; ++i) {
                    uri = this.fNamespaceContext.getURI(prefix = this.fNamespaceContext.getDeclaredPrefixAt(i));
                    this.fContentHandler.startPrefixMapping(prefix, uri == null ? "" : uri);
                }
            }
            String uri = element.uri != null ? element.uri : "";
            String localpart = element.localpart;
            this.fAttributesProxy.setAttributes(attributes);
            this.fContentHandler.startElement(uri, localpart, element.rawname, this.fAttributesProxy);
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        try {
            String uri = element.uri != null ? element.uri : "";
            String localpart = element.localpart;
            this.fContentHandler.endElement(uri, localpart, element.rawname);
            int count = this.fNamespaceContext.getDeclaredPrefixCount();
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.fContentHandler.endPrefixMapping(this.fNamespaceContext.getDeclaredPrefixAt(i));
                }
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        try {
            this.fContentHandler.characters(text.ch, text.offset, text.length);
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        try {
            this.fContentHandler.ignorableWhitespace(text.ch, text.offset, text.length);
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }
}

