/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.parsers;

import com.sun.org.apache.xerces.internal.parsers.XML11Configuration;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.xinclude.XIncludeHandler;
import com.sun.org.apache.xerces.internal.xinclude.XIncludeNamespaceSupport;
import com.sun.org.apache.xerces.internal.xni.XMLDocumentHandler;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarPool;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDocumentSource;

public class XIncludeParserConfiguration
extends XML11Configuration {
    private XIncludeHandler fXIncludeHandler;
    protected static final String ALLOW_UE_AND_NOTATION_EVENTS = "http://xml.org/sax/features/allow-dtd-events-after-endDTD";
    protected static final String XINCLUDE_AWARE = "http://apache.org/xml/features/xinclude-aware";
    protected static final String XINCLUDE_HANDLER = "http://apache.org/xml/properties/internal/xinclude-handler";
    protected static final String NAMESPACE_CONTEXT = "http://apache.org/xml/properties/internal/namespace-context";
    private boolean enableXInclude = false;

    public XIncludeParserConfiguration() {
        this(null, null, null);
    }

    public XIncludeParserConfiguration(SymbolTable symbolTable) {
        this(symbolTable, null, null);
    }

    public XIncludeParserConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this(symbolTable, grammarPool, null);
    }

    public XIncludeParserConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool, XMLComponentManager parentSettings) {
        super(symbolTable, grammarPool, parentSettings);
        String[] recognizedFeatures = new String[]{ALLOW_UE_AND_NOTATION_EVENTS, XINCLUDE_AWARE};
        this.addRecognizedFeatures(recognizedFeatures);
        this.fXIncludeHandler = new XIncludeHandler();
        this.addComponent(this.fXIncludeHandler);
        String[] recognizedProperties = new String[]{XINCLUDE_HANDLER, NAMESPACE_CONTEXT};
        this.addRecognizedProperties(recognizedProperties);
        this.setProperty(XINCLUDE_HANDLER, this.fXIncludeHandler);
        this.setProperty(NAMESPACE_CONTEXT, new XIncludeNamespaceSupport());
        this.setFeature(ALLOW_UE_AND_NOTATION_EVENTS, true);
        this.setFeature(XINCLUDE_AWARE, false);
    }

    protected void configurePipeline() {
        super.configurePipeline();
        if (this.enableXInclude) {
            this.fDTDScanner.setDTDHandler(this.fDTDProcessor);
            this.fDTDProcessor.setDTDSource(this.fDTDScanner);
            this.fDTDProcessor.setDTDHandler(this.fXIncludeHandler);
            this.fXIncludeHandler.setDTDSource(this.fDTDProcessor);
            this.fXIncludeHandler.setDTDHandler(this.fDTDHandler);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.setDTDSource(this.fXIncludeHandler);
            }
            XMLDocumentSource prev = null;
            if (this.fFeatures.get("http://apache.org/xml/features/validation/schema") == Boolean.TRUE) {
                prev = this.fSchemaValidator.getDocumentSource();
            } else {
                prev = this.fLastComponent;
                this.fLastComponent = this.fXIncludeHandler;
            }
            if (prev != null) {
                XMLDocumentHandler next = prev.getDocumentHandler();
                if (next != null) {
                    this.fXIncludeHandler.setDocumentHandler(next);
                    next.setDocumentSource(this.fXIncludeHandler);
                }
                prev.setDocumentHandler(this.fXIncludeHandler);
                this.fXIncludeHandler.setDocumentSource(prev);
            } else {
                this.setDocumentHandler(this.fXIncludeHandler);
            }
        }
    }

    protected void configureXML11Pipeline() {
        super.configureXML11Pipeline();
        if (this.enableXInclude) {
            this.addXML11Component(this.fXIncludeHandler);
            this.fXML11DTDScanner.setDTDHandler(this.fXML11DTDProcessor);
            this.fXML11DTDProcessor.setDTDSource(this.fXML11DTDScanner);
            this.fXML11DTDProcessor.setDTDHandler(this.fXIncludeHandler);
            this.fXIncludeHandler.setDTDSource(this.fXML11DTDProcessor);
            this.fXIncludeHandler.setDTDHandler(this.fDTDHandler);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.setDTDSource(this.fXIncludeHandler);
            }
            XMLDocumentSource prev = null;
            if (this.fFeatures.get("http://apache.org/xml/features/validation/schema") == Boolean.TRUE) {
                prev = this.fSchemaValidator.getDocumentSource();
            } else {
                prev = this.fLastComponent;
                this.fLastComponent = this.fXIncludeHandler;
            }
            XMLDocumentHandler next = prev.getDocumentHandler();
            prev.setDocumentHandler(this.fXIncludeHandler);
            this.fXIncludeHandler.setDocumentSource(prev);
            if (next != null) {
                this.fXIncludeHandler.setDocumentHandler(next);
                next.setDocumentSource(this.fXIncludeHandler);
            }
        }
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.equals(XINCLUDE_HANDLER)) {
            // empty if block
        }
        super.setProperty(propertyId, value);
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        if (featureId.equals(XINCLUDE_AWARE)) {
            this.enableXInclude = state;
        }
        super.setFeature(featureId, state);
    }
}

